/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.commands;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayerNode;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleCartesianTriangularMeshMapLayerVisibilityCommandHandler
extends AbstractHandler
implements IHandler {
    private static final Logger Logger = LoggerFactory.getLogger(ToggleCartesianTriangularMeshMapLayerVisibilityCommandHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (Object selection : (IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)) {
            if (!(selection instanceof CartesianTriangularMeshMapLayer)) continue;
            final CartesianTriangularMeshMapLayer layer = (CartesianTriangularMeshMapLayer)selection;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AbstractMapLayerNode node = layer.getAbstractMapLayerNode();
                    NodePresentation nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)node);
                    if (nodePresentation != null) {
                        nodePresentation.setVisible(!nodePresentation.isVisible());
                    }
                }
            };
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

