/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.emf.AbstractTimeSource;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.FixedTimeSource;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.CelestialBody;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.impl.CelestialBodyLineOfSightImageMapLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelestialBodyLineOfSightImageMapLayerCustomImpl
extends CelestialBodyLineOfSightImageMapLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CelestialBodyLineOfSightImageMapLayerCustomImpl.class);

    @Override
    public void updateImage(IProgressMonitor progressMonitor) {
        Point3d position = this.computeObserverPosition();
        Tuple3d observerPosition = null;
        if (position != null) {
            observerPosition = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)position);
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.FIXED_POSITION_LINE_OF_SIGHT_IMAGE_MAP_LAYER__OBSERVER_POSITION, (Object)observerPosition, true);
        if (observerPosition == null) {
            Logger.error("No Celestial Body found !");
            throw new RuntimeException("No Celestial Body found !");
        }
        super.updateImage(progressMonitor);
    }

    protected Point3d computeObserverPosition() {
        Point3d observerPosition = null;
        CelestialBody celestialBody = this.resolveCelestialBody();
        if (celestialBody != null) {
            AbstractTimeSource previousTime = ApogyCoreEnvironmentFacade.INSTANCE.getActiveTimeSource();
            ApogyEnvironment env = ApogyCoreEnvironmentFacade.INSTANCE.getActiveApogyEnvironment();
            try {
                FixedTimeSource temporaryTimeSource = ApogyCommonEMFFactory.eINSTANCE.createFixedTimeSource();
                temporaryTimeSource.setTime(this.getTime());
                temporaryTimeSource.setName(this.getName());
                temporaryTimeSource.setOffset(0);
                Logger.info("Changing Time Source to <" + temporaryTimeSource.getName() + "> to update observer position...");
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)env, (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_TIME_SOURCE, (Object)temporaryTimeSource, true);
                Matrix4d celestialBodyToOrigin = ApogyCommonTopologyFacade.INSTANCE.expressRootInNodeFrame((Node)celestialBody);
                Matrix4d meshToOrigin = ApogyCommonTopologyFacade.INSTANCE.expressRootInNodeFrame((Node)this.getMap().getMapNode());
                Matrix4d transform = new Matrix4d(celestialBodyToOrigin);
                transform.invert();
                transform.mul(meshToOrigin);
                Vector3d position = new Vector3d();
                transform.get(position);
                double r = position.length();
                double elevation = Math.asin(position.z / r);
                System.out.println("Elevation (deg) : " + Math.toDegrees(elevation));
                double az = Math.atan2(position.y, position.x);
                System.out.println("Azimuth (deg) : " + Math.toDegrees(az));
                observerPosition = new Point3d((javax.vecmath.Tuple3d)position);
            }
            catch (Exception e) {
                Logger.error("Error occured during computation of observer position !", (Throwable)e);
            }
            Logger.info("Changing Time Source back to original <" + previousTime.getName() + "> .");
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)env, (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_TIME_SOURCE, (Object)previousTime, true);
        }
        return observerPosition;
    }

    protected CelestialBody resolveCelestialBody() {
        Node root;
        EList nodes;
        CelestialBody celestialBody = null;
        EClass celestialBodyClass = this.getCelestialBodyType();
        if (celestialBodyClass != null && !(nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(celestialBodyClass, root = ApogyCommonTopologyFacade.INSTANCE.findRoot((Node)this.getMap().getMapNode()))).isEmpty()) {
            celestialBody = (CelestialBody)nodes.get(0);
        }
        return celestialBody;
    }
}

