/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import java.util.Collection;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.INodeVisitor;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ReferencedGroupNode;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayerNode;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.impl.MapNodeImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapNodeCustomImpl
extends MapNodeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(MapNodeImpl.class);
    private ReferencedGroupNode referencedGroupNode = null;
    private Adapter adapter = null;

    protected MapNodeCustomImpl() {
        this.eAdapters().add((Object)this.getAdapter());
    }

    public void accept(INodeVisitor visitor) {
        if (visitor.getType().isInstance(this)) {
            visitor.visit((Node)this);
        }
        for (Node child : this.getChildren()) {
            child.accept(visitor);
        }
    }

    private void clearTopology() {
        this.getReferencedGroupNode().getChildren().clear();
    }

    protected void addLayer(AbstractMapLayer layer) {
        this.getReferencedGroupNode().getChildren().add((Object)layer.getAbstractMapLayerNode());
        Logger.info("Added layer <" + layer.getName() + ">.");
    }

    protected void removeLayer(AbstractMapLayer layer) {
        AbstractMapLayerNode layerNode = layer.getAbstractMapLayerNode();
        if (layerNode != null) {
            this.getReferencedGroupNode().getChildren().remove((Object)layerNode);
        }
        Logger.info("Removed layer <" + layer.getName() + ">.");
    }

    private ReferencedGroupNode getReferencedGroupNode() {
        if (this.referencedGroupNode == null) {
            this.referencedGroupNode = ApogyCommonTopologyFactory.eINSTANCE.createReferencedGroupNode();
            this.referencedGroupNode.setDescription("Map Group Node.");
            this.referencedGroupNode.setNodeId("Map Content (" + this.getMap().getName() + ")");
            this.getChildren().add((Object)this.referencedGroupNode);
        }
        return this.referencedGroupNode;
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof MapNodeCustomImpl) {
                        if (msg.getFeatureID(MapNodeCustomImpl.class) == 8) {
                            MapNodeCustomImpl.this.clearTopology();
                            if (msg.getOldValue() instanceof Map) {
                                ((Map)msg.getOldValue()).eAdapters().remove((Object)MapNodeCustomImpl.this.getAdapter());
                            }
                            if (msg.getNewValue() instanceof Map) {
                                ((Map)msg.getNewValue()).eAdapters().add((Object)MapNodeCustomImpl.this.getAdapter());
                            }
                        }
                    } else if (msg.getNotifier() instanceof Map) {
                        Matrix4x4 matrix;
                        if (msg.getFeatureID(Map.class) == 3) {
                            final Notification message = msg;
                            Job job = new Job("MapNode Modify Layers"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        switch (message.getEventType()) {
                                            case 3: {
                                                AbstractMapLayer layerAdded = (AbstractMapLayer)message.getNewValue();
                                                MapNodeCustomImpl.this.addLayer(layerAdded);
                                                break;
                                            }
                                            case 5: {
                                                Collection layersAdded = (Collection)message.getNewValue();
                                                for (AbstractMapLayer abstractMapLayer : layersAdded) {
                                                    MapNodeCustomImpl.this.addLayer(abstractMapLayer);
                                                }
                                                break;
                                            }
                                            case 4: {
                                                AbstractMapLayer layerRemoved = (AbstractMapLayer)message.getOldValue();
                                                MapNodeCustomImpl.this.removeLayer(layerRemoved);
                                                break;
                                            }
                                            case 6: {
                                                Collection layersRemoved = (Collection)message.getOldValue();
                                                for (AbstractMapLayer abstractMapLayer : layersRemoved) {
                                                    MapNodeCustomImpl.this.removeLayer(abstractMapLayer);
                                                }
                                                break;
                                            }
                                        }
                                        return Status.OK_STATUS;
                                    }
                                    catch (Throwable t) {
                                        Logger.error(t.getMessage(), t);
                                        return Status.OK_STATUS;
                                    }
                                }
                            };
                            job.setPriority(30);
                            job.schedule();
                        } else if (msg.getFeatureID(Map.class) == 2 && (matrix = (Matrix4x4)msg.getNewValue()) != null) {
                            MapNodeCustomImpl.this.setTransformation(matrix.asMatrix4d());
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

