/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.core.environment.surface.ShaderBasedMeshToolType;
import org.eclipse.apogy.core.environment.surface.impl.ShaderBasedAngularDisplayMeshToolImpl;

public class ShaderBasedAngularDisplayMeshToolCustomImpl
extends ShaderBasedAngularDisplayMeshToolImpl {
    public static final int TOOL_LINE_COLOR_RED_INDEX = 3;
    public static final int TOOL_LINE_COLOR_GREEN_INDEX = 4;
    public static final int TOOL_LINE_COLOR_BLUE_INDEX = 5;
    public static final int TOOL_MIN_RADIUS_INDEX = 6;
    public static final int TOOL_MAX_RADIUS_INDEX = 7;
    public static final int TOOL_START_ANGLE_INDEX = 8;
    public static final int TOOL_END_ANGLE_INDEX = 9;
    public static final int TOOL_ANGLE_INTERVAL_INDEX = 10;
    public static final int TOOL_LINE_WIDTH_INDEX = 11;
    public static final int TOOL_MATRIX_0_0_INDEX = 12;
    public static final int TOOL_MATRIX_0_1_INDEX = 13;
    public static final int TOOL_MATRIX_0_2_INDEX = 14;
    public static final int TOOL_MATRIX_0_3_INDEX = 15;
    public static final int TOOL_MATRIX_1_0_INDEX = 16;
    public static final int TOOL_MATRIX_1_1_INDEX = 17;
    public static final int TOOL_MATRIX_1_2_INDEX = 18;
    public static final int TOOL_MATRIX_1_3_INDEX = 19;
    public static final int TOOL_MATRIX_2_0_INDEX = 20;
    public static final int TOOL_MATRIX_2_1_INDEX = 21;
    public static final int TOOL_MATRIX_2_2_INDEX = 22;
    public static final int TOOL_MATRIX_2_3_INDEX = 23;
    public static final int TOOL_MATRIX_3_0_INDEX = 24;
    public static final int TOOL_MATRIX_3_1_INDEX = 25;
    public static final int TOOL_MATRIX_3_2_INDEX = 26;
    public static final int TOOL_MATRIX_3_3_INDEX = 27;

    @Override
    public ShaderBasedMeshToolType getToolType() {
        return ShaderBasedMeshToolType.ANGULAR;
    }

    @Override
    public void setAngleInterval(float newAngleInterval) {
        super.setAngleInterval(Math.abs(newAngleInterval));
    }

    @Override
    public void setMinimumRadius(float newMinimumRadius) {
        super.setMinimumRadius(Math.abs(newMinimumRadius));
    }

    @Override
    public void setMaximumRadius(float newMaximumRadius) {
        super.setMaximumRadius(Math.abs(newMaximumRadius));
    }

    @Override
    public void setLineWidth(float newLineWidth) {
        super.setLineWidth(Math.abs(newLineWidth));
    }

    @Override
    public float[] createShaderParameters() {
        float[] parameters = super.createShaderParameters();
        parameters[3] = new Float((float)this.getLineColor().rgb.red / 255.0f).floatValue();
        parameters[4] = new Float((float)this.getLineColor().rgb.green / 255.0f).floatValue();
        parameters[5] = new Float((float)this.getLineColor().rgb.blue / 255.0f).floatValue();
        parameters[6] = Math.abs(this.getMinimumRadius());
        parameters[7] = Math.abs(this.getMaximumRadius());
        parameters[8] = new Float(Math.toRadians(this.getStartAngle())).floatValue();
        parameters[9] = new Float(Math.toRadians(this.getEndAngle())).floatValue();
        parameters[10] = new Float(Math.abs(Math.toRadians(this.getAngleInterval()))).floatValue();
        parameters[11] = Math.abs(this.getLineWidth());
        Matrix4d matrix = new Matrix4d();
        matrix.setIdentity();
        if (this.getRotationMatrix() != null) {
            matrix.setRotation(this.getRotationMatrix().asMatrix3d());
        }
        if (this.getPosition() != null) {
            matrix.setTranslation(new Vector3d(this.getPosition().asTuple3d()));
        }
        matrix.invert();
        parameters[12] = new Float(matrix.m00).floatValue();
        parameters[13] = new Float(matrix.m01).floatValue();
        parameters[14] = new Float(matrix.m02).floatValue();
        parameters[15] = new Float(matrix.m03).floatValue();
        parameters[16] = new Float(matrix.m10).floatValue();
        parameters[17] = new Float(matrix.m11).floatValue();
        parameters[18] = new Float(matrix.m12).floatValue();
        parameters[19] = new Float(matrix.m13).floatValue();
        parameters[20] = new Float(matrix.m20).floatValue();
        parameters[21] = new Float(matrix.m21).floatValue();
        parameters[22] = new Float(matrix.m22).floatValue();
        parameters[23] = new Float(matrix.m23).floatValue();
        parameters[24] = new Float(matrix.m30).floatValue();
        parameters[25] = new Float(matrix.m31).floatValue();
        parameters[26] = new Float(matrix.m32).floatValue();
        parameters[27] = new Float(matrix.m33).floatValue();
        return parameters;
    }
}

