/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.PoseProvider;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayerNode;
import org.eclipse.apogy.core.environment.surface.VariableBasedShaderBasedMeshTool;
import org.eclipse.apogy.core.environment.surface.impl.VariableBasedShaderBasedMeshToolPoseAdapterImpl;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.TypeApiAdapter;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.widgets.Display;

public class VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl
extends VariableBasedShaderBasedMeshToolPoseAdapterImpl {
    private Adapter poseAdapter;
    private Adapter variableFeatureReferenceAdapter;
    private Adapter sessionAdapter;
    private ApogySystemApiAdapter apogySystemApiAdapter;

    @Override
    public void setVariableBasedShaderBasedMeshTool(VariableBasedShaderBasedMeshTool newVariableBasedShaderBasedMeshTool) {
        super.setVariableBasedShaderBasedMeshTool(newVariableBasedShaderBasedMeshTool);
        if (!ApogyCoreInvocatorFacade.INSTANCE.eAdapters().contains((Object)this.getSessionAdapter())) {
            ApogyCoreInvocatorFacade.INSTANCE.eAdapters().add((Object)this.getSessionAdapter());
        }
        if (newVariableBasedShaderBasedMeshTool != null) {
            this.updateVariableFeatureReference(newVariableBasedShaderBasedMeshTool.getVariableFeatureReference());
        } else {
            this.updateVariableFeatureReference(null);
        }
        ApogySystemApiAdapter oldApogySystemApiAdapter = this.apogySystemApiAdapter;
        this.apogySystemApiAdapter = this.resolveApogySystemApiAdapter(newVariableBasedShaderBasedMeshTool.getVariableFeatureReference());
        this.apogySystemApiAdapterChanged(oldApogySystemApiAdapter, this.apogySystemApiAdapter);
    }

    private void updateVariableFeatureReference(VariableFeatureReference newVariableFeatureReference) {
        if (this.getVariableBasedShaderBasedMeshTool() != null && this.getVariableBasedShaderBasedMeshTool().getVariableFeatureReference() != null) {
            this.getVariableBasedShaderBasedMeshTool().getVariableFeatureReference().eAdapters().remove((Object)this.getVariableFeatureReferenceAdapter());
        }
        if (newVariableFeatureReference != null) {
            newVariableFeatureReference.eAdapters().add((Object)this.getVariableFeatureReferenceAdapter());
        }
        ApogySystemApiAdapter oldApogySystemApiAdapter = this.apogySystemApiAdapter;
        this.apogySystemApiAdapter = this.resolveApogySystemApiAdapter(newVariableFeatureReference);
        this.apogySystemApiAdapterChanged(oldApogySystemApiAdapter, this.apogySystemApiAdapter);
    }

    @Override
    public void dispose() {
        this.updateVariableFeatureReference(null);
        if (this.apogySystemApiAdapter != null) {
            this.apogySystemApiAdapter.eAdapters().remove((Object)this.getPoseAdapter());
        }
        ApogyCoreInvocatorFacade.INSTANCE.eAdapters().remove((Object)this.getSessionAdapter());
    }

    protected void apogySystemApiAdapterChanged(ApogySystemApiAdapter oldApogySystemApiAdapter, ApogySystemApiAdapter newApogySystemApiAdapter) {
        if (oldApogySystemApiAdapter != null) {
            oldApogySystemApiAdapter.eAdapters().remove((Object)this.getPoseAdapter());
        }
        if (newApogySystemApiAdapter != null) {
            newApogySystemApiAdapter.eAdapters().add((Object)this.getPoseAdapter());
        }
        this.apogySystemApiAdapter = newApogySystemApiAdapter;
        this.updatePose();
    }

    protected void updatePose() {
        if (this.apogySystemApiAdapter != null && this.apogySystemApiAdapter.getPoseTransform() != null && this.getVariableBasedShaderBasedMeshTool().getMeshMapLayer() != null) {
            try {
                CartesianTriangularMeshMapLayerNode meshNode = this.getVariableBasedShaderBasedMeshTool().getMeshMapLayer().getCartesianTriangularMeshMapLayerNode();
                Node variableNode = ApogyCoreTopologyFacade.INSTANCE.getVariableOriginNode(this.getVariableBasedShaderBasedMeshTool().getVariableFeatureReference().getVariable());
                Matrix4d transform = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(variableNode, (Node)meshNode);
                Vector3d pose = new Vector3d();
                transform.get(pose);
                final Tuple3d position = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)pose);
                Matrix3d rot = new Matrix3d();
                rot.setIdentity();
                transform.get(rot);
                final Matrix3x3 rotation = ApogyCommonMathFacade.INSTANCE.createMatrix3x3(rot);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.getVariableBasedShaderBasedMeshTool().isUpdatePosition()) {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.getVariableBasedShaderBasedMeshTool(), (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.SHADER_BASED_MESH_TOOL__POSITION, (Object)position, true);
                        }
                        if (VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.getVariableBasedShaderBasedMeshTool().isUpdateOrientation()) {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.getVariableBasedShaderBasedMeshTool(), (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.SHADER_BASED_MESH_TOOL__ROTATION_MATRIX, (Object)rotation, true);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected ApogySystemApiAdapter resolveApogySystemApiAdapter(VariableFeatureReference variableFeatureReference) {
        ApogySystemApiAdapter apogySystemApiAdapter = null;
        if (variableFeatureReference != null && variableFeatureReference.getVariable() != null && ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() != null) {
            try {
                TypeApiAdapter typeApiAdapter = ApogyCoreInvocatorFacade.INSTANCE.getTypeApiAdapter(variableFeatureReference);
                if (typeApiAdapter instanceof ApogySystemApiAdapter) {
                    apogySystemApiAdapter = (ApogySystemApiAdapter)typeApiAdapter;
                }
            }
            catch (Exception exception) {}
        }
        return apogySystemApiAdapter;
    }

    protected Adapter getSessionAdapter() {
        if (this.sessionAdapter == null) {
            this.sessionAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(ApogyCoreInvocatorFacade.class) == 0) {
                        ApogySystemApiAdapter oldApogySystemApiAdapter = VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.apogySystemApiAdapter;
                        VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.apogySystemApiAdapter = VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.resolveApogySystemApiAdapter(VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.getVariableBasedShaderBasedMeshTool().getVariableFeatureReference());
                        VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.apogySystemApiAdapterChanged(oldApogySystemApiAdapter, VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.apogySystemApiAdapter);
                    }
                }
            };
        }
        return this.sessionAdapter;
    }

    protected Adapter getVariableFeatureReferenceAdapter() {
        if (this.variableFeatureReferenceAdapter == null) {
            this.variableFeatureReferenceAdapter = new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    ApogySystemApiAdapter oldApogySystemApiAdapter = VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.apogySystemApiAdapter;
                    ApogySystemApiAdapter newApogySystemApiAdapter = VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.resolveApogySystemApiAdapter(VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.getVariableBasedShaderBasedMeshTool().getVariableFeatureReference());
                    VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.apogySystemApiAdapterChanged(oldApogySystemApiAdapter, newApogySystemApiAdapter);
                    super.notifyChanged(msg);
                }
            };
        }
        return this.variableFeatureReferenceAdapter;
    }

    protected Adapter getPoseAdapter() {
        if (this.poseAdapter == null) {
            this.poseAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof PoseProvider) {
                        int featureID = msg.getFeatureID(PoseProvider.class);
                        switch (featureID) {
                            case 0: {
                                if (!(msg.getNewValue() instanceof Matrix4x4)) break;
                                VariableBasedShaderBasedMeshToolPoseAdapterCustomImpl.this.updatePose();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.poseAdapter;
    }
}

