/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersFacade;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.ui.wizards.ExportToFileWizard;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.Named;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.core.PositionedResult;
import org.eclipse.apogy.core.invocator.AbstractResult;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.DataProductsList;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.apogy.core.invocator.OperationCallResultsList;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class DataProductsComposite
extends EMFFormsEListComposite<DataProductsList, OperationCallResultsList, AbstractResult> {
    public static Color EXCEPTION_COLOR = Display.getDefault().getSystemColor(3);
    private static final int NAME_COL_MIN_WIDTH = 200;
    private static final int DATE_COL_MIN_WIDTH = 200;
    private static final int POSITION_COL_MIN_WIDTH = 300;
    private static final int ORIENTATION_COL_MIN_WIDTH = 300;
    private static final String DEGREE_SYM = "\u00b0";

    public DataProductsComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.DATA_PRODUCTS_LIST__OPERATION_CALL_RESULTS_LIST}), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.RESULTS_LIST__RESULTS, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createDeleteButton(parent, style);
        this.createExportButton(parent, style);
    }

    protected Button createDeleteButton(Composite parent, int style) {
        Button btnDelete = DataProductsComposite.createButton((Composite)parent, (int)0, (String)"Delete", e -> {
            int size = this.getViewer().getStructuredSelection().toList().size();
            MessageDialog dialog = new MessageDialog(null, "Delete the selected elements", null, "Are you sure to delete " + (size > 1 ? "these " + size + " elements." : "this element?"), 3, new String[]{"Yes", "No"}, 1);
            if (dialog.open() == 0) {
                BusyIndicator.showWhile((Display)this.getDisplay(), () -> this.doDelete());
            }
            this.refreshViewer();
        });
        this.createDeleteButtonBindings(btnDelete);
        return btnDelete;
    }

    protected void doDelete() {
        List toDelete = this.getSelectedItemObjects();
        ApogyCommonTransactionFacade.INSTANCE.basicRemove(this.getResolvedEObject(), this.getEStructuralFeature(), (Collection)toDelete, true);
        this.getViewer().refresh();
    }

    protected void doDelete(AbstractResult object) {
        super.doDelete((Object)object);
    }

    protected void doExport() {
        AbstractResult abstractResult;
        IFileExporter iFileExporter;
        if (!this.getSelectedItemObjects().isEmpty() && (iFileExporter = ApogyCommonConvertersFacade.INSTANCE.getIFileExporter((Object)(abstractResult = (AbstractResult)this.getSelectedItemObjects().get(0)))) != null) {
            String defaultFileName = null;
            if (abstractResult instanceof Named) {
                Named named = (Named)abstractResult;
                defaultFileName = named.getName();
            }
            ExportToFileWizard wizard = new ExportToFileWizard(iFileExporter, (Object)abstractResult, defaultFileName);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn pinColumn = new TreeViewerColumn(viewer, 0);
        pinColumn.getColumn().setText("Name");
        pinColumn.getColumn().setAlignment(0x1000000);
        pinColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OperationCallResult operationCallResult;
                if (element instanceof OperationCallResult && (operationCallResult = (OperationCallResult)element).getOperationCall() != null) {
                    return operationCallResult.getOperationCall().getName();
                }
                if (element instanceof Named) {
                    return ((Named)element).getName();
                }
                if (element instanceof AbstractResult) {
                    AbstractResult abstractResult = (AbstractResult)element;
                    return abstractResult.getDescription();
                }
                return "?";
            }

            public Color getBackground(Object element) {
                return DataProductsComposite.this.hasException(element) != false ? EXCEPTION_COLOR : super.getBackground(element);
            }
        });
        pinColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn valueColumn = new TreeViewerColumn(viewer, 0);
        valueColumn.getColumn().setText("Date");
        valueColumn.getColumn().setAlignment(0x1000000);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Date date = ((AbstractResult)element).getTime();
                return ApogyCommonEMFFacade.INSTANCE.format(date);
            }

            public Color getBackground(Object element) {
                return DataProductsComposite.this.hasException(element) != false ? EXCEPTION_COLOR : super.getBackground(element);
            }
        });
        valueColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn positionColumn = new TreeViewerColumn(viewer, 0);
        positionColumn.getColumn().setText("Position (m)");
        positionColumn.getColumn().setAlignment(0x1000000);
        positionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private DecimalFormat decimalFormat = new DecimalFormat("0.000");

            public String getText(Object element) {
                if (element instanceof PositionedResult) {
                    Matrix4x4 pose = ((PositionedResult)element).getPose();
                    if (pose != null) {
                        Tuple3d position = ApogyCommonMathFacade.INSTANCE.extractPosition(pose).asTuple3d();
                        return String.valueOf(this.decimalFormat.format(position.x)) + ", " + this.decimalFormat.format(position.y) + ", " + this.decimalFormat.format(position.z);
                    }
                    return "null";
                }
                return "";
            }

            public Color getBackground(Object element) {
                return DataProductsComposite.this.hasException(element) != false ? EXCEPTION_COLOR : super.getBackground(element);
            }
        });
        positionColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)300);
        TreeViewerColumn orientationColumn = new TreeViewerColumn(viewer, 0);
        orientationColumn.getColumn().setText("Orientation (\u00b0)");
        orientationColumn.getColumn().setAlignment(0x1000000);
        orientationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private DecimalFormat decimalFormat = new DecimalFormat("0.0");

            public String getText(Object element) {
                if (element instanceof PositionedResult) {
                    Matrix4x4 pose = ((PositionedResult)element).getPose();
                    if (pose != null) {
                        Tuple3d position = ApogyCommonMathFacade.INSTANCE.extractOrientation(pose).asTuple3d();
                        return String.valueOf(this.decimalFormat.format(Math.toDegrees(position.x))) + ", " + this.decimalFormat.format(Math.toDegrees(position.y)) + ", " + this.decimalFormat.format(Math.toDegrees(position.z));
                    }
                    return "null";
                }
                return "";
            }

            public Color getBackground(Object element) {
                return DataProductsComposite.this.hasException(element) != false ? EXCEPTION_COLOR : super.getBackground(element);
            }
        });
        orientationColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)300);
    }

    public Boolean hasException(Object element) {
        OperationCallResult operationCallResult;
        if (element instanceof OperationCallResult && (operationCallResult = (OperationCallResult)element).getExceptionContainer() != null && operationCallResult.getExceptionContainer().getException() != null) {
            return true;
        }
        return false;
    }
}

