/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.core.invocator.ui.Activator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ApogyInvocatorUIPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPropertyChangeListener preferencesListener = null;
    private BooleanFieldEditor showStartButtonEditor;
    private BooleanFieldEditor showStopButtonEditor;
    private List<FieldEditor> fieldEditors = new ArrayList<FieldEditor>();

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group acquisitionGroup = new Group(container, 0);
        acquisitionGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        acquisitionGroup.setLayout((Layout)new GridLayout(2, true));
        acquisitionGroup.setText("Bottom Bar Configuration");
        this.showStartButtonEditor = new BooleanFieldEditor("APOGY_INVOCATOR_UI_SHOW_START_BUTTON_ID", "Show Start button:", (Composite)acquisitionGroup);
        this.showStartButtonEditor.setPreferenceStore(this.getPreferenceStore());
        this.showStartButtonEditor.load();
        this.fieldEditors.add((FieldEditor)this.showStartButtonEditor);
        this.showStopButtonEditor = new BooleanFieldEditor("APOGY_INVOCATOR_UI_SHOW_STOP_BUTTON_ID", "Show Stop button:", (Composite)acquisitionGroup);
        this.showStopButtonEditor.setPreferenceStore(this.getPreferenceStore());
        this.showStopButtonEditor.load();
        this.fieldEditors.add((FieldEditor)this.showStopButtonEditor);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
        this.updateControls();
        return container;
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.getPreferencesListener());
        super.dispose();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.storePreferences();
        super.performApply();
    }

    protected void performDefaults() {
        for (FieldEditor editor : this.fieldEditors) {
            try {
                editor.loadDefault();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        super.performDefaults();
    }

    private void updateControls() {
        for (FieldEditor editor : this.fieldEditors) {
            try {
                editor.load();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void storePreferences() {
        for (FieldEditor editor : this.fieldEditors) {
            try {
                editor.store();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ApogyInvocatorUIPreferencePage.this.updateControls();
                }
            };
        }
        return this.preferencesListener;
    }
}

