/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LongExecutionButtonManager {
    private static final Logger Logger = LoggerFactory.getLogger(LongExecutionButtonManager.class);
    protected Button managedButton = null;
    protected boolean confirmExecute = true;
    protected boolean notifyOnCompletion = true;
    protected String operationDescription = null;

    public LongExecutionButtonManager(Button managedButton, String operationDescription, boolean notifyOnCompletion) {
        this(managedButton, operationDescription, notifyOnCompletion, true);
    }

    public LongExecutionButtonManager(final Button managedButton, final String operationDescription, final boolean notifyOnCompletion, boolean confirmBeforeExecute) {
        this.managedButton = managedButton;
        this.confirmExecute = confirmBeforeExecute;
        this.operationDescription = operationDescription;
        this.notifyOnCompletion = notifyOnCompletion;
        managedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                managedButton.setEnabled(false);
                Logger.info("Launching execution of " + operationDescription);
                Job job = new Job(operationDescription){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            boolean proceed = false;
                            proceed = (this).LongExecutionButtonManager.this.confirmExecute ? LongExecutionButtonManager.this.userConfirmExecute() : true;
                            if (proceed) {
                                LongExecutionButtonManager.this.execute();
                                LongExecutionButtonManager.this.postExecuteWithSuccess();
                                if (notifyOnCompletion) {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                String message = LongExecutionButtonManager.this.getExecutionSuccessMessage();
                                                Logger.info(message);
                                                MessageDialog.openInformation((Shell)managedButton.getDisplay().getActiveShell(), (String)(String.valueOf(operationDescription) + " Success"), (String)message);
                                            }
                                            catch (Exception e) {
                                                Logger.error(e.getMessage(), (Throwable)e);
                                            }
                                        }
                                    });
                                }
                            } else {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        String message = LongExecutionButtonManager.this.getCancelMessage();
                                        LongExecutionButtonManager.this.postCancel();
                                        Logger.info(message);
                                        MessageDialog.openInformation((Shell)managedButton.getDisplay().getActiveShell(), (String)"Cancelled", (String)message);
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            LongExecutionButtonManager.this.postExecuteWithError(e);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    String message = LongExecutionButtonManager.this.getExecutionErrorMessage(e);
                                    Logger.info(message);
                                    MessageDialog.openError((Shell)managedButton.getDisplay().getActiveShell(), (String)"Error", (String)message);
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(30);
                job.schedule();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public String getPreExecutionMessage() {
        return this.operationDescription;
    }

    public String getExecutionSuccessMessage() {
        String message = String.valueOf(this.operationDescription) + " : Completed sucessfully.";
        return message;
    }

    public String getExecutionErrorMessage(Throwable t) {
        String message = "The following error occured during " + this.operationDescription + " : " + t.toString();
        return message;
    }

    public String getCancelMessage() {
        String message = String.valueOf(this.operationDescription) + " : Cancelled.";
        return message;
    }

    public void postExecuteWithSuccess() {
        UIJob uiJob = new UIJob(String.valueOf(this.operationDescription) + "postExecuteWithSuccess()"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (!LongExecutionButtonManager.this.managedButton.isDisposed()) {
                        LongExecutionButtonManager.this.managedButton.setEnabled(true);
                    }
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule();
    }

    public void postExecuteWithError(Throwable t) {
        UIJob uiJob = new UIJob(String.valueOf(this.operationDescription) + "postExecuteWithError(t)"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (!LongExecutionButtonManager.this.managedButton.isDisposed()) {
                        LongExecutionButtonManager.this.managedButton.setEnabled(true);
                    }
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule();
    }

    public void postCancel() {
        UIJob uiJob = new UIJob(String.valueOf(this.operationDescription) + "postCancel()"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (!LongExecutionButtonManager.this.managedButton.isDisposed()) {
                        LongExecutionButtonManager.this.managedButton.setEnabled(true);
                    }
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule();
    }

    public boolean userConfirmExecute() {
        boolean confirmed = false;
        try {
            UIJob uiJob = new UIJob(this.managedButton.getDisplay(), "Confirm " + this.operationDescription){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (MessageDialog.openConfirm((Shell)LongExecutionButtonManager.this.managedButton.getShell(), (String)"Confirm", (String)("Please confirm you want to do the following : \n\n" + LongExecutionButtonManager.this.getPreExecutionMessage()))) {
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            uiJob.schedule();
            uiJob.join();
            confirmed = uiJob.getResult() == Status.OK_STATUS;
        }
        catch (Exception exception) {
            confirmed = false;
        }
        return confirmed;
    }

    public abstract void execute() throws Exception;
}

