/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.controllers.provider;

import java.text.DecimalFormat;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersFormatProviderParameters;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersUnitsProviderParameters;
import org.eclipse.apogy.core.programs.controllers.CenteredLinearInputConditioning;
import org.eclipse.apogy.core.programs.controllers.ValueSource;
import org.eclipse.apogy.core.programs.controllers.provider.CenteredLinearInputConditioningItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.ETypedElement;

public class CenteredLinearInputConditioningCustomItemProvider
extends CenteredLinearInputConditioningItemProvider {
    private final DecimalFormat decimalFormat = new DecimalFormat("0.000");

    public CenteredLinearInputConditioningCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        ValueSource valueSource;
        String label = this.getString("_UI_CenteredLinearInputConditioning_type");
        CenteredLinearInputConditioning centeredLinearInputConditioning = (CenteredLinearInputConditioning)object;
        if (centeredLinearInputConditioning.eContainer() instanceof ValueSource && (valueSource = (ValueSource)centeredLinearInputConditioning.eContainer()).getBindedEDataTypeArgument() != null && valueSource.getBindedEDataTypeArgument().getEParameter() != null) {
            Unit modelUnit = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)valueSource.getBindedEDataTypeArgument().getEParameter());
            if (modelUnit != null) {
                EOperationEParametersUnitsProviderParameters unitsParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersUnitsProviderParameters();
                unitsParams.setParam(valueSource.getBindedEDataTypeArgument().getEParameter());
                Unit displayUnit = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(valueSource.getBindedEDataTypeArgument().getEParameter().getEOperation(), unitsParams);
                EOperationEParametersFormatProviderParameters formatParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersFormatProviderParameters();
                formatParams.setParam(valueSource.getBindedEDataTypeArgument().getEParameter());
                DecimalFormat format = ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat(valueSource.getBindedEDataTypeArgument().getEParameter().getEOperation(), formatParams);
                float min = centeredLinearInputConditioning.getMinimum();
                float max = centeredLinearInputConditioning.getMaximum();
                float deadBand = centeredLinearInputConditioning.getDeadBand();
                if (displayUnit != null && displayUnit != modelUnit) {
                    min = Double.valueOf(modelUnit.getConverterTo(displayUnit).convert((double)min)).floatValue();
                    max = Double.valueOf(modelUnit.getConverterTo(displayUnit).convert((double)max)).floatValue();
                    deadBand = Double.valueOf(modelUnit.getConverterTo(displayUnit).convert((double)deadBand)).floatValue();
                }
                label = String.valueOf(label) + " (min " + format.format(min);
                label = String.valueOf(label) + ", max " + format.format(max);
                label = String.valueOf(label) + ", dead band " + format.format(deadBand) + ")";
            } else {
                label = String.valueOf(label) + " (min " + this.decimalFormat.format(centeredLinearInputConditioning.getMinimum());
                label = String.valueOf(label) + ", max " + this.decimalFormat.format(centeredLinearInputConditioning.getMaximum());
                label = String.valueOf(label) + ", dead band " + this.decimalFormat.format(centeredLinearInputConditioning.getDeadBand()) + ")";
            }
        }
        return label;
    }
}

