/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.parts;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersFacade;
import org.eclipse.apogy.common.e4.ui.ApogyCommonE4UIFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionPart;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ApogyNodePresentationPart
extends AbstractSessionPart<EObject> {
    private boolean showNodeDetails = false;
    private Composite nodePresentationComposite;
    private ScrolledComposite nodePresentationCompositeScrolledComposite;
    private ScrolledComposite nodeDetailsScrolledComposite;
    private Composite nodeDetailsComposite;
    @Inject
    MPart mPart;

    @PostConstruct
    public void PostConstruct(MPart mPart) {
        Map persistedStateMap = mPart.getPersistedState();
        if (persistedStateMap.containsKey("ShowNodeOverviewSection")) {
            this.showNodeDetails = Boolean.valueOf((String)persistedStateMap.get("ShowNodeOverviewSection"));
        }
    }

    protected String getNoContentMessage() {
        return "No Node Presentation to display.";
    }

    protected void createComposite(Composite parent, int style) {
        if (this.showNodeDetails) {
            Composite top = new Composite(parent, 2048);
            top.setLayout((Layout)new GridLayout(2, true));
            Label labelPresentation = new Label(top, 0);
            labelPresentation.setText("Presentation Details");
            Label labelNode = new Label(top, 0);
            labelNode.setText("Node Details");
            this.nodePresentationCompositeScrolledComposite = new ScrolledComposite(top, 768);
            this.nodePresentationCompositeScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.nodePresentationCompositeScrolledComposite.setExpandHorizontal(true);
            this.nodePresentationCompositeScrolledComposite.setExpandVertical(true);
            this.nodePresentationComposite = new Composite((Composite)this.nodePresentationCompositeScrolledComposite, 0);
            this.nodePresentationComposite.setLayout((Layout)new FillLayout());
            this.nodePresentationCompositeScrolledComposite.setContent((Control)this.nodePresentationComposite);
            this.nodePresentationCompositeScrolledComposite.setMinSize(this.nodePresentationComposite.computeSize(-1, -1));
            this.nodeDetailsScrolledComposite = new ScrolledComposite(top, 768);
            this.nodeDetailsScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.nodeDetailsScrolledComposite.setExpandHorizontal(true);
            this.nodeDetailsScrolledComposite.setExpandVertical(true);
            this.nodeDetailsComposite = new Composite((Composite)this.nodeDetailsScrolledComposite, 0);
            this.nodeDetailsComposite.setLayout((Layout)new FillLayout());
            this.nodeDetailsScrolledComposite.setContent((Control)this.nodeDetailsComposite);
            this.nodeDetailsScrolledComposite.setMinSize(this.nodeDetailsComposite.computeSize(-1, -1));
            top.layout();
        } else {
            Composite top = new Composite(parent, 0);
            top.setLayout((Layout)new GridLayout(1, false));
            Label labelPresentation = new Label(top, 0);
            labelPresentation.setText("Presentation Details");
            this.nodePresentationCompositeScrolledComposite = new ScrolledComposite(top, 768);
            this.nodePresentationCompositeScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.nodePresentationCompositeScrolledComposite.setExpandHorizontal(true);
            this.nodePresentationCompositeScrolledComposite.setExpandVertical(true);
            this.nodePresentationComposite = new Composite((Composite)this.nodePresentationCompositeScrolledComposite, 0);
            this.nodePresentationComposite.setLayout((Layout)new FillLayout());
            this.nodePresentationCompositeScrolledComposite.setContent((Control)this.nodePresentationComposite);
            this.nodePresentationCompositeScrolledComposite.setMinSize(this.nodePresentationComposite.computeSize(-1, -1));
            top.layout();
        }
    }

    protected void doSetContent(EObject rootEObject) {
        if (rootEObject instanceof NodePresentation) {
            NodePresentation nodePresentation = (NodePresentation)rootEObject;
            if (!this.nodePresentationComposite.isDisposed()) {
                if (this.showNodeDetails) {
                    ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.nodePresentationComposite, rootEObject);
                    this.nodePresentationCompositeScrolledComposite.setMinSize(this.nodePresentationComposite.computeSize(-1, -1));
                    VView viewModel = ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createDefaultViewModel((EObject)nodePresentation.getNode());
                    ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.nodeDetailsComposite, (EObject)nodePresentation.getNode(), viewModel);
                    this.nodeDetailsScrolledComposite.setMinSize(this.nodeDetailsComposite.computeSize(-1, -1));
                } else {
                    ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.nodePresentationComposite, rootEObject);
                    this.nodePresentationCompositeScrolledComposite.setMinSize(this.nodePresentationComposite.computeSize(-1, -1));
                }
            }
        }
    }

    @Inject
    @Optional
    public void setSelection(@Named(value="org.eclipse.ui.selection") Node node, EPartService ePartService) {
        if ((ApogyCommonE4UIFacade.INSTANCE.isActive(ePartService, "org.eclipse.apogy.core.topology.ui.part.3D") || ApogyCommonE4UIFacade.INSTANCE.isActive(ePartService, "org.eclipse.apogy.core.topology.ui.nodeSearch") || ApogyCommonE4UIFacade.INSTANCE.isActive(ePartService, "org.eclipse.apogy.core.topology.ui.topoTreeEditor") || ApogyCommonE4UIFacade.INSTANCE.isActive(ePartService, "org.eclipse.apogy.core.topology.ui.part.apogysystemtopology") || ApogyCommonE4UIFacade.INSTANCE.isActive(ePartService, "org.eclipse.apogy.core.topology.ui.part.apogysystem3dviewer")) && node != null) {
            try {
                NodePresentation selectedNodePresentation = (NodePresentation)ApogyCommonConvertersFacade.INSTANCE.convert((Object)node, NodePresentation.class);
                this.setContent((EObject)selectedNodePresentation);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Inject
    @Optional
    public void setSelection(@Named(value="org.eclipse.ui.selection") NodeSelection nodeSelection, EPartService ePartService) {
        Node selectedNode;
        if ((ApogyCommonE4UIFacade.INSTANCE.isActive(ePartService, "org.eclipse.apogy.core.topology.ui.part.apogysystem3dviewer") || ApogyCommonE4UIFacade.INSTANCE.isActive(ePartService, "org.eclipse.apogy.core.topology.ui.part.3D")) && (selectedNode = nodeSelection.getSelectedNode()) != null) {
            NodePresentation selectedNodePresentation = (NodePresentation)ApogyCommonConvertersFacade.INSTANCE.convert((Object)selectedNode, NodePresentation.class);
            this.setContent((EObject)selectedNodePresentation);
        }
    }
}

