/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.wizards;

import org.eclipse.apogy.common.topology.AttachedViewPoint;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.topology.ui.composites.AttachedViewPointComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AttachedViewPointWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.topology.ui.wizards.TransformNodeWizardPage";
    private final AttachedViewPoint attachedViewPoint;
    private Adapter adapter;
    private AttachedViewPointComposite attachedViewPointComposite;

    public AttachedViewPointWizardPage(AttachedViewPoint attachedViewPoint) {
        super(WIZARD_PAGE_ID);
        this.attachedViewPoint = attachedViewPoint;
        this.setTitle("Attached View Point");
        this.setDescription("Sets the Attached View Point attachment node.");
        if (attachedViewPoint != null) {
            attachedViewPoint.eAdapters().add((Object)this.getAdapter());
        }
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.attachedViewPointComposite = new AttachedViewPointComposite(top, 0, this.attachedViewPoint){

            @Override
            protected void nodeSelected(Node selectedNode) {
                AttachedViewPointWizardPage.this.validate();
            }
        };
        this.attachedViewPointComposite.setAttachedViewPoint(this.attachedViewPoint);
        this.attachedViewPointComposite.setLayoutData(new GridData(4, 4, true, true));
        this.setControl((Control)top);
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AttachedViewPointWizardPage.this.attachedViewPointComposite != null && !AttachedViewPointWizardPage.this.attachedViewPointComposite.isDisposed()) {
                    AttachedViewPointWizardPage.this.attachedViewPointComposite.dispose();
                }
                if (AttachedViewPointWizardPage.this.attachedViewPoint != null) {
                    AttachedViewPointWizardPage.this.attachedViewPoint.eAdapters().remove((Object)AttachedViewPointWizardPage.this.getAdapter());
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.attachedViewPoint.getName() == null) {
            this.setErrorMessage("Name is not set !");
        } else if (this.attachedViewPoint.getNodePath() == null) {
            this.setErrorMessage("Node is not set !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    AttachedViewPointWizardPage.this.validate();
                }
            };
        }
        return this.adapter;
    }
}

