/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ReferencedContentNode;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.PositionedResult;
import org.eclipse.apogy.core.ResultNode;
import org.eclipse.apogy.core.impl.ApogyCoreFacadeImpl;
import org.eclipse.apogy.core.invocator.AbstractTypeImplementation;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.AttributeResultValue;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.ReferenceResultValue;
import org.eclipse.apogy.core.invocator.TypeApiAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ApogyCoreFacadeCustomImpl
extends ApogyCoreFacadeImpl {
    @Override
    public Matrix4x4 computeAbsolutePoseMatrix(ApogySystem apogySystem, Matrix4x4 relativePose) {
        Node root = ApogyCommonTopologyFacade.INSTANCE.findRoot(apogySystem.getTopologyRoot().getOriginNode());
        Matrix4d systemPose = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(apogySystem.getTopologyRoot().getOriginNode(), root);
        Matrix4x4 pose = relativePose;
        Matrix4d matrix = new Matrix4d();
        matrix.setIdentity();
        if (pose != null) {
            matrix = pose.asMatrix4d();
        }
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        m.mul(systemPose, matrix);
        return ApogyCommonMathFacade.INSTANCE.createMatrix4x4(m);
    }

    @Override
    public ResultNode createResultNode(PositionedResult result) {
        ReferenceResultValue referenceResultValue;
        ResultNode resultNode = ApogyCoreFactory.eINSTANCE.createResultNode();
        resultNode.setResult(result);
        Date time = result.getTime();
        if (time == null) {
            time = new Date();
        }
        resultNode.setNodeId(this.createNodeID(result));
        resultNode.setDescription(result.getDescription());
        if (result.getResultValue() instanceof AttributeResultValue) {
            AttributeResultValue attributeResultValue = (AttributeResultValue)result.getResultValue();
            attributeResultValue.getValue();
        } else if (result.getResultValue() instanceof ReferenceResultValue && (referenceResultValue = (ReferenceResultValue)result.getResultValue()).getValue() != null) {
            if (referenceResultValue.getValue() instanceof Node) {
                Node node = (Node)EcoreUtil.copy((EObject)((Node)referenceResultValue.getValue()));
                resultNode.getChildren().add((Object)node);
            } else {
                EObject content = referenceResultValue.getValue();
                ReferencedContentNode contentNode = ApogyCommonTopologyFacade.INSTANCE.createReferencedContentNode((Object)content);
                resultNode.getChildren().add((Object)contentNode);
            }
        }
        return resultNode;
    }

    @Override
    public ApogySystem getApogySystem(Environment environment, String fullyQualifiedName) {
        TypeApiAdapter typeApiAdapter;
        ApogySystem result = null;
        AbstractTypeImplementation typeImplementation = ApogyCoreInvocatorFacade.INSTANCE.getTypeImplementation(environment, fullyQualifiedName);
        if (typeImplementation != null && (typeApiAdapter = typeImplementation.getAdapterInstance()) instanceof ApogySystemApiAdapter) {
            ApogySystemApiAdapter apogySystemApiAdapter = (ApogySystemApiAdapter)typeApiAdapter;
            result = apogySystemApiAdapter.getApogySystem();
        }
        return result;
    }

    @Override
    public ApogySystem getApogySystem(Environment environment, EObject instance) {
        ApogySystem result = null;
        AbstractTypeImplementation abstractTypeImplementation = ApogyCoreInvocatorFacade.INSTANCE.findAbstractTypeImplementation(instance);
        if (abstractTypeImplementation != null && abstractTypeImplementation.getAdapterInstance() instanceof ApogySystemApiAdapter) {
            ApogySystemApiAdapter apogySystemApiAdapter = (ApogySystemApiAdapter)abstractTypeImplementation.getAdapterInstance();
            result = apogySystemApiAdapter.getApogySystem();
        }
        return result;
    }

    @Override
    public ApogySystem loadApogySystemFromFile(String apogySystemFileAbsolutePath) throws Exception {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("key", new XMIResourceFactoryImpl());
        TransactionalEditingDomain domain = ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain();
        ResourceSet resSet = domain.getResourceSet();
        Resource resource = resSet.createResource(URI.createFileURI((String)apogySystemFileAbsolutePath));
        resource.load(m);
        ApogySystem apogySystem = (ApogySystem)resource.getContents().get(0);
        return apogySystem;
    }

    @Override
    public void saveApogySystemToFile(ApogySystem apogySystem, String apogySystemFileAbsolutePath) throws Exception {
        TransactionalEditingDomain domain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)apogySystem);
        if (domain == null) {
            domain = ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain();
        }
        ResourceSet resourceSet = domain.getResourceSet();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)apogySystemFileAbsolutePath));
        domain.getCommandStack().execute((Command)new AddCommand((EditingDomain)domain, resource.getContents(), (Object)apogySystem));
        resource.save(Collections.EMPTY_MAP);
    }

    @Override
    public List<FeatureOfInterest> loadFeatureOfInterestFromFile(String urlString) throws Exception {
        ArrayList<FeatureOfInterest> foiList = new ArrayList<FeatureOfInterest>();
        URL url = new URL(urlString);
        File tempFile = this.copyURLContent(url);
        BufferedReader reader = new BufferedReader(new FileReader(tempFile));
        String line = null;
        while ((line = reader.readLine()) != null) {
            FeatureOfInterest foi = this.parserCSVLine(line = line.trim());
            if (foi == null) continue;
            foiList.add(foi);
        }
        reader.close();
        return foiList;
    }

    private FeatureOfInterest parserCSVLine(String line) throws Exception {
        FeatureOfInterest foi = null;
        String[] entries = line.split(",");
        if (entries.length < 8) {
            throw new Exception("Line <" + line + "> contains too few entries !");
        }
        String name = entries[0];
        String description = entries[1];
        double x = Double.parseDouble(entries[2]);
        double y = Double.parseDouble(entries[3]);
        double z = Double.parseDouble(entries[4]);
        double rx = Double.parseDouble(entries[5]);
        double ry = Double.parseDouble(entries[6]);
        double rz = Double.parseDouble(entries[7]);
        foi = ApogyCoreFactory.eINSTANCE.createFeatureOfInterest();
        foi.setName(name);
        foi.setDescription(description);
        TransformNode tmp = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(x, y, z, rx, ry, rz);
        Matrix4d m = tmp.asMatrix4d();
        foi.setPose(ApogyCommonMathFacade.INSTANCE.createMatrix4x4(m));
        return foi;
    }

    @Override
    public void saveFeatureOfInterestToFile(String path, List<FeatureOfInterest> foiList) throws Exception {
        String cvsData = this.convertToCSV(foiList);
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        writer.write(cvsData);
        writer.close();
    }

    private String convertToCSV(List<FeatureOfInterest> foiList) {
        String csvString = new String();
        for (FeatureOfInterest foi : foiList) {
            csvString = foi.getName() != null ? String.valueOf(csvString) + foi.getName().replaceAll(",", ";") + "," : String.valueOf(csvString) + ",";
            csvString = foi.getDescription() != null ? String.valueOf(csvString) + foi.getDescription().replaceAll(",", ";") + "," : String.valueOf(csvString) + ",";
            Tuple3d position = ApogyCommonMathFacade.INSTANCE.extractPosition(foi.getPose());
            csvString = String.valueOf(csvString) + position.getX() + ",";
            csvString = String.valueOf(csvString) + position.getY() + ",";
            csvString = String.valueOf(csvString) + position.getZ() + ",";
            Tuple3d orientation = ApogyCommonMathFacade.INSTANCE.extractOrientation(foi.getPose());
            csvString = String.valueOf(csvString) + orientation.getX() + ",";
            csvString = String.valueOf(csvString) + orientation.getY() + ",";
            csvString = String.valueOf(csvString) + orientation.getZ() + "\n";
        }
        return csvString;
    }

    private File copyURLContent(URL url) throws Exception {
        File tempFile = null;
        String fileName = this.getFileName(url);
        String fileExtension = this.getFileExtension(url);
        tempFile = File.createTempFile(fileName, fileExtension);
        url.openConnection();
        InputStream reader = url.openStream();
        FileOutputStream writer = new FileOutputStream(tempFile);
        byte[] buffer = new byte[153600];
        int bytesRead = 0;
        while ((bytesRead = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, bytesRead);
            buffer = new byte[153600];
        }
        writer.close();
        reader.close();
        if (tempFile != null) {
            tempFile.deleteOnExit();
        }
        return tempFile;
    }

    private String getFileName(URL url) {
        String fileName = url.getFile();
        int startIndex = fileName.lastIndexOf(File.separator);
        int endIndex = fileName.lastIndexOf(".");
        if (startIndex > 0 && endIndex > 0) {
            fileName = fileName.substring(startIndex + 1, endIndex);
        }
        return fileName;
    }

    private String getFileExtension(URL url) {
        String fileExtension = url.getFile();
        int index = fileExtension.lastIndexOf(".");
        if (index > 0) {
            fileExtension = fileExtension.substring(index);
        }
        return fileExtension;
    }

    private String createNodeID(PositionedResult positionedResult) {
        String nodeId = positionedResult.eClass().getName();
        Date date = positionedResult.getTime();
        if (date != null) {
            nodeId = String.valueOf(nodeId) + " - " + date.toString();
        }
        return nodeId;
    }
}

