/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.services.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger Logger = LoggerFactory.getLogger(Activator.class);
    private static Activator plugin;

    public static Activator getDefault() {
        System.out.println("org.eclipse.apogy.services.logging.Activator.getDefault()");
        return plugin;
    }

    public void start(BundleContext bundleContext) throws Exception {
        plugin = this;
        try {
            this.configureLogbackInBundle(bundleContext.getBundle());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    private void configureLogbackInBundle(Bundle bundle) throws JoranException, IOException {
        Logger.info("Logger Factory Class : {}", (Object)LoggerFactory.getILoggerFactory().getClass().getName());
        Logger.info("Logger Class         : {}", (Object)Logger.getClass().getName());
        if (LoggerFactory.getILoggerFactory() instanceof LoggerContext) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext((Context)loggerContext);
            loggerContext.reset();
            URL logbackConfigFileUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("config/logback.xml"), null);
            jc.doConfigure(logbackConfigFileUrl.openStream());
            StatusPrinter.print((Context)loggerContext);
        } else {
            Logger.warn("Using default slf4j logging implementation !");
        }
    }
}

