/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.rcp.dialogs;

import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.apogy.common.ui.composites.URLSelectionComposite;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class IconURLDialog
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.surface.ui.wizards.IconURLDialog";
    private final MPerspective perspective;
    private URLSelectionComposite urlSelectionComposite;
    private ImageDisplayComposite imageDisplayComposite;
    private Label lblImageWidthValue;
    private Label lblImageHeightValue;
    private String urlString = null;
    private final IResourceUtilities<?> resourceUtilities;

    public IconURLDialog(MPerspective perspective, IResourceUtilities<?> resourceUtilities) {
        super(WIZARD_PAGE_ID);
        this.perspective = perspective;
        this.resourceUtilities = resourceUtilities;
        if (this.perspective != null) {
            this.urlString = perspective.getIconURI();
        }
        this.setTitle("Perspective Icon : URL selection");
        this.setDescription("Sets the Perspective Icon URL.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.urlSelectionComposite = new URLSelectionComposite(container, 0, new String[]{"*.gif", "*.png", "*.jpg", "*.jpeg"}, true, true, true){

            protected void urlStringSelected(String newURLString) {
                IconURLDialog.this.urlString = newURLString;
                IconURLDialog.this.validate();
            }
        };
        this.urlSelectionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.perspective != null && !this.perspective.getIconURI().equals("")) {
            this.urlSelectionComposite.setUrlString(this.perspective.getIconURI());
        }
        Group grImagePreview = new Group(container, 2048);
        grImagePreview.setText("Image Preview");
        grImagePreview.setLayout((Layout)new GridLayout(3, false));
        grImagePreview.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblImageWidth = new Label((Composite)grImagePreview, 0);
        lblImageWidth.setText("Image Width (pixels):");
        lblImageWidth.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.lblImageWidthValue = new Label((Composite)grImagePreview, 2048);
        GridData gd_lblImageWidthValue = new GridData(16384, 128, false, false, 1, 1);
        gd_lblImageWidthValue.widthHint = 100;
        gd_lblImageWidthValue.minimumWidth = 100;
        this.lblImageWidthValue.setLayoutData((Object)gd_lblImageWidthValue);
        this.imageDisplayComposite = new ImageDisplayComposite((Composite)grImagePreview, 2048);
        this.imageDisplayComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.imageDisplayComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                IconURLDialog.this.imageDisplayComposite.fitImage();
            }
        });
        Label lblImageHeight = new Label((Composite)grImagePreview, 0);
        lblImageHeight.setText("Image Height (pixels):");
        lblImageHeight.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.lblImageHeightValue = new Label((Composite)grImagePreview, 2048);
        GridData gd_lblImageHeightValue = new GridData(16384, 128, false, false, 1, 1);
        gd_lblImageHeightValue.widthHint = 100;
        gd_lblImageHeightValue.minimumWidth = 100;
        this.lblImageHeightValue.setLayoutData((Object)gd_lblImageHeightValue);
        this.setControl((Control)container);
        this.urlSelectionComposite.setFocus();
    }

    protected void validate() {
        String errorMessage = null;
        if (this.urlString != null) {
            URI uri = URI.createURI((String)this.urlString);
            ImageDescriptor descriptor = (ImageDescriptor)this.resourceUtilities.imageDescriptorFromURI(uri);
            if (descriptor == null || descriptor.createImage() == null) {
                this.setErrorMessage("Unable to load image");
            }
        } else {
            this.setErrorMessage("Unable to load image");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public String getUrlString() {
        return this.urlString;
    }
}

