/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.rcp.dialogs;

import org.eclipse.apogy.rcp.dialogs.IconURLDialog;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ModifyPerspectiveShortcutDialog
extends Dialog {
    private Text labelText;
    private Text toolTipText;
    private Text iconURIText;
    private Button checkBoxLabel;
    private Button checkBoxIcon;
    private final MPerspective perspective;
    private final IResourceUtilities<?> resourceUtilities;

    public ModifyPerspectiveShortcutDialog(Shell parentShell, MPerspective perspective, IResourceUtilities<?> resourceUtilities) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        this.perspective = perspective;
        this.resourceUtilities = resourceUtilities;
    }

    protected void configureShell(Shell shell) {
        shell.setText("Modify perspective shortcut");
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(4, false));
        Label label1 = new Label(composite, 0);
        label1.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Label labelDisplay = new Label(composite, 0);
        labelDisplay.setText("Display");
        labelDisplay.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 1, 1));
        Label labelLabel = new Label(composite, 0);
        labelLabel.setText("Label : ");
        labelLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, true, 1, 1));
        this.labelText = new Text(composite, 2052);
        this.labelText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        if (this.perspective.getLabel() != null) {
            this.labelText.setText(this.perspective.getLabel());
        }
        this.checkBoxLabel = new Button(composite, 32);
        this.checkBoxLabel.setSelection(this.perspective.getPersistedState().containsKey("Label") && ((String)this.perspective.getPersistedState().get("Label")).equals("true"));
        this.checkBoxLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 4).create());
        Label toolTipLabel = new Label(composite, 0);
        toolTipLabel.setText("ToolTip : ");
        toolTipLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, true, 1, 1));
        this.toolTipText = new Text(composite, 2052);
        this.toolTipText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        if (this.perspective.getTooltip() != null) {
            this.toolTipText.setText(this.perspective.getTooltip());
        }
        new Label(composite, 0);
        Label iconURILabel = new Label(composite, 0);
        iconURILabel.setText("Icon file : ");
        iconURILabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, true, 1, 1));
        this.iconURIText = new Text(composite, 2052);
        this.iconURIText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        if (this.perspective.getIconURI() != null) {
            this.iconURIText.setText(this.perspective.getIconURI());
        }
        Button iconURIButton = new Button(composite, 512);
        iconURIButton.setText("...");
        iconURIButton.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        iconURIButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Wizard wizard = new Wizard(){
                    IconURLDialog iconDialog;

                    public void addPages() {
                        this.iconDialog = new IconURLDialog(ModifyPerspectiveShortcutDialog.this.perspective, ModifyPerspectiveShortcutDialog.this.resourceUtilities);
                        this.addPage((IWizardPage)this.iconDialog);
                    }

                    public boolean performFinish() {
                        ModifyPerspectiveShortcutDialog.this.perspective.setIconURI(this.iconDialog.getUrlString());
                        ModifyPerspectiveShortcutDialog.this.iconURIText.setText(this.iconDialog.getUrlString());
                        return true;
                    }
                };
                WizardDialog dialog = new WizardDialog(ModifyPerspectiveShortcutDialog.this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        this.checkBoxIcon = new Button(composite, 32);
        this.checkBoxIcon.setSelection(this.perspective.getPersistedState().containsKey("Icon") && ((String)this.perspective.getPersistedState().get("Icon")).equals("true"));
        this.checkBoxIcon.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 4).create());
        return composite;
    }

    protected void okPressed() {
        this.perspective.getPersistedState().put("Label", String.valueOf(this.checkBoxLabel.getSelection()));
        this.perspective.getPersistedState().put("Icon", String.valueOf(this.checkBoxIcon.getSelection()));
        this.perspective.setLabel(this.labelText.getText());
        this.perspective.setTooltip(this.toolTipText.getText());
        this.perspective.setIconURI(this.iconURIText.getText());
        super.okPressed();
    }
}

