/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.workspace.ui.toolcontrols;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.apogy.workspace.ApogyWorkspaceFacade;
import org.eclipse.apogy.workspace.ApogyWorkspacePackage;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ActiveProjectToolControl {
    private static Image saveImage = null;
    private Label lblValue;
    private Button buttonSave;
    private DataBindingContext bindingContext;
    @Inject
    EModelService modelService;
    @Inject
    MTrimmedWindow window;

    @PostConstruct
    public void createControls(Composite parent) {
        MTrimBar trimBar = (MTrimBar)this.modelService.find("org.eclipse.apogy.rcp.trimbars.bottom", (MUIElement)this.window);
        List<String> unwantedItems = Arrays.asList("org.eclipse.ui.StatusLine", "org.eclipse.ui.HeapStatus", "org.eclipse.ui.ProgressBar");
        for (MTrimElement element : trimBar.getChildren()) {
            if (!unwantedItems.contains(element.getElementId())) continue;
            element.setVisible(false);
            element.setToBeRendered(false);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.buttonSave = new Button(composite, 8);
        GridData gd_buttonSave = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.buttonSave.setLayoutData((Object)gd_buttonSave);
        this.buttonSave.setToolTipText("Save the current session.");
        this.buttonSave.setImage(this.getSaveImage());
        this.buttonSave.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)Display.getDefault(), () -> ActiveProjectToolControl.this.doSave());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        this.lblValue = new Label(composite, 2048);
        GridData gd_labelValue = new GridData(4, 4, true, true, 1, 1);
        gd_labelValue.widthHint = 300;
        gd_labelValue.minimumWidth = 350;
        this.lblValue.setLayoutData((Object)gd_labelValue);
        this.initDataBindings();
    }

    private Image getSaveImage() {
        if (saveImage == null) {
            try {
                URL url = new URL("platform:/plugin/org.eclipse.apogy.workspace.ui/icons/save_session.gif");
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                saveImage = imageDescriptor.createImage();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return saveImage;
    }

    private void doSave() {
        try {
            ApogyWorkspaceFacade.INSTANCE.saveActiveProject();
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Apogy session saved", (String)("The Apogy session <" + ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName() + "> was saved successfully:\n\n"));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)("Unable to save" + ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName()), (String)e.getLocalizedMessage());
        }
    }

    private DataBindingContext initDataBindings() {
        this.bindingContext = new DataBindingContext();
        IObservableValue observeActiveProject = EMFProperties.value((EStructuralFeature)ApogyWorkspacePackage.Literals.APOGY_WORKSPACE_FACADE__ACTIVE_PROJECT).observe((Object)ApogyWorkspaceFacade.INSTANCE);
        ISWTObservableValue observeSaveButtonEnable = WidgetProperties.enabled().observe((Widget)this.buttonSave);
        this.bindingContext.bindValue((IObservableValue)observeSaveButtonEnable, observeActiveProject, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(IProject.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        ISWTObservableValue observeLabelValueText = WidgetProperties.text().observe((Widget)this.lblValue);
        this.bindingContext.bindValue((IObservableValue)observeLabelValueText, observeActiveProject, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(IProject.class, String.class){

            public Object convert(Object fromObject) {
                return fromObject != null ? ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName() : "No active project";
            }
        }));
        return this.bindingContext;
    }

    @PreDestroy
    public void dispose() {
        this.bindingContext.dispose();
    }
}

