/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.internal.node.client.SlaveClient;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.namespace.GraphName;

public class ParameterServer {
    private static final Log log = LogFactory.getLog(ParameterServer.class);
    private final Map<String, Object> tree = Maps.newConcurrentMap();
    private final Multimap<GraphName, NodeIdentifier> subscribers = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final GraphName masterName = GraphName.of("/master");

    public void subscribe(GraphName name, NodeIdentifier nodeIdentifier) {
        this.subscribers.put((Object)name, (Object)nodeIdentifier);
    }

    private Stack<String> getGraphNameParts(GraphName name) {
        Stack<String> parts = new Stack<String>();
        GraphName tip = name;
        while (!tip.isRoot()) {
            parts.add(tip.getBasename().toString());
            tip = tip.getParent();
        }
        return parts;
    }

    public Object get(GraphName name) {
        Preconditions.checkArgument((boolean)name.isGlobal());
        Stack<String> parts = this.getGraphNameParts(name);
        Object possibleSubtree = this.tree;
        while (!parts.empty() && possibleSubtree != null) {
            if (!(possibleSubtree instanceof Map)) {
                return null;
            }
            possibleSubtree = possibleSubtree.get(parts.pop());
        }
        return possibleSubtree;
    }

    private void setValue(GraphName name, Object value) {
        Preconditions.checkArgument((boolean)name.isGlobal());
        Stack<String> parts = this.getGraphNameParts(name);
        Map subtree = this.tree;
        while (!parts.empty()) {
            String part = parts.pop();
            if (parts.empty()) {
                subtree.put((String)part, (Object)value);
                continue;
            }
            if (subtree.containsKey(part) && subtree.get(part) instanceof Map) {
                subtree = (Map)subtree.get(part);
                continue;
            }
            HashMap newSubtree = Maps.newHashMap();
            subtree.put((String)part, (Object)newSubtree);
            subtree = newSubtree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void update(GraphName name, T value, Updater updater) {
        this.setValue(name, value);
        Multimap<GraphName, NodeIdentifier> multimap = this.subscribers;
        synchronized (multimap) {
            for (NodeIdentifier nodeIdentifier : this.subscribers.get((Object)name)) {
                SlaveClient client = new SlaveClient(this.masterName, nodeIdentifier.getUri());
                try {
                    updater.update(client);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public void set(final GraphName name, final boolean value) {
        this.update(name, value, new Updater(){

            @Override
            public void update(SlaveClient client) {
                client.paramUpdate(name, value);
            }
        });
    }

    public void set(final GraphName name, final int value) {
        this.update(name, value, new Updater(){

            @Override
            public void update(SlaveClient client) {
                client.paramUpdate(name, value);
            }
        });
    }

    public void set(final GraphName name, final double value) {
        this.update(name, value, new Updater(){

            @Override
            public void update(SlaveClient client) {
                client.paramUpdate(name, value);
            }
        });
    }

    public void set(final GraphName name, final String value) {
        this.update(name, value, new Updater(){

            @Override
            public void update(SlaveClient client) {
                client.paramUpdate(name, value);
            }
        });
    }

    public void set(final GraphName name, final List<?> value) {
        this.update(name, value, new Updater(){

            @Override
            public void update(SlaveClient client) {
                client.paramUpdate(name, value);
            }
        });
    }

    public void set(final GraphName name, final Map<?, ?> value) {
        this.update(name, value, new Updater(){

            @Override
            public void update(SlaveClient client) {
                client.paramUpdate(name, value);
            }
        });
    }

    public void delete(GraphName name) {
        Preconditions.checkArgument((boolean)name.isGlobal());
        Stack<String> parts = this.getGraphNameParts(name);
        Map subtree = this.tree;
        while (!parts.empty() && subtree.containsKey(parts.peek())) {
            String part = parts.pop();
            if (parts.empty()) {
                subtree.remove(part);
                continue;
            }
            subtree = (Map)subtree.get(part);
        }
    }

    public Object search(GraphName name) {
        throw new UnsupportedOperationException();
    }

    public boolean has(GraphName name) {
        Preconditions.checkArgument((boolean)name.isGlobal());
        Stack<String> parts = this.getGraphNameParts(name);
        Map subtree = this.tree;
        while (!parts.empty() && subtree.containsKey(parts.peek())) {
            String part = parts.pop();
            if (parts.empty()) continue;
            subtree = (Map)subtree.get(part);
        }
        return parts.empty();
    }

    private Set<GraphName> getSubtreeNames(GraphName parent, Map<String, Object> subtree, Set<GraphName> names) {
        for (String name : subtree.keySet()) {
            Object possibleSubtree = subtree.get(name);
            if (possibleSubtree instanceof Map) {
                names.addAll(this.getSubtreeNames(parent.join(GraphName.of(name)), (Map)possibleSubtree, names));
                continue;
            }
            names.add(parent.join(GraphName.of(name)));
        }
        return names;
    }

    public Collection<GraphName> getNames() {
        HashSet names = Sets.newHashSet();
        return this.getSubtreeNames(GraphName.root(), this.tree, names);
    }

    private static interface Updater {
        public void update(SlaveClient var1);
    }
}

