/*
 * Decompiled with CFR 0.152.
 */
package org.ros.node.topic;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ros.internal.node.CountDownRegistrantListener;
import org.ros.internal.node.topic.SubscriberIdentifier;
import org.ros.node.topic.Publisher;
import org.ros.node.topic.PublisherListener;

public class CountDownPublisherListener<T>
extends CountDownRegistrantListener<Publisher<T>>
implements PublisherListener<T> {
    private final CountDownLatch shutdownLatch;
    private final CountDownLatch newSubscriberLatch;

    public static <T> CountDownPublisherListener<T> newDefault() {
        return CountDownPublisherListener.newFromCounts(1, 1, 1, 1, 1);
    }

    public static <T> CountDownPublisherListener<T> newFromCounts(int masterRegistrationSuccessCount, int masterRegistrationFailureCount, int masterUnregistrationSuccessCount, int masterUnregistrationFailureCount, int newSubscriberCount) {
        return new CountDownPublisherListener<T>(new CountDownLatch(masterRegistrationSuccessCount), new CountDownLatch(masterRegistrationFailureCount), new CountDownLatch(masterUnregistrationSuccessCount), new CountDownLatch(masterUnregistrationFailureCount), new CountDownLatch(newSubscriberCount));
    }

    private CountDownPublisherListener(CountDownLatch masterRegistrationSuccessLatch, CountDownLatch masterRegistrationFailureLatch, CountDownLatch masterUnregistrationSuccessLatch, CountDownLatch masterUnregistrationFailureLatch, CountDownLatch newSubscriberLatch) {
        super(masterRegistrationSuccessLatch, masterRegistrationFailureLatch, masterUnregistrationSuccessLatch, masterUnregistrationFailureLatch);
        this.newSubscriberLatch = newSubscriberLatch;
        this.shutdownLatch = new CountDownLatch(1);
    }

    @Override
    public void onNewSubscriber(Publisher<T> publisher, SubscriberIdentifier subscriberIdentifier) {
        this.newSubscriberLatch.countDown();
    }

    @Override
    public void onShutdown(Publisher<T> publisher) {
        this.shutdownLatch.countDown();
    }

    public void awaitNewSubscriber() throws InterruptedException {
        this.newSubscriberLatch.await();
    }

    public boolean awaitNewSubscriber(long timeout, TimeUnit unit) throws InterruptedException {
        return this.newSubscriberLatch.await(timeout, unit);
    }

    public void awaitShutdown() throws InterruptedException {
        this.shutdownLatch.await();
    }

    public boolean awaitShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdownLatch.await(timeout, unit);
    }
}

