/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.gps;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GPSStatus implements Enumerator
{
    STOPPED(0, "STOPPED", "STOPPED"),
    RUNNING(1, "RUNNING", "RUNNING"),
    FAILED(2, "FAILED", "FAILED"),
    RECONNECTING(3, "RECONNECTING", "RECONNECTING"),
    CONNECTING(4, "CONNECTING", "CONNECTING");

    public static final int STOPPED_VALUE = 0;
    public static final int RUNNING_VALUE = 1;
    public static final int FAILED_VALUE = 2;
    public static final int RECONNECTING_VALUE = 3;
    public static final int CONNECTING_VALUE = 4;
    private static final GPSStatus[] VALUES_ARRAY;
    public static final List<GPSStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GPSStatus[]{STOPPED, RUNNING, FAILED, RECONNECTING, CONNECTING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GPSStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GPSStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GPSStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GPSStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GPSStatus get(int value) {
        switch (value) {
            case 0: {
                return STOPPED;
            }
            case 1: {
                return RUNNING;
            }
            case 2: {
                return FAILED;
            }
            case 3: {
                return RECONNECTING;
            }
            case 4: {
                return CONNECTING;
            }
        }
        return null;
    }

    private GPSStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

