/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.ui.jme3.utils;

import com.jme3.post.MultiTextureProjectorRenderer;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryList;
import java.awt.image.BufferedImage;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects.ProjectorData;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.ImageProjectorControl;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.JME3FovUtilities;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.RectifiedImageSnapshot;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;

public class ImageSnapshotProjectorControl
extends ImageProjectorControl<ImageSnapshot> {
    private final ImageSnapshot imageSnapshot;

    public ImageSnapshotProjectorControl(JME3Application jme3Application, ImageSnapshot imageSnapshot) {
        super(jme3Application, (Node)imageSnapshot);
        this.imageSnapshot = imageSnapshot;
    }

    public float getHorizontalFOVAngleDegrees() {
        return (float)Math.toDegrees(this.imageSnapshot.getFieldOfView().getHorizontalFieldOfViewAngle());
    }

    public float getTextureHtoVRatio() {
        return (float)(this.imageSnapshot.getFieldOfView().getHorizontalFieldOfViewAngle() / this.imageSnapshot.getFieldOfView().getVerticalFieldOfViewAngle());
    }

    public BufferedImage getProjectedImage() {
        AbstractEImage image = null;
        if (this.imageSnapshot instanceof RectifiedImageSnapshot) {
            image = ((RectifiedImageSnapshot)this.imageSnapshot).getRectifiedImage();
        }
        if (image == null) {
            image = this.imageSnapshot.getImage();
        }
        if (image != null) {
            EImage overlayImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            overlayImage.setImageContent(image.asBufferedImage());
            AbstractEImage transparentImage = EImagesUtilities.INSTANCE.createTransparentImage(overlayImage.getWidth(), overlayImage.getHeight());
            image = EImagesUtilities.INSTANCE.applyOverlay(transparentImage, (AbstractEImage)overlayImage, false);
        } else {
            image = this.getEmptyImage();
        }
        return this.rotateImage(image).asBufferedImage();
    }

    public void updateProjectorFOVSettings() {
        ProjectorData projectorData = this.getProjectorData();
        projectorData.projector.setParameter((Object)"CombineMode", (Object)MultiTextureProjectorRenderer.CombineMode.BLEND_COLOR_ADD_ALPHA);
        Camera projectorCamera = projectorData.projector.getProjectorCamera();
        projectorCamera.setLocation(this.getProjectorLocation());
        projectorCamera.setRotation(this.getProjectorRotation());
        projectorCamera.setFrustumPerspective(this.getHorizontalFOVAngleDegrees(), 1.0f / this.getTextureHtoVRatio(), 1.0f, 5.0f);
    }

    protected void controlUpdate(float arg0) {
        if (this.getMultiTextureProjectorRenderer().getTargetGeometryList() == null) {
            this.getMultiTextureProjectorRenderer().setTargetGeometryList(JME3FovUtilities.createGeometryListForImageProjection((JME3Application)this.jm3Application));
        } else {
            JME3FovUtilities.updateGeometryListForImageProjection((JME3RenderEngineDelegate)this.jm3Application.getJMERenderEngineDelegate(), (GeometryList)this.getMultiTextureProjectorRenderer().getTargetGeometryList());
        }
        Camera projectorCamera = this.getProjectorData().projector.getProjectorCamera();
        projectorCamera.setLocation(this.getProjectorLocation());
        projectorCamera.setRotation(this.getProjectorRotation());
    }

    private AbstractEImage getEmptyImage() {
        AbstractEImage empty = EImagesUtilities.INSTANCE.createTransparentImage(2, 2);
        return empty;
    }

    private AbstractEImage rotateImage(AbstractEImage originalImage) {
        BufferedImage original = originalImage.asBufferedImage();
        BufferedImage rotated = new BufferedImage(originalImage.getHeight(), originalImage.getWidth(), 2);
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int rgb = original.getRGB(x, y);
                rotated.setRGB(y, width - 1 - x, rgb);
                ++y;
            }
            ++x;
        }
        EImage filteredImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        filteredImage.setImageContent(rotated);
        return filteredImage;
    }
}

