/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.common.emf.ui.emfforms.PropertyType;
import org.eclipse.apogy.common.emf.ui.emfforms.impl.ApogyCommonEMFUiEMFFormsFacadeImpl;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCommonEMFUiEMFFormsFacadeCustomImpl
extends ApogyCommonEMFUiEMFFormsFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCommonEMFUiEMFFormsFacadeImpl.class);

    @Override
    public void createEMFForms(Composite parent, EObject eObject) {
        this.createEMFForms(parent, eObject, false);
    }

    @Override
    public void createEMFForms(Composite parent, EObject eObject, String message) {
        this.createEMFForms(parent, eObject, null, message);
    }

    @Override
    public void createEMFForms(Composite parent, EObject eObject, boolean readOnly) {
        if (eObject == null) {
            this.createEMFForms(parent, eObject, null, "Object null");
        } else {
            VView viewModel = ViewProviderHelper.getView((EObject)eObject, null);
            SortedSet<VContainedElement> treeSet = this.sortVElementAlphabetically((List<VContainedElement>)viewModel.getChildren());
            VView vView = VViewFactory.eINSTANCE.createView();
            vView.setRootEClass(eObject.eClass());
            vView.setVisible(true);
            vView.getChildren().addAll(treeSet);
            if (readOnly) {
                vView.setAllContentsReadOnly();
            }
            this.createEMFForms(parent, eObject, vView);
        }
    }

    @Override
    public void createEMFForms(Composite parent, EObject eObject, VView viewModel) {
        this.createEMFForms(parent, eObject, viewModel, "Object null");
    }

    @Override
    public void createEMFForms(Composite parent, EObject eObject, VView viewModel1, final String message) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (eObject == null) {
            parent.setLayout((Layout)new FillLayout());
            new NoContentComposite(parent, 0){

                protected String getMessage() {
                    return message;
                }
            };
        } else {
            if (!(parent.getLayout() instanceof GridLayout)) {
                parent.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(10, 10).create());
            }
            VView displayedVView = null;
            displayedVView = viewModel1 == null ? ViewProviderHelper.getView((EObject)eObject, null) : viewModel1;
            try {
                ECPSWTViewRenderer.INSTANCE.render(parent, eObject, displayedVView);
                Composite composite = (Composite)parent.getChildren()[0];
                if (composite.getChildren().length == 0) {
                    composite.dispose();
                    NoContentComposite errorComposite = new NoContentComposite(parent, 0){

                        protected String getMessage() {
                            return "Selected object has no editable feature";
                        }
                    };
                    errorComposite.setLayoutData((Object)new GridData(4, 4, true, true));
                }
            }
            catch (Exception e) {
                Logger.error("Error while opening EMF Forms", (Throwable)e);
            }
        }
        parent.layout();
    }

    @Override
    public VView createDefaultViewModel(EObject eObject) {
        VControl vControl;
        PropertyType properType;
        String property;
        EClass eClass = eObject.eClass();
        VView vView = VViewFactory.eINSTANCE.createView();
        vView.setRootEClass(eClass);
        vView.setVisible(true);
        ArrayList<VControl> vControls = new ArrayList<VControl>();
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            property = this.getAnnotationDetail((ETypedElement)attribute, "property");
            properType = this.getPropertyType(property);
            if (properType == PropertyType.NONE || (vControl = this.createVControl(attribute)) == null) continue;
            vControls.add(vControl);
        }
        for (EReference eReference : eClass.getEAllReferences()) {
            property = this.getAnnotationDetail((ETypedElement)eReference, "property");
            properType = this.getPropertyType(property);
            if (properType == PropertyType.NONE || (vControl = this.createVControl(eReference)) == null) continue;
            vControls.add(vControl);
        }
        SortedSet<VControl> sortedVControls = this.sortVControlAlphabetically(vControls);
        vView.getChildren().addAll(sortedVControls);
        return vView;
    }

    @Override
    public SortedSet<VControl> sortVControlAlphabetically(List<VControl> vcontrols) {
        TreeSet<VControl> treeSet = new TreeSet<VControl>(new Comparator<VControl>(){

            @Override
            public int compare(VControl arg0, VControl arg1) {
                return arg0.getLabel().compareTo(arg1.getLabel());
            }
        });
        treeSet.addAll(vcontrols);
        return treeSet;
    }

    @Override
    public SortedSet<VContainedElement> sortVElementAlphabetically(List<VContainedElement> vContainedElements) {
        TreeSet<VContainedElement> treeSet = new TreeSet<VContainedElement>(new Comparator<VContainedElement>(){

            @Override
            public int compare(VContainedElement arg0, VContainedElement arg1) {
                String name1 = this.getString(arg0);
                String name2 = this.getString(arg1);
                return name1.compareTo(name2);
            }

            private String getString(VContainedElement vContainedElement) {
                try {
                    if (vContainedElement.getLabel() != null) {
                        return vContainedElement.getLabel();
                    }
                    if (vContainedElement instanceof VControl) {
                        VControl vControl = (VControl)vContainedElement;
                        String name = this.getString(vControl);
                        return name;
                    }
                    return Integer.toString(vContainedElement.hashCode());
                }
                catch (Throwable t) {
                    return Integer.toString(vContainedElement.hashCode());
                }
            }

            private String getString(VControl vControl) {
                String name = null;
                if (vControl.getLabel() != null) {
                    name = vControl.getLabel();
                } else if (vControl.getDomainModelReference() instanceof VFeaturePathDomainModelReference) {
                    VFeaturePathDomainModelReference vf = (VFeaturePathDomainModelReference)vControl.getDomainModelReference();
                    if (vf.getDomainModelEFeature() != null) {
                        name = vf.getDomainModelEFeature().getName();
                    } else if (vf.getDomainModelEReferencePath() != null && !vf.getDomainModelEReferencePath().isEmpty()) {
                        int index = vf.getDomainModelEReferencePath().size() - 1;
                        name = ((EReference)vf.getDomainModelEReferencePath().get(index)).getName();
                    }
                } else {
                    name = Integer.toString(vControl.hashCode());
                }
                return name;
            }
        });
        treeSet.addAll(vContainedElements);
        return treeSet;
    }

    @Override
    public VControl createVControl(EAttribute attribute) {
        VControl vControl = null;
        String property = this.getAnnotationDetail((ETypedElement)attribute, "property");
        PropertyType properType = this.getPropertyType(property);
        switch (properType) {
            case READONLY: {
                vControl = VViewFactory.eINSTANCE.createControl();
                vControl.setLabel(attribute.getName());
                vControl.setReadonly(true);
                VFeaturePathDomainModelReference ref1 = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
                ref1.setDomainModelEFeature((EStructuralFeature)attribute);
                vControl.setDomainModelReference((VDomainModelReference)ref1);
                break;
            }
            case EDITABLE: {
                vControl = VViewFactory.eINSTANCE.createControl();
                vControl.setLabel(attribute.getName());
                VFeaturePathDomainModelReference ref1 = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
                ref1.setDomainModelEFeature((EStructuralFeature)attribute);
                vControl.setDomainModelReference((VDomainModelReference)ref1);
            }
        }
        return vControl;
    }

    @Override
    public VControl createVControl(EReference eReference) {
        VControl vControl = null;
        String property = this.getAnnotationDetail((ETypedElement)eReference, "property");
        PropertyType properType = this.getPropertyType(property);
        switch (properType) {
            case READONLY: {
                vControl = VViewFactory.eINSTANCE.createControl();
                vControl.setLabel(eReference.getName());
                vControl.setReadonly(true);
                VFeaturePathDomainModelReference ref1 = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
                ref1.setDomainModelEFeature((EStructuralFeature)eReference);
                vControl.setDomainModelReference((VDomainModelReference)ref1);
                break;
            }
            case EDITABLE: {
                vControl = VViewFactory.eINSTANCE.createControl();
                vControl.setLabel(eReference.getName());
                VFeaturePathDomainModelReference ref1 = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
                ref1.setDomainModelEFeature((EStructuralFeature)eReference);
                vControl.setDomainModelReference((VDomainModelReference)ref1);
            }
        }
        return vControl;
    }

    @Override
    public PropertyType getPropertyType(EAttribute attribute) {
        String property = this.getAnnotationDetail((ETypedElement)attribute, "property");
        return this.getPropertyType(property);
    }

    @Override
    public PropertyType getPropertyType(EReference eReference) {
        String property = this.getAnnotationDetail((ETypedElement)eReference, "property");
        return this.getPropertyType(property);
    }

    private PropertyType getPropertyType(String propertyString) {
        if (propertyString == null) {
            return PropertyType.EDITABLE;
        }
        if (propertyString.contains("Editable")) {
            return PropertyType.EDITABLE;
        }
        if (propertyString.contains("None")) {
            return PropertyType.NONE;
        }
        if (propertyString.contains("Readonly")) {
            return PropertyType.READONLY;
        }
        return PropertyType.NONE;
    }

    protected String getAnnotationDetail(ETypedElement eTypedElement, String key) {
        EMap map;
        EAnnotation annotation = eTypedElement.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
        if (annotation != null && (map = annotation.getDetails()) != null) {
            return (String)map.get((Object)key);
        }
        return null;
    }
}

