/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.renderers;

import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.FormatProvider;
import org.eclipse.apogy.common.emf.ui.SimpleFormatProvider;
import org.eclipse.apogy.common.emf.ui.SimpleUnitsProvider;
import org.eclipse.apogy.common.emf.ui.UnitsProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.PropertyType;
import org.eclipse.apogy.common.emf.ui.emfforms.renderers.AbstractUnitControlCompositeRenderer;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class UnitControlCompositeRenderer
extends AbstractUnitControlCompositeRenderer {
    @Inject
    public UnitControlCompositeRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    @Override
    protected UpdateValueStrategy getUpdateModelValueStrategy() {
        PropertyType propertyType = this.getPropertyType(this.getVElement());
        if (propertyType == PropertyType.EDITABLE) {
            return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, this.getTypedElement().getEType().getInstanceClass()){

                public Object convert(Object fromObject) {
                    if (fromObject != null && !"".equals(fromObject)) {
                        try {
                            Number number = ApogyCommonEMFUIFacade.INSTANCE.convertToNativeUnits((Number)Double.parseDouble((String)fromObject), UnitControlCompositeRenderer.this.getNativeUnits(), UnitControlCompositeRenderer.this.getDisplayUnits(), UnitControlCompositeRenderer.this.getTypedElement().getEType());
                            Unit<?> displayUnits = UnitControlCompositeRenderer.this.getDisplayUnits();
                            Unit<?> nativeUnits = UnitControlCompositeRenderer.this.getNativeUnits();
                            DecimalFormat format = UnitControlCompositeRenderer.this.getDecimalFormat();
                            if (displayUnits != null && !displayUnits.equals(nativeUnits)) {
                                UnitControlCompositeRenderer.this.textValue.setText(format.format(nativeUnits.getConverterTo(displayUnits).convert(number.doubleValue())));
                            } else {
                                UnitControlCompositeRenderer.this.textValue.setText(format.format(number.doubleValue()));
                            }
                            EClassifier classifier = UnitControlCompositeRenderer.this.getTypedElement().getEType();
                            if (classifier == EcorePackage.Literals.EFLOAT) {
                                number = Float.valueOf(number.floatValue());
                            } else if (classifier == EcorePackage.Literals.EBYTE) {
                                number = number.byteValue();
                            } else if (classifier == EcorePackage.Literals.ESHORT) {
                                number = number.shortValue();
                            } else if (classifier == EcorePackage.Literals.EINT) {
                                number = number.intValue();
                            } else if (classifier == EcorePackage.Literals.ELONG) {
                                number = number.longValue();
                            }
                            return number;
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)UnitControlCompositeRenderer.this.textValue.getDisplay().getActiveShell(), (String)"Invalid Number", (String)"The number entered is invalid. The value will be unset.");
                        }
                    }
                    UnitControlCompositeRenderer.this.textValue.setText(UnitControlCompositeRenderer.this.getFormatedValue());
                    return UnitControlCompositeRenderer.this.getValue();
                }
            });
        }
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);
    }

    @Override
    protected UpdateValueStrategy getUpdateTextValueStrategy() {
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(this.getTypedElement().getEType().getInstanceClass(), String.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    String value = UnitControlCompositeRenderer.this.getFormatedValue();
                    return value == null ? "" : value;
                }
                return "";
            }
        });
    }

    @Override
    protected void addToDisplayUnitsRegistry(Unit<?> resultUnits) {
        SimpleUnitsProvider unitsProvider = ApogyCommonEMFUIFactory.eINSTANCE.createSimpleUnitsProvider();
        unitsProvider.setUnit(resultUnits);
        ApogyCommonEMFUIFacade.INSTANCE.addUnitsProviderToRegistry(this.getTypedElement(), (UnitsProvider)unitsProvider);
    }

    @Override
    protected void addToDecimalFormatRegistry(DecimalFormat resultFormat) {
        SimpleFormatProvider formatProvider = ApogyCommonEMFUIFactory.eINSTANCE.createSimpleFormatProvider();
        formatProvider.setFormatPattern(resultFormat.toPattern());
        ApogyCommonEMFUIFacade.INSTANCE.addFormatProviderToRegistry(this.getTypedElement(), (FormatProvider)formatProvider);
    }

    @Override
    protected Unit<?> getNativeUnits() {
        return ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(this.getTypedElement());
    }

    @Override
    protected Unit<?> getDisplayUnits() {
        return ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(this.getTypedElement());
    }

    @Override
    protected DecimalFormat getDecimalFormat() {
        return ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat(this.getTypedElement());
    }

    @Override
    protected String getFormatedValue() {
        Double valueDouble = this.getValue().doubleValue();
        DecimalFormat format = ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat(this.getTypedElement());
        Unit displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(this.getTypedElement());
        Unit nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(this.getTypedElement());
        if (displayUnits != null && !displayUnits.equals((Object)nativeUnits)) {
            valueDouble = nativeUnits.getConverterTo(displayUnits).convert(valueDouble.doubleValue());
        }
        return format.format(valueDouble);
    }

    @Override
    protected Ranges getRange() {
        return ApogyCommonEMFFacade.INSTANCE.getRange(this.getTypedElement(), (Object)this.getValue());
    }
}

