/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data.impl;

import org.eclipse.apogy.common.geometry.data.Coordinates;
import org.eclipse.apogy.common.geometry.data.CoordinatesSamplingShape;
import org.eclipse.apogy.common.geometry.data.CoordinatesSet;
import org.eclipse.apogy.common.geometry.data.ShapeSamplingMode;
import org.eclipse.apogy.common.geometry.data.impl.CoordinatesSetShapesSamplerImpl;

public class CoordinatesSetShapesSamplerCustomImpl<T extends Coordinates>
extends CoordinatesSetShapesSamplerImpl<T> {
    public CoordinatesSet<T> process(CoordinatesSet<T> input) throws Exception {
        this.setInput(input);
        CoordinatesSet<T> sampled = this.createCoordinatesSet(input);
        if (this.getProgressMonitor() != null) {
            this.getProgressMonitor().beginTask("Sampling using " + this.getCoordinatesSamplingShapes().size() + " sampling shapes. ", input.getPoints().size());
        }
        int i = 0;
        while (i < input.getPoints().size()) {
            Coordinates point = (Coordinates)input.getPoints().get(i);
            if (this.isPointInside(point)) {
                sampled.getPoints().add((Object)this.copyCoordinates(point));
                if (this.getProgressMonitor() != null) {
                    this.getProgressMonitor().worked(1);
                }
            }
            ++i;
        }
        if (this.getProgressMonitor() != null) {
            this.getProgressMonitor().done();
        }
        this.setOutput(sampled);
        return sampled;
    }

    protected CoordinatesSet<T> createCoordinatesSet(CoordinatesSet<T> input) {
        return null;
    }

    protected T copyCoordinates(T point) {
        throw new UnsupportedOperationException();
    }

    private boolean isPointInside(T point) {
        boolean inside;
        block3: {
            block2: {
                inside = false;
                if (this.getShapeSamplingMode() != ShapeSamplingMode.UNION) break block2;
                inside = false;
                int j = 0;
                while (j < this.getCoordinatesSamplingShapes().size() && !inside) {
                    CoordinatesSamplingShape samplingShape = (CoordinatesSamplingShape)this.getCoordinatesSamplingShapes().get(j);
                    inside |= samplingShape.isInside(point);
                    ++j;
                }
                break block3;
            }
            if (this.getShapeSamplingMode() != ShapeSamplingMode.INTERSECTION) break block3;
            inside = true;
            int j = 0;
            while (j < this.getCoordinatesSamplingShapes().size() && inside) {
                CoordinatesSamplingShape samplingShape = (CoordinatesSamplingShape)this.getCoordinatesSamplingShapes().get(j);
                inside &= samplingShape.isInside(point);
                ++j;
            }
        }
        return inside;
    }
}

