/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.ui.composites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuple3dListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(Tuple3dListComposite.class);
    private EObject owner = null;
    private EStructuralFeature feature = null;
    private Tuple3dListAdapter adapter;
    private final TableViewer tableViewer;
    private final Table table;
    private final Button btnNew;
    private final Button btnDelete;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;

    public Tuple3dListComposite(Composite parent, int style) {
        this(parent, style, null, null, null);
    }

    public Tuple3dListComposite(Composite parent, int style, String label, EObject owner, EStructuralFeature feature) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.owner = owner;
        this.feature = feature;
        this.tableViewer = new TableViewer((Composite)this, 68354);
        this.table = this.tableViewer.getTable();
        GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
        gd_tree.widthHint = 300;
        gd_tree.minimumWidth = 300;
        this.table.setLayoutData((Object)gd_tree);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumnItem_Name = new TableViewerColumn(this.tableViewer, 0);
        TableColumn trclmnItemName = tableViewerColumnItem_Name.getColumn();
        trclmnItemName.setWidth(200);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Tuple3dListComposite.this.newTuple3dSelected((Tuple3d)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    Tuple3d newTuple3d = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
                    ApogyCommonTransactionFacade.INSTANCE.basicAdd(Tuple3dListComposite.this.getOwner(), Tuple3dListComposite.this.getFeature(), (Object)newTuple3d);
                    if (!Tuple3dListComposite.this.tableViewer.isBusy()) {
                        Tuple3dListComposite.this.tableViewer.setInput(Tuple3dListComposite.this.getOwner().eGet(Tuple3dListComposite.this.getFeature()));
                    }
                    Tuple3dListComposite.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newTuple3d));
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String imageMapLayersToDeleteMessage = "";
                MessageDialog dialog = new MessageDialog(null, "Delete the selected Tuple 3D", null, "Are you sure to delete these Tuple 3D: " + imageMapLayersToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (Tuple3d slopeRange : Tuple3dListComposite.this.getSelectedTuple3dList()) {
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicRemove(Tuple3dListComposite.this.getOwner(), Tuple3dListComposite.this.getFeature(), (Object)slopeRange);
                        }
                        catch (Exception e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (!Tuple3dListComposite.this.tableViewer.isBusy()) {
                    Tuple3dListComposite.this.tableViewer.setInput(Tuple3dListComposite.this.getOwner().eGet(Tuple3dListComposite.this.getFeature()));
                }
            }
        });
        this.updateDisplayedList();
        this.m_bindingContext = this.customInitDataBindings();
        this.setOwner(owner);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (Tuple3dListComposite.this.m_bindingContext != null) {
                    Tuple3dListComposite.this.m_bindingContext.dispose();
                }
                if (Tuple3dListComposite.this.getOwner() != null) {
                    Tuple3dListComposite.this.getOwner().eAdapters().remove((Object)Tuple3dListComposite.this.getAdapter());
                    Tuple3dListComposite.this.getAdapter().unregisterFromAll();
                }
            }
        });
    }

    public EObject getOwner() {
        return this.owner;
    }

    public void setOwner(EObject newOwner) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        if (this.owner != null) {
            this.owner.eAdapters().remove((Object)this.getAdapter());
            this.getAdapter().unregisterFromAll();
        }
        this.owner = newOwner;
        if (newOwner != null) {
            this.m_bindingContext = this.customInitDataBindings();
            this.updateDisplayedList();
            newOwner.eAdapters().add((Object)this.getAdapter());
            if (this.getOwner().eGet(this.getFeature()) != null) {
                this.getAdapter().registerTo((Collection)this.getOwner().eGet(this.getFeature()));
            }
        }
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public void setFeature(EStructuralFeature feature) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.feature = feature;
        this.updateDisplayedList();
        if (feature != null) {
            this.m_bindingContext = this.customInitDataBindings();
        }
    }

    public List<Tuple3d> getSelectedTuple3dList() {
        return ((IStructuredSelection)this.tableViewer.getSelection()).toList();
    }

    public Tuple3d getSelectedTuple3d() {
        List<Tuple3d> selected = this.getSelectedTuple3dList();
        if (selected != null && !selected.isEmpty()) {
            return selected.get(0);
        }
        return null;
    }

    protected void newTuple3dSelected(Tuple3d tuple3d) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.tableViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                Boolean result = fromObject != null;
                Collection list = Tuple3dListComposite.this.getReferedTuple3dCollection();
                if (list != null) {
                    result = result != false && list.size() > 3;
                    return result;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private void updateDisplayedList() {
        if (this.getOwner() != null && this.getFeature() != null) {
            this.tableViewer.setInput(this.getOwner().eGet(this.getFeature()));
        }
    }

    private Collection<Tuple3d> getReferedTuple3dCollection() {
        if (this.getOwner() != null && this.getFeature() != null) {
            Collection list = (Collection)this.getOwner().eGet(this.getFeature());
            return list;
        }
        return null;
    }

    private Tuple3dListAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new Tuple3dListAdapter();
        }
        return this.adapter;
    }

    private class Tuple3dListAdapter
    extends AdapterImpl {
        private final List<Tuple3d> points = new ArrayList<Tuple3d>();

        private Tuple3dListAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof Tuple3d) {
                Tuple3dListComposite.this.updateDisplayedList();
            } else if (msg.getNotifier() == Tuple3dListComposite.this.getOwner() && msg.getFeature() == Tuple3dListComposite.this.getFeature()) {
                switch (msg.getEventType()) {
                    case 3: {
                        if (!(msg.getNewValue() instanceof Tuple3d)) break;
                        Tuple3d newPoint = (Tuple3d)msg.getNewValue();
                        newPoint.eAdapters().add((Object)Tuple3dListComposite.this.getAdapter());
                        this.points.add(newPoint);
                        break;
                    }
                    case 5: {
                        Collection newPoints = (Collection)msg.getNewValue();
                        for (Tuple3d point : newPoints) {
                            point.eAdapters().add((Object)Tuple3dListComposite.this.getAdapter());
                            this.points.add(point);
                        }
                        break;
                    }
                    case 4: {
                        if (!(msg.getOldValue() instanceof Tuple3d)) break;
                        Tuple3d oldPoint = (Tuple3d)msg.getOldValue();
                        oldPoint.eAdapters().remove((Object)Tuple3dListComposite.this.getAdapter());
                        this.points.remove(oldPoint);
                        break;
                    }
                    case 6: {
                        Collection oldPoints = (Collection)msg.getOldValue();
                        for (Tuple3d point : oldPoints) {
                            point.eAdapters().remove((Object)Tuple3dListComposite.this.getAdapter());
                            this.points.remove(point);
                        }
                        break;
                    }
                }
                Tuple3dListComposite.this.updateDisplayedList();
            }
        }

        public void unregisterFromAll() {
            for (Tuple3d point : this.points) {
                point.eAdapters().remove((Object)Tuple3dListComposite.this.getAdapter());
            }
            this.points.clear();
        }

        public void registerTo(Collection<Tuple3d> list) {
            for (Tuple3d point : list) {
                point.eAdapters().add((Object)Tuple3dListComposite.this.getAdapter());
                this.points.add(point);
            }
        }
    }
}

