/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.wizards;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.ui.composites.TypedElementSimpleUnitsComposite;
import org.eclipse.apogy.common.topology.addons.primitives.ApogyCommonTopologyAddonsPrimitivesPackage;
import org.eclipse.apogy.common.topology.addons.primitives.PointLight;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PointLightWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.topology.addons.primitives.ui.wizards.PointLightWizardPage";
    public static String NO_VALUE_AVAILABLE_STRING = "N/A";
    private final int LABEL_WIDTH = 200;
    private final int VALUE_WIDTH = 100;
    private final int BUTTON_WIDTH = 50;
    private final PointLight pointLight;
    private Adapter adapter;
    private TypedElementSimpleUnitsComposite radiusComposite;

    public PointLightWizardPage(PointLight pointLight) {
        super(WIZARD_PAGE_ID);
        this.pointLight = pointLight;
        this.setTitle("Point Light");
        this.setDescription("Select the Point Light radius.");
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)top);
        this.radiusComposite = new TypedElementSimpleUnitsComposite(top, 0, true, true, true, NO_VALUE_AVAILABLE_STRING, 200, 100, 50){
            DecimalFormat format;
            {
                this.format = new DecimalFormat("0.0");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected String getLabelText() {
                return "Radius :";
            }
        };
        this.radiusComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.radiusComposite.setTypedElement(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonTopologyAddonsPrimitivesPackage.Literals.POINT_LIGHT__RADIUS}), (EObject)this.pointLight);
        if (this.pointLight != null) {
            this.pointLight.eAdapters().add((Object)this.getAdapter());
        }
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (PointLightWizardPage.this.pointLight != null) {
                    PointLightWizardPage.this.pointLight.eAdapters().remove((Object)PointLightWizardPage.this.getAdapter());
                }
            }
        });
        this.validate();
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.pointLight.getRadius() <= 0.0f) {
            this.setErrorMessage("The specified radius must be greater than zero !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof PointLight) {
                        PointLightWizardPage.this.validate();
                    }
                }
            };
        }
        return this.adapter;
    }
}

