/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.composites;

import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.ApogyEarthEnvironmentPackage;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EarthSurfaceWorksiteOriginComposite
extends Composite {
    private EarthSurfaceWorksite earthSurfaceWorksite;
    private DataBindingContext m_bindingContext;
    private final Text txtLatitudevalue;
    private final Text txtLongitudevalue;
    private final Text txtAltitudevalue;
    private final Text txtXaxisazimuth;

    public EarthSurfaceWorksiteOriginComposite(Composite parent, int style) {
        super(parent, 262144);
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblLatitude = new Label((Composite)this, 0);
        lblLatitude.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLatitude.setText("Latitude:");
        this.txtLatitudevalue = new Text((Composite)this, 0);
        this.txtLatitudevalue.setText("0.0");
        GridData gd_txtLatitudevalue = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtLatitudevalue.widthHint = 150;
        gd_txtLatitudevalue.minimumWidth = 150;
        this.txtLatitudevalue.setLayoutData((Object)gd_txtLatitudevalue);
        this.txtLatitudevalue.setToolTipText("Latitude of the origin of the worksite, in degrees.Latitude north of the equator are positive while those south of the equator are negative.");
        Label lblDegres = new Label((Composite)this, 0);
        lblDegres.setText("degrees");
        Label lblLongitude = new Label((Composite)this, 0);
        lblLongitude.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLongitude.setText("Longitude:");
        this.txtLongitudevalue = new Text((Composite)this, 0);
        this.txtLongitudevalue.setText("0.0");
        GridData gd_txtLongitudevalue = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtLongitudevalue.minimumWidth = 150;
        gd_txtLongitudevalue.widthHint = 150;
        this.txtLongitudevalue.setLayoutData((Object)gd_txtLongitudevalue);
        this.txtLongitudevalue.setToolTipText("Longitude of the origin of the worksite, in degrees. Longitude east of Greenwich, UK  are positive while those west of Greenwich are negative.");
        Label lblDegres_1 = new Label((Composite)this, 0);
        lblDegres_1.setText("degrees");
        Label lblAltitude = new Label((Composite)this, 0);
        lblAltitude.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAltitude.setText("Altitude:");
        this.txtAltitudevalue = new Text((Composite)this, 0);
        this.txtAltitudevalue.setText("0.0");
        GridData gd_txtAltitudevalue = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtAltitudevalue.widthHint = 150;
        gd_txtAltitudevalue.minimumWidth = 150;
        this.txtAltitudevalue.setLayoutData((Object)gd_txtAltitudevalue);
        this.txtAltitudevalue.setToolTipText("Height above the Earth's sea level, in meters.");
        Label lblMeters = new Label((Composite)this, 0);
        lblMeters.setText("meters");
        Label lblXAxisAzimuth = new Label((Composite)this, 0);
        lblXAxisAzimuth.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblXAxisAzimuth.setText("X Axis Azimuth:");
        this.txtXaxisazimuth = new Text((Composite)this, 0);
        this.txtXaxisazimuth.setText("0.0");
        GridData gd_txtXaxisazimuth = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtXaxisazimuth.minimumWidth = 150;
        gd_txtXaxisazimuth.widthHint = 150;
        this.txtXaxisazimuth.setLayoutData((Object)gd_txtXaxisazimuth);
        this.txtXaxisazimuth.setToolTipText("Azimuth, relative to true North, of the X axis of the worksite coordinates system. Follows the right hand rule. Note that the Z axis is pointing up (toward zenith).");
        Label lblDegrees = new Label((Composite)this, 0);
        lblDegrees.setText("degrees");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EarthSurfaceWorksiteOriginComposite.this.m_bindingContext != null) {
                    EarthSurfaceWorksiteOriginComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public EarthSurfaceWorksite getEarthSurfaceWorksite() {
        return this.earthSurfaceWorksite;
    }

    public void setEarthSurfaceWorksite(EarthSurfaceWorksite earthSurfaceWorksite) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.earthSurfaceWorksite = earthSurfaceWorksite;
        if (earthSurfaceWorksite != null) {
            this.m_bindingContext = this.initDataBindingsCustom();
        }
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeLatitude = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyEarthEnvironmentPackage.Literals.EARTH_WORKSITE__GEOGRAPHICAL_COORDINATES, ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE})).observe((Object)this.getEarthSurfaceWorksite());
        ISWTObservableValue observeLatitudeLabelValueText = WidgetProperties.text((int)24).observe((Widget)this.txtLatitudevalue);
        bindingContext.bindValue((IObservableValue)observeLatitudeLabelValueText, observeLatitude, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Math.toRadians(Double.parseDouble((String)fromObject));
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                Double degrees = Math.toDegrees((Double)fromObject);
                return degrees.toString();
            }
        }));
        IObservableValue observeLongitude = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyEarthEnvironmentPackage.Literals.EARTH_WORKSITE__GEOGRAPHICAL_COORDINATES, ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE})).observe((Object)this.getEarthSurfaceWorksite());
        ISWTObservableValue observeLongitudeLabelValueText = WidgetProperties.text((int)24).observe((Widget)this.txtLongitudevalue);
        bindingContext.bindValue((IObservableValue)observeLongitudeLabelValueText, observeLongitude, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Math.toRadians(Double.parseDouble((String)fromObject));
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                Double degrees = Math.toDegrees((Double)fromObject);
                return degrees.toString();
            }
        }));
        IObservableValue observeAltitude = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyEarthEnvironmentPackage.Literals.EARTH_WORKSITE__GEOGRAPHICAL_COORDINATES, ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION})).observe((Object)this.getEarthSurfaceWorksite());
        ISWTObservableValue observeAltitudeLabelValueText = WidgetProperties.text((int)24).observe((Widget)this.txtAltitudevalue);
        bindingContext.bindValue((IObservableValue)observeAltitudeLabelValueText, observeAltitude, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Double.parseDouble((String)fromObject);
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                return ((Double)fromObject).toString();
            }
        }));
        IObservableValue observeXAxisAzimuth = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyEarthSurfaceEnvironmentPackage.Literals.EARTH_SURFACE_WORKSITE__XAXIS_AZIMUTH})).observe((Object)this.getEarthSurfaceWorksite());
        ISWTObservableValue observeXAxisAzimuthLabelValueText = WidgetProperties.text((int)24).observe((Widget)this.txtXaxisazimuth);
        bindingContext.bindValue((IObservableValue)observeXAxisAzimuthLabelValueText, observeXAxisAzimuth, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Math.toRadians(Double.parseDouble((String)fromObject));
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                Double degrees = Math.toDegrees((Double)fromObject);
                return degrees.toString();
            }
        }));
        return bindingContext;
    }
}

