/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.parts;

import org.eclipse.apogy.common.emf.ui.parts.AbstractPart;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.apogy.core.environment.earth.ApogyEarthFacade;
import org.eclipse.apogy.core.environment.earth.EarthWorksite;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.apogy.core.environment.earth.surface.ui.composites.EarthSkyComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EarthSkyPart
extends AbstractPart {
    private Adapter adapter;
    private EarthSkyComposite earthSkyComposite = null;

    public EarthSkyPart() {
        ApogyEarthFacade.INSTANCE.eAdapters().add((Object)this.getApogyEarthSurfaceEnvironmentFacadeAdapter());
    }

    protected EObject getInitializeObject() {
        EarthSky earthSky = null;
        EarthWorksite earthSurfaceWorksite = ApogyEarthFacade.INSTANCE.getActiveEarthWorksite();
        if (earthSurfaceWorksite != null && earthSurfaceWorksite.getSky() instanceof EarthSky) {
            earthSky = (EarthSky)earthSurfaceWorksite.getSky();
        }
        return earthSky;
    }

    protected void setCompositeContent(EObject eObject) {
        if (eObject instanceof EarthSky) {
            this.earthSkyComposite.setEarthSky((EarthSky)eObject);
        } else {
            this.setEObject(null);
        }
    }

    protected void createNoContentComposite(Composite parent, int style) {
        new NoContentComposite(parent, 0){

            protected String getMessage() {
                return "No active Earth Sky.";
            }
        };
    }

    protected void createContentComposite(Composite parent, int style) {
        parent.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.earthSkyComposite = new EarthSkyComposite((Composite)scrolledComposite, style);
        GridData gridData = new GridData(4, 128, true, false);
        this.earthSkyComposite.setLayoutData(gridData);
        scrolledComposite.setContent((Control)this.earthSkyComposite);
        scrolledComposite.setMinSize(this.earthSkyComposite.computeSize(-1, -1));
    }

    public void dispose() {
        ApogyEarthFacade.INSTANCE.eAdapters().remove((Object)this.getApogyEarthSurfaceEnvironmentFacadeAdapter());
        super.dispose();
    }

    private Adapter getApogyEarthSurfaceEnvironmentFacadeAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyEarthFacade) {
                        int featureID = msg.getFeatureID(ApogyEarthFacade.class);
                        switch (featureID) {
                            case 0: {
                                if (msg.getNewValue() instanceof EarthWorksite) {
                                    EarthWorksite earthSurfaceWorksite = (EarthWorksite)msg.getNewValue();
                                    if (earthSurfaceWorksite != null && earthSurfaceWorksite.getSky() instanceof EarthSky) {
                                        EarthSkyPart.this.setEObject((EObject)earthSurfaceWorksite.getSky());
                                        break;
                                    }
                                    EarthSkyPart.this.setEObject(null);
                                    break;
                                }
                                EarthSkyPart.this.setEObject(null);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

