/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.wizards;

import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.WorksitesList;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.ui.wizards.ImportEarthSurfaceWorksiteWizardPage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportEarthSurfaceWorksiteWizard
extends Wizard {
    private static final Logger Logger = LoggerFactory.getLogger(ImportEarthSurfaceWorksiteWizard.class);
    private final WorksitesList worksitesList;
    private EarthSurfaceWorksite importedEarthSurfaceWorksite = null;
    private final ImportEarthSurfaceWorksiteWizardPage importEarthSurfaceWorksiteWizardPage;

    public ImportEarthSurfaceWorksiteWizard(WorksitesList worksitesList) {
        this.worksitesList = worksitesList;
        this.setWindowTitle("Import Earth Surface Worksite");
        this.importEarthSurfaceWorksiteWizardPage = new ImportEarthSurfaceWorksiteWizardPage(worksitesList){

            @Override
            protected void newSelectedEarthSurfaceWorksite(EarthSurfaceWorksite selectedEarthSurfaceWorksite) {
                ImportEarthSurfaceWorksiteWizard.this.importedEarthSurfaceWorksite = selectedEarthSurfaceWorksite;
                this.setPageComplete(ImportEarthSurfaceWorksiteWizard.this.importedEarthSurfaceWorksite != null);
            }
        };
        this.addPage((IWizardPage)this.importEarthSurfaceWorksiteWizardPage);
    }

    public void setImportedEarthSurfaceWorksite(EarthSurfaceWorksite importedEarthSurfaceWorksite) {
        this.importedEarthSurfaceWorksite = importedEarthSurfaceWorksite;
    }

    public boolean canFinish() {
        return this.importedEarthSurfaceWorksite != null;
    }

    public boolean performFinish() {
        if (this.importedEarthSurfaceWorksite != null) {
            try {
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.worksitesList, (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.WORKSITES_LIST__WORKSITES, (Object)this.importedEarthSurfaceWorksite);
                return true;
            }
            catch (Exception e) {
                String errorMessage = "Failed to import Earth Surface Worksite !!";
                Logger.error(errorMessage, (Throwable)e);
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)errorMessage);
                return false;
            }
        }
        return false;
    }
}

