/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.core.environment.earth.ui.AbstractWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractWorldWindLayerListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractWorldWindLayerListComposite.class);
    private EarthViewConfiguration earthViewConfiguration;
    private boolean enableEditing = true;
    private TableViewer viewer;
    private Button btnNew;
    private Button btnDelete;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;

    public AbstractWorldWindLayerListComposite(Composite parent, int style) {
        this(parent, style, true);
    }

    public AbstractWorldWindLayerListComposite(Composite parent, int style, boolean enableEditing) {
        super(parent, style);
        this.enableEditing = enableEditing;
        if (enableEditing) {
            this.setLayout((Layout)new GridLayout(2, false));
        } else {
            this.setLayout((Layout)new GridLayout(1, false));
        }
        this.viewer = new TableViewer((Composite)this, 68354);
        Table table = this.viewer.getTable();
        GridData gd_tree = new GridData(4, 4, true, true, 1, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        table.setLayoutData((Object)gd_tree);
        table.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        TableViewerColumn tableViewerColumnItem_Name = new TableViewerColumn(this.viewer, 0);
        TableColumn trclmnItemName = tableViewerColumnItem_Name.getColumn();
        trclmnItemName.setWidth(300);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory){

            public Object[] getElements(Object object) {
                if (object instanceof EarthViewConfiguration) {
                    EarthViewConfiguration earthViewConfiguration = (EarthViewConfiguration)object;
                    return earthViewConfiguration.getLayers().toArray();
                }
                return null;
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractWorldWindLayerListComposite.this.newAbstractWorldWindLayerSelected((AbstractWorldWindLayer)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        if (enableEditing) {
            Composite composite = new Composite((Composite)this, 0);
            composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            composite.setLayout((Layout)new GridLayout(1, false));
            this.btnNew = new Button(composite, 0);
            this.btnNew.setSize(74, 29);
            this.btnNew.setText("New");
            this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.btnNew.setEnabled(true);
            this.btnNew.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 13) {
                        MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                        settings.getUserDataMap().put("name", ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)AbstractWorldWindLayerListComposite.this.getEarthViewConfiguration(), null, (ETypedElement)ApogyEarthEnvironmentUIPackage.Literals.EARTH_VIEW_CONFIGURATION__LAYERS));
                        ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyEarthEnvironmentUIPackage.Literals.EARTH_VIEW_CONFIGURATION__LAYERS, (EObject)AbstractWorldWindLayerListComposite.this.getEarthViewConfiguration(), (EClassSettings)settings, ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER);
                        WizardDialog dialog = new WizardDialog(AbstractWorldWindLayerListComposite.this.getShell(), (IWizard)wizard);
                        dialog.open();
                        if (!AbstractWorldWindLayerListComposite.this.viewer.isBusy()) {
                            AbstractWorldWindLayerListComposite.this.viewer.refresh();
                            if (AbstractWorldWindLayerListComposite.this.getEarthViewConfiguration().getLayers().isEmpty()) {
                                AbstractWorldWindLayerListComposite.this.viewer.setSelection((ISelection)new StructuredSelection(), true);
                            } else {
                                int index = AbstractWorldWindLayerListComposite.this.getEarthViewConfiguration().getLayers().size() - 1;
                                AbstractWorldWindLayerListComposite.this.viewer.setSelection((ISelection)new StructuredSelection(AbstractWorldWindLayerListComposite.this.getEarthViewConfiguration().getLayers().get(index)), true);
                            }
                        }
                    }
                }
            });
            this.btnDelete = new Button(composite, 0);
            this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.btnDelete.setSize(74, 29);
            this.btnDelete.setText("Delete");
            this.btnDelete.setEnabled(false);
            this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String meshLayersToDeleteMessage = "";
                    Iterator<AbstractWorldWindLayer> layers = AbstractWorldWindLayerListComposite.this.getSelectedAbstractWorldWindLayers().iterator();
                    while (layers.hasNext()) {
                        AbstractWorldWindLayer meshLayer = layers.next();
                        meshLayersToDeleteMessage = String.valueOf(meshLayersToDeleteMessage) + meshLayer.getName();
                        if (!layers.hasNext()) continue;
                        meshLayersToDeleteMessage = String.valueOf(meshLayersToDeleteMessage) + ", ";
                    }
                    MessageDialog dialog = new MessageDialog(null, "Delete the selected Earth View Layers", null, "Are you sure to delete these Earth View Layers: " + meshLayersToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                    int result = dialog.open();
                    if (result == 0) {
                        for (AbstractWorldWindLayer layer : AbstractWorldWindLayerListComposite.this.getSelectedAbstractWorldWindLayers()) {
                            try {
                                layer.dispose();
                                ApogyCommonTransactionFacade.INSTANCE.basicDelete((EObject)AbstractWorldWindLayerListComposite.this.getEarthViewConfiguration(), (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.EARTH_VIEW_CONFIGURATION__LAYERS, (Object)layer);
                            }
                            catch (Exception e) {
                                Logger.error("Unable to delete the Earth View Layers <" + layer.getName() + ">.", (Throwable)e);
                            }
                        }
                    }
                    if (!AbstractWorldWindLayerListComposite.this.viewer.isBusy()) {
                        AbstractWorldWindLayerListComposite.this.viewer.refresh();
                        if (AbstractWorldWindLayerListComposite.this.getEarthViewConfiguration().getLayers().isEmpty()) {
                            AbstractWorldWindLayerListComposite.this.viewer.setSelection((ISelection)new StructuredSelection(), true);
                        } else {
                            AbstractWorldWindLayerListComposite.this.viewer.setSelection((ISelection)new StructuredSelection(AbstractWorldWindLayerListComposite.this.getEarthViewConfiguration().getLayers().get(0)), true);
                        }
                    }
                }
            });
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractWorldWindLayerListComposite.this.m_bindingContext != null) {
                    AbstractWorldWindLayerListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public EarthViewConfiguration getEarthViewConfiguration() {
        return this.earthViewConfiguration;
    }

    public void setEarthViewConfiguration(EarthViewConfiguration newEarthViewConfiguration) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.earthViewConfiguration = newEarthViewConfiguration;
        if (newEarthViewConfiguration != null) {
            this.m_bindingContext = this.customInitDataBindings();
            this.viewer.setInput((Object)newEarthViewConfiguration);
            AbstractWorldWindLayer layer = this.getFirstAbstractWorldWindLayer(newEarthViewConfiguration);
            if (layer != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)layer), true);
            }
        }
    }

    public List<AbstractWorldWindLayer> getSelectedAbstractWorldWindLayers() {
        return ((IStructuredSelection)this.viewer.getSelection()).toList();
    }

    protected void newAbstractWorldWindLayerSelected(AbstractWorldWindLayer abstractWorldWindLayer) {
    }

    protected AbstractWorldWindLayer getFirstAbstractWorldWindLayer(EarthViewConfiguration earthViewConfiguration) {
        if (!earthViewConfiguration.getLayers().isEmpty()) {
            return (AbstractWorldWindLayer)earthViewConfiguration.getLayers().get(0);
        }
        return null;
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        if (this.enableEditing) {
            IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.viewer);
            ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
            bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

                public Object convert(Object fromObject) {
                    if (fromObject != null) {
                        return true;
                    }
                    return false;
                }
            }));
        }
        return bindingContext;
    }
}

