/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.composites;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.awt.WorldWindowGLJPanel;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.ui.AbstractWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfigurationList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthViewComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(EarthViewComposite.class);
    private EarthViewMode mode = EarthViewMode.ROUND;
    private WorldWindowGLJPanel worldWindowGLJPanel;
    private EarthViewConfigurationList earthViewConfigurationList;
    private EarthViewConfiguration earthViewConfiguration;
    private Adapter earthViewConfigurationAdapter;
    private final List<AbstractWorldWindLayer> layers = new ArrayList<AbstractWorldWindLayer>();

    public EarthViewComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        Composite top = new Composite((Composite)this, 0x1000000);
        Frame worldFrame = SWT_AWT.new_Frame((Composite)top);
        Panel panel = new Panel(new BorderLayout());
        worldFrame.add(panel);
        panel.add((Component)this.getWorldWindowGLJPanel(), "Center");
        worldFrame.requestFocus();
    }

    public void setEarthViewConfiguration(EarthViewConfiguration newEarthViewConfiguration) {
        if (this.earthViewConfiguration != null) {
            this.earthViewConfiguration.eAdapters().remove((Object)this.getEarthViewConfigurationAdapter());
        }
        this.removeAllLayers();
        this.earthViewConfiguration = newEarthViewConfiguration;
        if (newEarthViewConfiguration != null) {
            this.initializeEarthViewConfiguration(newEarthViewConfiguration);
            newEarthViewConfiguration.eAdapters().add((Object)this.getEarthViewConfigurationAdapter());
        }
        this.newEarthViewConfigurationSelected(newEarthViewConfiguration);
    }

    public EarthViewConfiguration getEarthViewConfiguration() {
        return this.earthViewConfiguration;
    }

    public EarthViewConfigurationList getEarthViewConfigurationList() {
        return this.earthViewConfigurationList;
    }

    public void setEarthViewConfigurationList(EarthViewConfigurationList earthViewConfigurationList) {
        this.earthViewConfigurationList = earthViewConfigurationList;
    }

    public EarthViewMode getEarthViewMode() {
        return this.mode;
    }

    public void setEarthViewMode(EarthViewMode mode) {
        this.mode = mode;
        if (mode == EarthViewMode.FLAT) {
            Configuration.setValue((String)"gov.nasa.worldwind.avkey.GlobeClassName", (Object)EarthFlat.class.getName());
            Configuration.setValue((String)"gov.nasa.worldwind.avkey.ViewClassName", (Object)FlatOrbitView.class.getName());
        } else {
            Configuration.setValue((String)"gov.nasa.worldwind.avkey.GlobeClassName", (Object)Earth.class.getName());
            Configuration.setValue((String)"gov.nasa.worldwind.avkey.ViewClassName", (Object)BasicOrbitView.class.getName());
        }
        this.getWorldWindowGLJPanel().setModel((Model)new BasicModel());
        this.getWorldWindowGLJPanel().redraw();
        this.initializeEarthViewConfiguration(this.getEarthViewConfiguration());
    }

    protected void newEarthViewConfigurationSelected(EarthViewConfiguration newEarthViewConfiguration) {
    }

    protected void addLayer(AbstractWorldWindLayer abstractWorldWindLayer) {
        abstractWorldWindLayer.initialise();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)abstractWorldWindLayer, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__WORLD_WINDOW, (Object)this.getWorldWindowGLJPanel(), true);
        if (abstractWorldWindLayer.getRenderableLayer() != null) {
            this.getWorldWindowGLJPanel().getModel().getLayers().add((Layer)abstractWorldWindLayer.getRenderableLayer());
            this.getWorldWindowGLJPanel().redraw();
        }
        this.layers.add(abstractWorldWindLayer);
    }

    protected void removeLayer(AbstractWorldWindLayer abstractWorldWindLayer) {
        if (abstractWorldWindLayer.getRenderableLayer() != null) {
            this.getWorldWindowGLJPanel().getModel().getLayers().remove((Layer)abstractWorldWindLayer.getRenderableLayer());
        }
    }

    protected void removeAllLayers() {
        for (AbstractWorldWindLayer layer : this.layers) {
            this.removeLayer(layer);
        }
        this.layers.clear();
    }

    protected void updateAllLayers() {
        for (AbstractWorldWindLayer layer : this.layers) {
            try {
                layer.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void initializeEarthViewConfiguration(EarthViewConfiguration newEarthViewConfiguration) {
        if (newEarthViewConfiguration != null) {
            for (AbstractWorldWindLayer layer : newEarthViewConfiguration.getLayers()) {
                this.addLayer(layer);
            }
            this.updateAllLayers();
        }
    }

    protected WorldWindowGLJPanel getWorldWindowGLJPanel() {
        if (this.worldWindowGLJPanel == null) {
            this.worldWindowGLJPanel = new WorldWindowGLJPanel();
            this.worldWindowGLJPanel.setModel((Model)new BasicModel());
        }
        return this.worldWindowGLJPanel;
    }

    protected Adapter getEarthViewConfigurationAdapter() {
        if (this.earthViewConfigurationAdapter == null) {
            this.earthViewConfigurationAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    block17: {
                        if (!(msg.getNotifier() instanceof EarthViewConfiguration)) break block17;
                        int featureId = msg.getFeatureID(EarthViewConfiguration.class);
                        block2 : switch (featureId) {
                            case 2: {
                                int eventType = msg.getEventType();
                                switch (eventType) {
                                    case 3: {
                                        if (msg.getNewValue() instanceof AbstractWorldWindLayer) {
                                            EarthViewComposite.this.addLayer((AbstractWorldWindLayer)msg.getNewValue());
                                            break block2;
                                        }
                                        break block17;
                                    }
                                    case 5: {
                                        try {
                                            List layers = (List)msg.getNewValue();
                                            for (AbstractWorldWindLayer layer : layers) {
                                                EarthViewComposite.this.addLayer(layer);
                                            }
                                            break block17;
                                        }
                                        catch (Throwable t) {
                                            Logger.error(t.getMessage(), t);
                                        }
                                        break block17;
                                    }
                                    case 4: {
                                        if (msg.getOldValue() instanceof AbstractWorldWindLayer) {
                                            EarthViewComposite.this.removeLayer((AbstractWorldWindLayer)msg.getOldValue());
                                            break block2;
                                        }
                                        break block17;
                                    }
                                    case 6: {
                                        try {
                                            List layers = (List)msg.getOldValue();
                                            for (AbstractWorldWindLayer layer : layers) {
                                                EarthViewComposite.this.removeLayer(layer);
                                            }
                                        }
                                        catch (Throwable t) {
                                            Logger.error(t.getMessage(), t);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            };
        }
        return this.earthViewConfigurationAdapter;
    }

    public static enum EarthViewMode {
        ROUND,
        FLAT;

    }
}

