/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.composites;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.apogy.common.databinding.converters.DoubleToStringConverter;
import org.eclipse.apogy.common.databinding.converters.StringToDoubleConverter;
import org.eclipse.apogy.core.environment.earth.ApogyEarthEnvironmentPackage;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.ui.databindings.DegreeStringToRadiansConverter;
import org.eclipse.apogy.core.environment.ui.databindings.RadiansToDegreesStringConverter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GeographicCoordinatesComposite
extends Composite {
    public static final String DEGREE_STRING = "\u00b0";
    protected GeographicCoordinates geographicCoordinates;
    protected DecimalFormat decimalFormat;
    private DataBindingContext m_bindingContext;
    private final Text longitudeText;
    private final Text latitudeText;
    private final Text elevationText;
    private final EditingDomain editingDomain;
    private boolean enableEditing = true;

    public GeographicCoordinatesComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public GeographicCoordinatesComposite(Composite parent, int style, EditingDomain editingDomain) {
        super(parent, style);
        this.editingDomain = editingDomain;
        this.setLayout((Layout)new GridLayout(3, true));
        Label latitudeLabel = new Label((Composite)this, 0);
        latitudeLabel.setText("Latitude (\u00b0)");
        latitudeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label longitudeLabel = new Label((Composite)this, 0);
        longitudeLabel.setText("Longitude (\u00b0)");
        longitudeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label elevationLabel = new Label((Composite)this, 0);
        elevationLabel.setText("Elevation (m)");
        elevationLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.latitudeText = new Text((Composite)this, 2052);
        this.latitudeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.longitudeText = new Text((Composite)this, 2052);
        this.longitudeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.elevationText = new Text((Composite)this, 2052);
        this.elevationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (GeographicCoordinatesComposite.this.m_bindingContext != null) {
                    GeographicCoordinatesComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void checkSubclass() {
    }

    public boolean isEnableEditing() {
        return this.enableEditing;
    }

    public void setEnableEditing(final boolean enableEditing) {
        this.enableEditing = enableEditing;
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
            this.m_bindingContext = null;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (enableEditing) {
                    GeographicCoordinatesComposite.this.longitudeText.setEditable(true);
                    GeographicCoordinatesComposite.this.latitudeText.setEditable(true);
                    GeographicCoordinatesComposite.this.elevationText.setEditable(true);
                } else {
                    GeographicCoordinatesComposite.this.longitudeText.setEditable(false);
                    GeographicCoordinatesComposite.this.latitudeText.setEditable(false);
                    GeographicCoordinatesComposite.this.elevationText.setEditable(false);
                }
            }
        });
        if (this.geographicCoordinates != null) {
            this.m_bindingContext = this.enableEditing ? this.custom_initDataBindings() : this.initDataBindingsNoEditing();
        }
    }

    public GeographicCoordinates getGeographicCoordinates() {
        return this.geographicCoordinates;
    }

    public void setGeographicCoordinates(GeographicCoordinates newGeographicCoordinates) {
        this.setGeographicCoordinates(newGeographicCoordinates, true);
    }

    public void setGeographicCoordinates(GeographicCoordinates newGeographicCoordinates, boolean update) {
        this.geographicCoordinates = newGeographicCoordinates;
        if (update) {
            if (this.m_bindingContext != null) {
                this.m_bindingContext.dispose();
                this.m_bindingContext = null;
            }
            if (this.geographicCoordinates != null) {
                this.m_bindingContext = this.enableEditing ? this.custom_initDataBindings() : this.initDataBindingsNoEditing();
            }
        }
    }

    protected DecimalFormat getDecimalFormat() {
        if (this.decimalFormat == null) {
            this.decimalFormat = new DecimalFormat("0.0000000");
        }
        return this.decimalFormat;
    }

    protected DataBindingContext custom_initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue longitudeObserveWidget = WidgetProperties.text((int)16).observe((Widget)this.longitudeText);
        IObservableValue xObserveValue = this.editingDomain == null ? EMFProperties.value((EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE).observe((Object)this.geographicCoordinates) : EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE).observe((Object)this.geographicCoordinates);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new DegreeStringToRadiansConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new RadiansToDegreesStringConverter((NumberFormat)this.getDecimalFormat()));
        bindingContext.bindValue((IObservableValue)longitudeObserveWidget, xObserveValue, strategy, strategy_1);
        ISWTObservableValue yObserveWidget = WidgetProperties.text((int)16).observe((Widget)this.latitudeText);
        IObservableValue yObserveValue = this.editingDomain == null ? EMFProperties.value((EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE).observe((Object)this.geographicCoordinates) : EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE).observe((Object)this.geographicCoordinates);
        UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
        strategy_2.setConverter((IConverter)new DegreeStringToRadiansConverter());
        UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
        strategy_3.setConverter((IConverter)new RadiansToDegreesStringConverter((NumberFormat)this.getDecimalFormat()));
        bindingContext.bindValue((IObservableValue)yObserveWidget, yObserveValue, strategy_2, strategy_3);
        ISWTObservableValue zObserveWidget = WidgetProperties.text((int)16).observe((Widget)this.elevationText);
        IObservableValue zObserveValue = this.editingDomain == null ? EMFProperties.value((EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION).observe((Object)this.geographicCoordinates) : EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION).observe((Object)this.geographicCoordinates);
        UpdateValueStrategy strategy_4 = new UpdateValueStrategy();
        strategy_4.setConverter((IConverter)new StringToDoubleConverter());
        UpdateValueStrategy strategy_5 = new UpdateValueStrategy();
        strategy_5.setConverter((IConverter)new DoubleToStringConverter((NumberFormat)new DecimalFormat("0.000")));
        bindingContext.bindValue((IObservableValue)zObserveWidget, zObserveValue, strategy_4, strategy_5);
        return bindingContext;
    }

    protected DataBindingContext initDataBindingsNoEditing() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue xObserveWidget = WidgetProperties.text((int)16).observe((Widget)this.longitudeText);
        IObservableValue xObserveValue = this.editingDomain == null ? EMFProperties.value((EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE).observe((Object)this.geographicCoordinates) : EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__LONGITUDE).observe((Object)this.geographicCoordinates);
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new RadiansToDegreesStringConverter((NumberFormat)this.getDecimalFormat()));
        bindingContext.bindValue((IObservableValue)xObserveWidget, xObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), strategy_1);
        ISWTObservableValue yObserveWidget = WidgetProperties.text((int)16).observe((Widget)this.latitudeText);
        IObservableValue yObserveValue = this.editingDomain == null ? EMFProperties.value((EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE).observe((Object)this.geographicCoordinates) : EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__LATITUDE).observe((Object)this.geographicCoordinates);
        UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
        strategy_3.setConverter((IConverter)new RadiansToDegreesStringConverter((NumberFormat)this.getDecimalFormat()));
        bindingContext.bindValue((IObservableValue)yObserveWidget, yObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), strategy_3);
        ISWTObservableValue zObserveWidget = WidgetProperties.text((int)16).observe((Widget)this.elevationText);
        IObservableValue zObserveValue = this.editingDomain == null ? EMFProperties.value((EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION).observe((Object)this.geographicCoordinates) : EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ApogyEarthEnvironmentPackage.Literals.GEOGRAPHIC_COORDINATES__ELEVATION).observe((Object)this.geographicCoordinates);
        UpdateValueStrategy strategy_5 = new UpdateValueStrategy();
        strategy_5.setConverter((IConverter)new DoubleToStringConverter((NumberFormat)new DecimalFormat("0.000")));
        bindingContext.bindValue((IObservableValue)zObserveWidget, zObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), strategy_5);
        return bindingContext;
    }
}

