/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.RenderableLayer;
import javax.vecmath.Color3f;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIPackage;
import org.eclipse.apogy.common.math.ApogyCommonMathPackage;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsPackage;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.earth.ApogyEarthEnvironmentPackage;
import org.eclipse.apogy.core.environment.earth.ui.AbstractWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.AbstractWorldWindLayerWizardPagesProvider;
import org.eclipse.apogy.core.environment.earth.ui.AirspaceWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.AirspaceWorldWindLayerWizardPagesProvider;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIFactory;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.EarthSurfaceLocationWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.EarthSurfaceLocationWorldWindLayerWizardPagesProvider;
import org.eclipse.apogy.core.environment.earth.ui.EarthUIFacade;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfigurationList;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfigurationReference;
import org.eclipse.apogy.core.environment.earth.ui.GeographicCoordinatesPathWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.GeographicCoordinatesWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.KMLWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.KMLWorldWindLayerWizardPagesProvider;
import org.eclipse.apogy.core.environment.earth.ui.SurfacePolygonWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.SurfacePolygonWorldWindLayerWizardPagesProvider;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.jface.viewers.ISelection;

public class ApogyEarthEnvironmentUIPackageImpl
extends EPackageImpl
implements ApogyEarthEnvironmentUIPackage {
    private EClass earthUIFacadeEClass = null;
    private EClass earthViewConfigurationListEClass = null;
    private EClass earthViewConfigurationEClass = null;
    private EClass earthViewConfigurationReferenceEClass = null;
    private EClass abstractWorldWindLayerEClass = null;
    private EClass geographicCoordinatesWorldWindLayerEClass = null;
    private EClass earthSurfaceLocationWorldWindLayerEClass = null;
    private EClass geographicCoordinatesPathWorldWindLayerEClass = null;
    private EClass surfacePolygonWorldWindLayerEClass = null;
    private EClass airspaceWorldWindLayerEClass = null;
    private EClass kmlWorldWindLayerEClass = null;
    private EClass abstractWorldWindLayerWizardPagesProviderEClass = null;
    private EClass earthSurfaceLocationWorldWindLayerWizardPagesProviderEClass = null;
    private EClass surfacePolygonWorldWindLayerWizardPagesProviderEClass = null;
    private EClass airspaceWorldWindLayerWizardPagesProviderEClass = null;
    private EClass kmlWorldWindLayerWizardPagesProviderEClass = null;
    private EDataType color3fEDataType = null;
    private EDataType renderableLayerEDataType = null;
    private EDataType iSelectionEDataType = null;
    private EDataType worldWindowEDataType = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    private ApogyEarthEnvironmentUIPackageImpl() {
        super("org.eclipse.apogy.core.environment.earth.ui", (EFactory)ApogyEarthEnvironmentUIFactory.eINSTANCE);
    }

    public static ApogyEarthEnvironmentUIPackage init() {
        if (isInited) {
            return (ApogyEarthEnvironmentUIPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.environment.earth.ui");
        }
        Object registeredApogyEarthEnvironmentUIPackage = EPackage.Registry.INSTANCE.get((Object)"org.eclipse.apogy.core.environment.earth.ui");
        ApogyEarthEnvironmentUIPackageImpl theApogyEarthEnvironmentUIPackage = registeredApogyEarthEnvironmentUIPackage instanceof ApogyEarthEnvironmentUIPackageImpl ? (ApogyEarthEnvironmentUIPackageImpl)registeredApogyEarthEnvironmentUIPackage : new ApogyEarthEnvironmentUIPackageImpl();
        isInited = true;
        ApogyCoreInvocatorPackage.eINSTANCE.eClass();
        ApogyCommonEMFPackage.eINSTANCE.eClass();
        ApogyCorePackage.eINSTANCE.eClass();
        EcorePackage.eINSTANCE.eClass();
        ApogyEarthEnvironmentPackage.eINSTANCE.eClass();
        ApogyCommonEMFUIPackage.eINSTANCE.eClass();
        ApogyCommonMathPackage.eINSTANCE.eClass();
        ApogyCommonTopologyPackage.eINSTANCE.eClass();
        ApogyCommonTopologyBindingsPackage.eINSTANCE.eClass();
        ApogyCoreEnvironmentPackage.eINSTANCE.eClass();
        theApogyEarthEnvironmentUIPackage.createPackageContents();
        theApogyEarthEnvironmentUIPackage.initializePackageContents();
        theApogyEarthEnvironmentUIPackage.freeze();
        EPackage.Registry.INSTANCE.put((Object)"org.eclipse.apogy.core.environment.earth.ui", (Object)theApogyEarthEnvironmentUIPackage);
        return theApogyEarthEnvironmentUIPackage;
    }

    @Override
    public EClass getEarthUIFacade() {
        return this.earthUIFacadeEClass;
    }

    @Override
    public EOperation getEarthUIFacade__GetActiveEarthViewConfigurationList() {
        return (EOperation)this.earthUIFacadeEClass.getEOperations().get(0);
    }

    @Override
    public EClass getEarthViewConfigurationList() {
        return this.earthViewConfigurationListEClass;
    }

    @Override
    public EReference getEarthViewConfigurationList_EarthViewConfigurations() {
        return (EReference)this.earthViewConfigurationListEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getEarthViewConfiguration() {
        return this.earthViewConfigurationEClass;
    }

    @Override
    public EReference getEarthViewConfiguration_Layers() {
        return (EReference)this.earthViewConfigurationEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EOperation getEarthViewConfiguration__SelectionChanged__ISelection() {
        return (EOperation)this.earthViewConfigurationEClass.getEOperations().get(0);
    }

    @Override
    public EClass getEarthViewConfigurationReference() {
        return this.earthViewConfigurationReferenceEClass;
    }

    @Override
    public EReference getEarthViewConfigurationReference_EarthViewConfiguration() {
        return (EReference)this.earthViewConfigurationReferenceEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getAbstractWorldWindLayer() {
        return this.abstractWorldWindLayerEClass;
    }

    @Override
    public EAttribute getAbstractWorldWindLayer_Disposed() {
        return (EAttribute)this.abstractWorldWindLayerEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getAbstractWorldWindLayer_Visible() {
        return (EAttribute)this.abstractWorldWindLayerEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getAbstractWorldWindLayer_Blinking() {
        return (EAttribute)this.abstractWorldWindLayerEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getAbstractWorldWindLayer_RenderableLayer() {
        return (EAttribute)this.abstractWorldWindLayerEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EAttribute getAbstractWorldWindLayer_WorldWindow() {
        return (EAttribute)this.abstractWorldWindLayerEClass.getEStructuralFeatures().get(4);
    }

    @Override
    public EOperation getAbstractWorldWindLayer__Initialise() {
        return (EOperation)this.abstractWorldWindLayerEClass.getEOperations().get(0);
    }

    @Override
    public EOperation getAbstractWorldWindLayer__Dispose() {
        return (EOperation)this.abstractWorldWindLayerEClass.getEOperations().get(1);
    }

    @Override
    public EOperation getAbstractWorldWindLayer__SelectionChanged__ISelection() {
        return (EOperation)this.abstractWorldWindLayerEClass.getEOperations().get(2);
    }

    @Override
    public EClass getGeographicCoordinatesWorldWindLayer() {
        return this.geographicCoordinatesWorldWindLayerEClass;
    }

    @Override
    public EReference getGeographicCoordinatesWorldWindLayer_GeographicCoordinatesList() {
        return (EReference)this.geographicCoordinatesWorldWindLayerEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getGeographicCoordinatesWorldWindLayer_LockSelection() {
        return (EAttribute)this.geographicCoordinatesWorldWindLayerEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getGeographicCoordinatesWorldWindLayer_DisplayLocation() {
        return (EAttribute)this.geographicCoordinatesWorldWindLayerEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getGeographicCoordinatesWorldWindLayer_DisplayedRadius() {
        return (EAttribute)this.geographicCoordinatesWorldWindLayerEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EClass getEarthSurfaceLocationWorldWindLayer() {
        return this.earthSurfaceLocationWorldWindLayerEClass;
    }

    @Override
    public EReference getEarthSurfaceLocationWorldWindLayer_EarthSurfaceLocation() {
        return (EReference)this.earthSurfaceLocationWorldWindLayerEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getEarthSurfaceLocationWorldWindLayer_TargetRadius() {
        return (EAttribute)this.earthSurfaceLocationWorldWindLayerEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getEarthSurfaceLocationWorldWindLayer_DisplayBalloon() {
        return (EAttribute)this.earthSurfaceLocationWorldWindLayerEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getEarthSurfaceLocationWorldWindLayer_DisplayLocation() {
        return (EAttribute)this.earthSurfaceLocationWorldWindLayerEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EAttribute getEarthSurfaceLocationWorldWindLayer_Color() {
        return (EAttribute)this.earthSurfaceLocationWorldWindLayerEClass.getEStructuralFeatures().get(4);
    }

    @Override
    public EAttribute getEarthSurfaceLocationWorldWindLayer_Opacity() {
        return (EAttribute)this.earthSurfaceLocationWorldWindLayerEClass.getEStructuralFeatures().get(5);
    }

    @Override
    public EClass getGeographicCoordinatesPathWorldWindLayer() {
        return this.geographicCoordinatesPathWorldWindLayerEClass;
    }

    @Override
    public EReference getGeographicCoordinatesPathWorldWindLayer_GeographicCoordinatesList() {
        return (EReference)this.geographicCoordinatesPathWorldWindLayerEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EOperation getGeographicCoordinatesPathWorldWindLayer__ClearPath() {
        return (EOperation)this.geographicCoordinatesPathWorldWindLayerEClass.getEOperations().get(0);
    }

    @Override
    public EClass getSurfacePolygonWorldWindLayer() {
        return this.surfacePolygonWorldWindLayerEClass;
    }

    @Override
    public EReference getSurfacePolygonWorldWindLayer_GeographicCoordinatesList() {
        return (EReference)this.surfacePolygonWorldWindLayerEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getSurfacePolygonWorldWindLayer_Url() {
        return (EAttribute)this.surfacePolygonWorldWindLayerEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getSurfacePolygonWorldWindLayer_Color() {
        return (EAttribute)this.surfacePolygonWorldWindLayerEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getSurfacePolygonWorldWindLayer_Opacity() {
        return (EAttribute)this.surfacePolygonWorldWindLayerEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EOperation getSurfacePolygonWorldWindLayer__IsCoordinatesInside__GeographicCoordinates() {
        return (EOperation)this.surfacePolygonWorldWindLayerEClass.getEOperations().get(0);
    }

    @Override
    public EClass getAirspaceWorldWindLayer() {
        return this.airspaceWorldWindLayerEClass;
    }

    @Override
    public EAttribute getAirspaceWorldWindLayer_LowerAltitude() {
        return (EAttribute)this.airspaceWorldWindLayerEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getAirspaceWorldWindLayer_UpperAltitude() {
        return (EAttribute)this.airspaceWorldWindLayerEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getKMLWorldWindLayer() {
        return this.kmlWorldWindLayerEClass;
    }

    @Override
    public EAttribute getKMLWorldWindLayer_Url() {
        return (EAttribute)this.kmlWorldWindLayerEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getAbstractWorldWindLayerWizardPagesProvider() {
        return this.abstractWorldWindLayerWizardPagesProviderEClass;
    }

    @Override
    public EClass getEarthSurfaceLocationWorldWindLayerWizardPagesProvider() {
        return this.earthSurfaceLocationWorldWindLayerWizardPagesProviderEClass;
    }

    @Override
    public EClass getSurfacePolygonWorldWindLayerWizardPagesProvider() {
        return this.surfacePolygonWorldWindLayerWizardPagesProviderEClass;
    }

    @Override
    public EClass getAirspaceWorldWindLayerWizardPagesProvider() {
        return this.airspaceWorldWindLayerWizardPagesProviderEClass;
    }

    @Override
    public EClass getKMLWorldWindLayerWizardPagesProvider() {
        return this.kmlWorldWindLayerWizardPagesProviderEClass;
    }

    @Override
    public EDataType getColor3f() {
        return this.color3fEDataType;
    }

    @Override
    public EDataType getRenderableLayer() {
        return this.renderableLayerEDataType;
    }

    @Override
    public EDataType getISelection() {
        return this.iSelectionEDataType;
    }

    @Override
    public EDataType getWorldWindow() {
        return this.worldWindowEDataType;
    }

    @Override
    public ApogyEarthEnvironmentUIFactory getApogyEarthEnvironmentUIFactory() {
        return (ApogyEarthEnvironmentUIFactory)this.getEFactoryInstance();
    }

    public void createPackageContents() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.earthUIFacadeEClass = this.createEClass(0);
        this.createEOperation(this.earthUIFacadeEClass, 0);
        this.earthViewConfigurationListEClass = this.createEClass(1);
        this.createEReference(this.earthViewConfigurationListEClass, 1);
        this.earthViewConfigurationEClass = this.createEClass(2);
        this.createEReference(this.earthViewConfigurationEClass, 2);
        this.createEOperation(this.earthViewConfigurationEClass, 0);
        this.earthViewConfigurationReferenceEClass = this.createEClass(3);
        this.createEReference(this.earthViewConfigurationReferenceEClass, 0);
        this.abstractWorldWindLayerEClass = this.createEClass(4);
        this.createEAttribute(this.abstractWorldWindLayerEClass, 4);
        this.createEAttribute(this.abstractWorldWindLayerEClass, 5);
        this.createEAttribute(this.abstractWorldWindLayerEClass, 6);
        this.createEAttribute(this.abstractWorldWindLayerEClass, 7);
        this.createEAttribute(this.abstractWorldWindLayerEClass, 8);
        this.createEOperation(this.abstractWorldWindLayerEClass, 2);
        this.createEOperation(this.abstractWorldWindLayerEClass, 3);
        this.createEOperation(this.abstractWorldWindLayerEClass, 4);
        this.geographicCoordinatesWorldWindLayerEClass = this.createEClass(5);
        this.createEReference(this.geographicCoordinatesWorldWindLayerEClass, 9);
        this.createEAttribute(this.geographicCoordinatesWorldWindLayerEClass, 10);
        this.createEAttribute(this.geographicCoordinatesWorldWindLayerEClass, 11);
        this.createEAttribute(this.geographicCoordinatesWorldWindLayerEClass, 12);
        this.earthSurfaceLocationWorldWindLayerEClass = this.createEClass(6);
        this.createEReference(this.earthSurfaceLocationWorldWindLayerEClass, 9);
        this.createEAttribute(this.earthSurfaceLocationWorldWindLayerEClass, 10);
        this.createEAttribute(this.earthSurfaceLocationWorldWindLayerEClass, 11);
        this.createEAttribute(this.earthSurfaceLocationWorldWindLayerEClass, 12);
        this.createEAttribute(this.earthSurfaceLocationWorldWindLayerEClass, 13);
        this.createEAttribute(this.earthSurfaceLocationWorldWindLayerEClass, 14);
        this.geographicCoordinatesPathWorldWindLayerEClass = this.createEClass(7);
        this.createEReference(this.geographicCoordinatesPathWorldWindLayerEClass, 9);
        this.createEOperation(this.geographicCoordinatesPathWorldWindLayerEClass, 5);
        this.surfacePolygonWorldWindLayerEClass = this.createEClass(8);
        this.createEReference(this.surfacePolygonWorldWindLayerEClass, 9);
        this.createEAttribute(this.surfacePolygonWorldWindLayerEClass, 10);
        this.createEAttribute(this.surfacePolygonWorldWindLayerEClass, 11);
        this.createEAttribute(this.surfacePolygonWorldWindLayerEClass, 12);
        this.createEOperation(this.surfacePolygonWorldWindLayerEClass, 5);
        this.airspaceWorldWindLayerEClass = this.createEClass(9);
        this.createEAttribute(this.airspaceWorldWindLayerEClass, 13);
        this.createEAttribute(this.airspaceWorldWindLayerEClass, 14);
        this.kmlWorldWindLayerEClass = this.createEClass(10);
        this.createEAttribute(this.kmlWorldWindLayerEClass, 9);
        this.abstractWorldWindLayerWizardPagesProviderEClass = this.createEClass(11);
        this.earthSurfaceLocationWorldWindLayerWizardPagesProviderEClass = this.createEClass(12);
        this.surfacePolygonWorldWindLayerWizardPagesProviderEClass = this.createEClass(13);
        this.airspaceWorldWindLayerWizardPagesProviderEClass = this.createEClass(14);
        this.kmlWorldWindLayerWizardPagesProviderEClass = this.createEClass(15);
        this.color3fEDataType = this.createEDataType(16);
        this.renderableLayerEDataType = this.createEDataType(17);
        this.iSelectionEDataType = this.createEDataType(18);
        this.worldWindowEDataType = this.createEDataType(19);
    }

    public void initializePackageContents() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setName("ui");
        this.setNsPrefix("ui");
        this.setNsURI("org.eclipse.apogy.core.environment.earth.ui");
        ApogyCoreInvocatorPackage theApogyCoreInvocatorPackage = (ApogyCoreInvocatorPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.invocator");
        ApogyCommonEMFPackage theApogyCommonEMFPackage = (ApogyCommonEMFPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.emf");
        ApogyCorePackage theApogyCorePackage = (ApogyCorePackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core");
        EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        ApogyEarthEnvironmentPackage theApogyEarthEnvironmentPackage = (ApogyEarthEnvironmentPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.environment.earth");
        ApogyCommonEMFUIPackage theApogyCommonEMFUIPackage = (ApogyCommonEMFUIPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.emf.ui");
        this.earthViewConfigurationListEClass.getESuperTypes().add((Object)theApogyCoreInvocatorPackage.getAbstractToolsListContainer());
        this.earthViewConfigurationEClass.getESuperTypes().add((Object)theApogyCommonEMFPackage.getNamed());
        this.earthViewConfigurationEClass.getESuperTypes().add((Object)theApogyCommonEMFPackage.getDescribed());
        this.abstractWorldWindLayerEClass.getESuperTypes().add((Object)theApogyCorePackage.getUpdatable());
        this.abstractWorldWindLayerEClass.getESuperTypes().add((Object)theApogyCommonEMFPackage.getNamed());
        this.abstractWorldWindLayerEClass.getESuperTypes().add((Object)theApogyCommonEMFPackage.getDescribed());
        this.geographicCoordinatesWorldWindLayerEClass.getESuperTypes().add((Object)this.getAbstractWorldWindLayer());
        this.earthSurfaceLocationWorldWindLayerEClass.getESuperTypes().add((Object)this.getAbstractWorldWindLayer());
        this.geographicCoordinatesPathWorldWindLayerEClass.getESuperTypes().add((Object)this.getAbstractWorldWindLayer());
        this.surfacePolygonWorldWindLayerEClass.getESuperTypes().add((Object)this.getAbstractWorldWindLayer());
        this.airspaceWorldWindLayerEClass.getESuperTypes().add((Object)this.getSurfacePolygonWorldWindLayer());
        this.kmlWorldWindLayerEClass.getESuperTypes().add((Object)this.getAbstractWorldWindLayer());
        this.abstractWorldWindLayerWizardPagesProviderEClass.getESuperTypes().add((Object)theApogyCommonEMFUIPackage.getNamedDescribedWizardPagesProvider());
        this.earthSurfaceLocationWorldWindLayerWizardPagesProviderEClass.getESuperTypes().add((Object)this.getAbstractWorldWindLayerWizardPagesProvider());
        this.surfacePolygonWorldWindLayerWizardPagesProviderEClass.getESuperTypes().add((Object)this.getAbstractWorldWindLayerWizardPagesProvider());
        this.airspaceWorldWindLayerWizardPagesProviderEClass.getESuperTypes().add((Object)this.getSurfacePolygonWorldWindLayerWizardPagesProvider());
        this.kmlWorldWindLayerWizardPagesProviderEClass.getESuperTypes().add((Object)this.getAbstractWorldWindLayerWizardPagesProvider());
        this.initEClass(this.earthUIFacadeEClass, EarthUIFacade.class, "EarthUIFacade", false, false, true);
        this.initEOperation(this.getEarthUIFacade__GetActiveEarthViewConfigurationList(), (EClassifier)this.getEarthViewConfigurationList(), "getActiveEarthViewConfigurationList", 0, 1, false, true);
        this.initEClass(this.earthViewConfigurationListEClass, EarthViewConfigurationList.class, "EarthViewConfigurationList", false, false, true);
        this.initEReference(this.getEarthViewConfigurationList_EarthViewConfigurations(), (EClassifier)this.getEarthViewConfiguration(), null, "earthViewConfigurations", null, 0, -1, EarthViewConfigurationList.class, false, false, true, true, false, false, true, false, true);
        this.initEClass(this.earthViewConfigurationEClass, EarthViewConfiguration.class, "EarthViewConfiguration", false, false, true);
        this.initEReference(this.getEarthViewConfiguration_Layers(), (EClassifier)this.getAbstractWorldWindLayer(), null, "layers", null, 0, -1, EarthViewConfiguration.class, false, false, true, true, false, false, true, false, true);
        EOperation op = this.initEOperation(this.getEarthViewConfiguration__SelectionChanged__ISelection(), null, "selectionChanged", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)this.getISelection(), "selection", 0, 1, false, true);
        this.initEClass(this.earthViewConfigurationReferenceEClass, EarthViewConfigurationReference.class, "EarthViewConfigurationReference", false, false, true);
        this.initEReference(this.getEarthViewConfigurationReference_EarthViewConfiguration(), (EClassifier)this.getEarthViewConfiguration(), null, "earthViewConfiguration", null, 0, 1, EarthViewConfigurationReference.class, false, false, true, false, true, false, true, false, true);
        this.initEClass(this.abstractWorldWindLayerEClass, AbstractWorldWindLayer.class, "AbstractWorldWindLayer", true, false, true);
        this.initEAttribute(this.getAbstractWorldWindLayer_Disposed(), (EClassifier)theEcorePackage.getEBoolean(), "disposed", "false", 0, 1, AbstractWorldWindLayer.class, true, false, true, false, false, false, false, true);
        this.initEAttribute(this.getAbstractWorldWindLayer_Visible(), (EClassifier)theEcorePackage.getEBoolean(), "visible", "true", 0, 1, AbstractWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getAbstractWorldWindLayer_Blinking(), (EClassifier)theEcorePackage.getEBoolean(), "blinking", "false", 0, 1, AbstractWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getAbstractWorldWindLayer_RenderableLayer(), (EClassifier)this.getRenderableLayer(), "renderableLayer", null, 0, 1, AbstractWorldWindLayer.class, true, false, true, false, false, false, false, true);
        this.initEAttribute(this.getAbstractWorldWindLayer_WorldWindow(), (EClassifier)this.getWorldWindow(), "worldWindow", null, 0, 1, AbstractWorldWindLayer.class, true, false, true, false, false, false, false, true);
        this.initEOperation(this.getAbstractWorldWindLayer__Initialise(), null, "initialise", 0, 1, false, true);
        this.initEOperation(this.getAbstractWorldWindLayer__Dispose(), null, "dispose", 0, 1, false, true);
        op = this.initEOperation(this.getAbstractWorldWindLayer__SelectionChanged__ISelection(), null, "selectionChanged", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)this.getISelection(), "selection", 0, 1, false, true);
        this.initEClass(this.geographicCoordinatesWorldWindLayerEClass, GeographicCoordinatesWorldWindLayer.class, "GeographicCoordinatesWorldWindLayer", false, false, true);
        this.initEReference(this.getGeographicCoordinatesWorldWindLayer_GeographicCoordinatesList(), (EClassifier)theApogyEarthEnvironmentPackage.getGeographicCoordinates(), null, "geographicCoordinatesList", null, 0, -1, GeographicCoordinatesWorldWindLayer.class, false, false, true, true, false, false, true, false, true);
        this.initEAttribute(this.getGeographicCoordinatesWorldWindLayer_LockSelection(), (EClassifier)theEcorePackage.getEBoolean(), "lockSelection", "true", 0, 1, GeographicCoordinatesWorldWindLayer.class, true, false, true, false, false, false, false, true);
        this.initEAttribute(this.getGeographicCoordinatesWorldWindLayer_DisplayLocation(), (EClassifier)theEcorePackage.getEBoolean(), "displayLocation", "true", 0, 1, GeographicCoordinatesWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getGeographicCoordinatesWorldWindLayer_DisplayedRadius(), (EClassifier)theEcorePackage.getEDouble(), "displayedRadius", "50", 0, 1, GeographicCoordinatesWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEClass(this.earthSurfaceLocationWorldWindLayerEClass, EarthSurfaceLocationWorldWindLayer.class, "EarthSurfaceLocationWorldWindLayer", false, false, true);
        this.initEReference(this.getEarthSurfaceLocationWorldWindLayer_EarthSurfaceLocation(), (EClassifier)theApogyEarthEnvironmentPackage.getEarthSurfaceLocation(), null, "earthSurfaceLocation", null, 0, 1, EarthSurfaceLocationWorldWindLayer.class, false, false, true, true, false, false, true, false, true);
        this.initEAttribute(this.getEarthSurfaceLocationWorldWindLayer_TargetRadius(), (EClassifier)theEcorePackage.getEDouble(), "targetRadius", "50", 0, 1, EarthSurfaceLocationWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getEarthSurfaceLocationWorldWindLayer_DisplayBalloon(), (EClassifier)theEcorePackage.getEBoolean(), "displayBalloon", "true", 0, 1, EarthSurfaceLocationWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getEarthSurfaceLocationWorldWindLayer_DisplayLocation(), (EClassifier)theEcorePackage.getEBoolean(), "displayLocation", "true", 0, 1, EarthSurfaceLocationWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getEarthSurfaceLocationWorldWindLayer_Color(), (EClassifier)this.getColor3f(), "color", "0.0,1.0,0.0", 0, 1, EarthSurfaceLocationWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getEarthSurfaceLocationWorldWindLayer_Opacity(), (EClassifier)theEcorePackage.getEDouble(), "opacity", "0.2", 0, 1, EarthSurfaceLocationWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEClass(this.geographicCoordinatesPathWorldWindLayerEClass, GeographicCoordinatesPathWorldWindLayer.class, "GeographicCoordinatesPathWorldWindLayer", false, false, true);
        this.initEReference(this.getGeographicCoordinatesPathWorldWindLayer_GeographicCoordinatesList(), (EClassifier)theApogyEarthEnvironmentPackage.getGeographicCoordinates(), null, "geographicCoordinatesList", null, 0, -1, GeographicCoordinatesPathWorldWindLayer.class, false, false, true, true, false, false, true, false, true);
        this.initEOperation(this.getGeographicCoordinatesPathWorldWindLayer__ClearPath(), null, "clearPath", 0, 1, false, true);
        this.initEClass(this.surfacePolygonWorldWindLayerEClass, SurfacePolygonWorldWindLayer.class, "SurfacePolygonWorldWindLayer", false, false, true);
        this.initEReference(this.getSurfacePolygonWorldWindLayer_GeographicCoordinatesList(), (EClassifier)theApogyEarthEnvironmentPackage.getGeographicCoordinates(), null, "geographicCoordinatesList", null, 0, -1, SurfacePolygonWorldWindLayer.class, false, false, true, true, false, false, true, false, true);
        this.initEAttribute(this.getSurfacePolygonWorldWindLayer_Url(), (EClassifier)theEcorePackage.getEString(), "url", null, 0, 1, SurfacePolygonWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getSurfacePolygonWorldWindLayer_Color(), (EClassifier)this.getColor3f(), "color", "0.0,1.0,0.0", 0, 1, SurfacePolygonWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getSurfacePolygonWorldWindLayer_Opacity(), (EClassifier)theEcorePackage.getEDouble(), "opacity", "1.0", 0, 1, SurfacePolygonWorldWindLayer.class, false, false, true, false, false, false, false, true);
        op = this.initEOperation(this.getSurfacePolygonWorldWindLayer__IsCoordinatesInside__GeographicCoordinates(), (EClassifier)theEcorePackage.getEBoolean(), "isCoordinatesInside", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyEarthEnvironmentPackage.getGeographicCoordinates(), "coordinates", 0, 1, false, true);
        this.initEClass(this.airspaceWorldWindLayerEClass, AirspaceWorldWindLayer.class, "AirspaceWorldWindLayer", false, false, true);
        this.initEAttribute(this.getAirspaceWorldWindLayer_LowerAltitude(), (EClassifier)theEcorePackage.getEDouble(), "lowerAltitude", null, 0, 1, AirspaceWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getAirspaceWorldWindLayer_UpperAltitude(), (EClassifier)theEcorePackage.getEDouble(), "upperAltitude", "10000", 0, 1, AirspaceWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEClass(this.kmlWorldWindLayerEClass, KMLWorldWindLayer.class, "KMLWorldWindLayer", false, false, true);
        this.initEAttribute(this.getKMLWorldWindLayer_Url(), (EClassifier)theEcorePackage.getEString(), "url", null, 0, 1, KMLWorldWindLayer.class, false, false, true, false, false, false, false, true);
        this.initEClass(this.abstractWorldWindLayerWizardPagesProviderEClass, AbstractWorldWindLayerWizardPagesProvider.class, "AbstractWorldWindLayerWizardPagesProvider", false, false, true);
        this.initEClass(this.earthSurfaceLocationWorldWindLayerWizardPagesProviderEClass, EarthSurfaceLocationWorldWindLayerWizardPagesProvider.class, "EarthSurfaceLocationWorldWindLayerWizardPagesProvider", false, false, true);
        this.initEClass(this.surfacePolygonWorldWindLayerWizardPagesProviderEClass, SurfacePolygonWorldWindLayerWizardPagesProvider.class, "SurfacePolygonWorldWindLayerWizardPagesProvider", false, false, true);
        this.initEClass(this.airspaceWorldWindLayerWizardPagesProviderEClass, AirspaceWorldWindLayerWizardPagesProvider.class, "AirspaceWorldWindLayerWizardPagesProvider", false, false, true);
        this.initEClass(this.kmlWorldWindLayerWizardPagesProviderEClass, KMLWorldWindLayerWizardPagesProvider.class, "KMLWorldWindLayerWizardPagesProvider", false, false, true);
        this.initEDataType(this.color3fEDataType, Color3f.class, "Color3f", true, false);
        this.initEDataType(this.renderableLayerEDataType, RenderableLayer.class, "RenderableLayer", true, false);
        this.initEDataType(this.iSelectionEDataType, ISelection.class, "ISelection", true, false);
        this.initEDataType(this.worldWindowEDataType, WorldWindow.class, "WorldWindow", true, false);
        this.createResource("org.eclipse.apogy.core.environment.earth.ui");
        this.createGenModelAnnotations();
        this.createApogyAnnotations();
    }

    protected void createGenModelAnnotations() {
        String source = "http://www.eclipse.org/emf/2002/GenModel";
        this.addAnnotation((ENamedElement)this, source, new String[]{"prefix", "ApogyEarthEnvironmentUI", "childCreationExtenders", "true", "extensibleProviderFactory", "true", "multipleEditorPages", "false", "copyrightText", "*******************************************************************************\nCopyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency \nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n\nContributors:\n     Pierre Allard - initial API and implementation\n        \nSPDX-License-Identifier: EPL-1.0    \n*******************************************************************************", "modelName", "ApogyCoreEnvironmentUI", "complianceLevel", "8.0", "suppressGenModelAnnotations", "false", "dynamicTemplates", "true", "templateDirectory", "platform:/plugin/org.eclipse.apogy.common.emf.codegen/templates", "modelDirectory", "/org.eclipse.apogy.core.environment.earth.ui/src-gen", "editDirectory", "/org.eclipse.apogy.core.environment.earth.ui.edit/src-gen", "basePackage", "org.eclipse.apogy.core.environment.earth"});
        this.addAnnotation((ENamedElement)this.color3fEDataType, source, new String[]{"documentation", "*\nTypes definition."});
        this.addAnnotation((ENamedElement)this.getEarthUIFacade__GetActiveEarthViewConfigurationList(), source, new String[]{"documentation", "*\nReturns the getActiveEarthViewConfigurationList in the Active Session.\n@return The getActiveEarthViewConfigurationList in the Active Session, creates one if none is found."});
        this.addAnnotation((ENamedElement)this.earthViewConfigurationListEClass, source, new String[]{"documentation", "*\nA list of EarthViewConfigurations."});
        this.addAnnotation((ENamedElement)this.earthViewConfigurationEClass, source, new String[]{"documentation", "*\nClass used to contain the configuration to be used for an EarthView."});
        this.addAnnotation((ENamedElement)this.getEarthViewConfiguration__SelectionChanged__ISelection(), source, new String[]{"documentation", "*\nMethod that notifies all AbstractWorldWindLayer of a new selection.\n@param selection The new selection made."});
        this.addAnnotation((ENamedElement)this.getEarthViewConfiguration_Layers(), source, new String[]{"documentation", "*\nList of Maps being displayed.", "children", "true", "notify", "true", "property", "None"});
        this.addAnnotation((ENamedElement)this.earthViewConfigurationReferenceEClass, source, new String[]{"documentation", "*\nClass implementing a reference to a EarthViewConfiguration."});
        this.addAnnotation((ENamedElement)this.abstractWorldWindLayerEClass, source, new String[]{"documentation", "*\nDefines a Layer that can be shown on the WordWindModel"});
        this.addAnnotation((ENamedElement)this.getAbstractWorldWindLayer__Initialise(), source, new String[]{"documentation", "*\nMethod called when the layer is first rendered. Can be called multiple times."});
        this.addAnnotation((ENamedElement)this.getAbstractWorldWindLayer__Dispose(), source, new String[]{"documentation", "*\nMethod called when the layer is not longer\nneeded (i.e. when it gets deleted.)"});
        this.addAnnotation((ENamedElement)this.getAbstractWorldWindLayer__SelectionChanged__ISelection(), source, new String[]{"documentation", "*\nMethod called when a selection is made by the user.\nSub-classes can override this method if applicable.\n@param selection The new selection made."});
        this.addAnnotation((ENamedElement)this.getAbstractWorldWindLayer_Disposed(), source, new String[]{"documentation", "*\nWhether or not this layer has been disposed of.", "notify", "false", "property", "None"});
        this.addAnnotation((ENamedElement)this.getAbstractWorldWindLayer_Visible(), source, new String[]{"documentation", "*\nWhether or not to display the layer.", "notify", "true", "property", "Editable"});
        this.addAnnotation((ENamedElement)this.getAbstractWorldWindLayer_Blinking(), source, new String[]{"documentation", "*\nWhen enabled, make the layer blink.", "notify", "true", "property", "Editable"});
        this.addAnnotation((ENamedElement)this.getAbstractWorldWindLayer_RenderableLayer(), source, new String[]{"documentation", "*\nThe RenderableLayer associated with this Layer", "children", "false", "notify", "false", "property", "None"});
        this.addAnnotation((ENamedElement)this.getAbstractWorldWindLayer_WorldWindow(), source, new String[]{"documentation", "*\nA reference to the WorldWindow displaying the layer.", "children", "false", "notify", "false", "property", "None"});
        this.addAnnotation((ENamedElement)this.geographicCoordinatesWorldWindLayerEClass, source, new String[]{"documentation", "*\nWorldWindLayer that displays a list of position on Earth."});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinatesWorldWindLayer_GeographicCoordinatesList(), source, new String[]{"notify", "true"});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinatesWorldWindLayer_LockSelection(), source, new String[]{"documentation", "*\nSpecifies whether or not the layer will respond to new selection.", "notify", "true"});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinatesWorldWindLayer_DisplayLocation(), source, new String[]{"documentation", "*\nSpecified wether or not to add the lat/lon/alt as part of the displayed text.", "notify", "true", "propertyCategory", "VISUALS"});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinatesWorldWindLayer_DisplayedRadius(), source, new String[]{"documentation", "*\nSpecifies the radius of the circle display at the target location.", "propertyCategory", "VISUALS"});
        this.addAnnotation((ENamedElement)this.earthSurfaceLocationWorldWindLayerEClass, source, new String[]{"documentation", "*\nAn AbstractWorldWindLayer representing an location on the surface of the Earth."});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceLocationWorldWindLayer_EarthSurfaceLocation(), source, new String[]{"documentation", "*\nReference to the EarthSurfaceLocation to display."});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceLocationWorldWindLayer_TargetRadius(), source, new String[]{"documentation", "The radius of the target.", "propertyCategory", "VISUALS"});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceLocationWorldWindLayer_DisplayBalloon(), source, new String[]{"documentation", "*\nSpecified whether or not to add a balloon to display the name of the details of the surface location.", "notify", "true", "propertyCategory", "VISUALS"});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceLocationWorldWindLayer_DisplayLocation(), source, new String[]{"documentation", "*\nSpecified whether or not to add the lat/lon/alt as part of the displayed text.", "notify", "true", "propertyCategory", "VISUALS"});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceLocationWorldWindLayer_Color(), source, new String[]{"documentation", "*\nThe color of the location."});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceLocationWorldWindLayer_Opacity(), source, new String[]{"documentation", "*\nThe opacity. 1 if fully opaque, 0 is fully transparent."});
        this.addAnnotation((ENamedElement)this.geographicCoordinatesPathWorldWindLayerEClass, source, new String[]{"documentation", "*\n An AbstractWorldWindLayer representing a path made out of a list of GeographicCoordinates."});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinatesPathWorldWindLayer__ClearPath(), source, new String[]{"documentation", "*\nRemoves all points in the path."});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinatesPathWorldWindLayer_GeographicCoordinatesList(), source, new String[]{"documentation", "*\nThe list of geographical coordinates.", "notify", "true"});
        this.addAnnotation((ENamedElement)this.surfacePolygonWorldWindLayerEClass, source, new String[]{"documentation", "*\n An AbstractWorldWindLayer representing a surface area defined by a polygon on the surface."});
        this.addAnnotation((ENamedElement)this.getSurfacePolygonWorldWindLayer__IsCoordinatesInside__GeographicCoordinates(), source, new String[]{"documentation", "*\nReturns whether or not a specified GeographicCoordinates is inside the Airspace.\n@param coordinates The GeographicCoordinates.\n@return True if the coordinates are inside, false otherwise."});
        this.addAnnotation((ENamedElement)this.getSurfacePolygonWorldWindLayer_GeographicCoordinatesList(), source, new String[]{"documentation", "*\nThe list of geographical coordinates representing the outline of the Airspace.", "notify", "true"});
        this.addAnnotation((ENamedElement)this.getSurfacePolygonWorldWindLayer_Url(), source, new String[]{"documentation", "*\nURL to a CSV formated file that contains the geographical coordinates defining the airspace contours.", "notify", "true"});
        this.addAnnotation((ENamedElement)this.getSurfacePolygonWorldWindLayer_Color(), source, new String[]{"documentation", "*\nThe color of the airspace."});
        this.addAnnotation((ENamedElement)this.getSurfacePolygonWorldWindLayer_Opacity(), source, new String[]{"documentation", "*\nThe opacity. 1 if fully opaque, 0 is fully transparent."});
        this.addAnnotation((ENamedElement)this.airspaceWorldWindLayerEClass, source, new String[]{"documentation", "*\n An AbstractWorldWindLayer representing volume in the atmosphere."});
        this.addAnnotation((ENamedElement)this.getAirspaceWorldWindLayer_LowerAltitude(), source, new String[]{"documentation", "*\nThe lower altitude limit, relative to Mean Sea Level. A negative value has the airspace follow the ground.", "notify", "true"});
        this.addAnnotation((ENamedElement)this.getAirspaceWorldWindLayer_UpperAltitude(), source, new String[]{"documentation", "*\nThe upper altitude limit, relative to Mean Sea Level.", "notify", "true"});
        this.addAnnotation((ENamedElement)this.kmlWorldWindLayerEClass, source, new String[]{"documentation", "*\n An AbstractWorldWindLayer representing the content of a KML / KMZ file."});
        this.addAnnotation((ENamedElement)this.getKMLWorldWindLayer_Url(), source, new String[]{"documentation", "*\nThe URL to the KML/KMZ file.", "notify", "true"});
        this.addAnnotation((ENamedElement)this.abstractWorldWindLayerWizardPagesProviderEClass, source, new String[]{"documentation", "*\nWizard Support Classes"});
        this.addAnnotation((ENamedElement)this.earthSurfaceLocationWorldWindLayerWizardPagesProviderEClass, source, new String[]{"documentation", "*\nWizardPagesProvider used to create EarthSurfaceLocationWorldWindLayer."});
        this.addAnnotation((ENamedElement)this.surfacePolygonWorldWindLayerWizardPagesProviderEClass, source, new String[]{"documentation", "*\nWizardPagesProvider used to create SurfacePolygonWorldWindLayer."});
        this.addAnnotation((ENamedElement)this.airspaceWorldWindLayerWizardPagesProviderEClass, source, new String[]{"documentation", "*\nWizardPagesProvider used to create AirspaceWorldWindLayer."});
        this.addAnnotation((ENamedElement)this.kmlWorldWindLayerWizardPagesProviderEClass, source, new String[]{"documentation", "*\nWizardPagesProvider used to create KMLWorldWindLayer."});
    }

    protected void createApogyAnnotations() {
        String source = "http://www.eclipse.org/apogy";
        this.addAnnotation((ENamedElement)this.earthUIFacadeEClass, source, new String[]{"isSingleton", "true", "hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.earthViewConfigurationEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.abstractWorldWindLayerEClass, source, new String[]{"hasCustomClass", "true", "hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.geographicCoordinatesWorldWindLayerEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinatesWorldWindLayer_DisplayedRadius(), source, new String[]{"units", "km"});
        this.addAnnotation((ENamedElement)this.earthSurfaceLocationWorldWindLayerEClass, source, new String[]{"hasCustomClass", "true", "hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceLocationWorldWindLayer_TargetRadius(), source, new String[]{"units", "km"});
        this.addAnnotation((ENamedElement)this.geographicCoordinatesPathWorldWindLayerEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.surfacePolygonWorldWindLayerEClass, source, new String[]{"hasCustomClass", "true", "hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.airspaceWorldWindLayerEClass, source, new String[]{"hasCustomClass", "true", "hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.getAirspaceWorldWindLayer_LowerAltitude(), source, new String[]{"units", "m"});
        this.addAnnotation((ENamedElement)this.getAirspaceWorldWindLayer_UpperAltitude(), source, new String[]{"units", "m"});
        this.addAnnotation((ENamedElement)this.kmlWorldWindLayerEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.earthSurfaceLocationWorldWindLayerWizardPagesProviderEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.surfacePolygonWorldWindLayerWizardPagesProviderEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.airspaceWorldWindLayerWizardPagesProviderEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.kmlWorldWindLayerWizardPagesProviderEClass, source, new String[]{"hasCustomClass", "true"});
    }
}

