/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import edu.wlu.cs.levy.CG.KDTree;
import java.awt.Color;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.RectangularVolumeRegion;
import org.eclipse.apogy.core.environment.surface.impl.CartesianTriangularMeshHeightImageMapLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianTriangularMeshHeightImageMapLayerCustomImpl
extends CartesianTriangularMeshHeightImageMapLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CartesianTriangularMeshHeightImageMapLayerImpl.class);

    @Override
    public void updateImage(IProgressMonitor progressMonitor) {
        CartesianTriangularMesh mesh;
        if (this.getCartesianTriangularMeshMapLayer() != null && (mesh = this.getCartesianTriangularMeshMapLayer().getCurrentMesh()) != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)4);
            long startTime = System.currentTimeMillis();
            RectangularVolumeRegion meshRegion = this.getRectangularVolumeRegion();
            if (meshRegion.getXDimension() > 0.0 && meshRegion.getYDimension() > 0.0) {
                Point3d[][] pixelsLocation = this.getPixelsLocation(this.getCartesianTriangularMeshMapLayer().getCurrentMesh(), (IProgressMonitor)subMonitor.newChild(1));
                int numberPixelAlongX = pixelsLocation.length;
                int numberPixelAlongY = pixelsLocation[0].length;
                double xIncrement = meshRegion.getXDimension() / (double)numberPixelAlongX;
                double yIncrement = meshRegion.getYDimension() / (double)numberPixelAlongY;
                double averagingRadius = Math.sqrt(xIncrement * xIncrement + yIncrement * yIncrement);
                KDTree kdTree = this.createTriangleKDTree(mesh, (IProgressMonitor)subMonitor.newChild(1));
                Point3d[][] pixelsIntersectionPoints = this.getPixelsIntersectionPoints(pixelsLocation, mesh, kdTree, averagingRadius, (IProgressMonitor)subMonitor.newChild(1));
                double minimumMeshHeight = meshRegion.getZMin();
                double maximumMeshHeight = meshRegion.getZMax();
                int[][] pixelColors = new int[numberPixelAlongX][numberPixelAlongY];
                int i = 0;
                while (i < numberPixelAlongX) {
                    int j = 0;
                    while (j < numberPixelAlongY) {
                        Point3d point = pixelsIntersectionPoints[i][j];
                        if (point != null) {
                            pixelColors[i][j] = this.getColor(point.z, minimumMeshHeight, maximumMeshHeight);
                        }
                        ++j;
                    }
                    ++i;
                }
                AbstractEImage image = this.convertToImage(pixelColors, (IProgressMonitor)subMonitor.newChild(1));
                long endTime = System.currentTimeMillis();
                double duration = (double)(endTime - startTime) * 0.001;
                Logger.info("Updated image in <" + duration + "> seconds.");
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__IMAGE, (Object)image);
            }
        }
    }

    private int getColor(double height, double minimumMeshHeight, double maximumMeshHeight) {
        double factor = 0.0;
        factor = this.isAutoScale() ? (height - minimumMeshHeight) / (maximumMeshHeight - minimumMeshHeight) : (height - this.getMinimumHeight()) / (this.getMaximumHeight() - this.getMinimumHeight());
        if (factor < 0.0) {
            factor = 0.0;
        }
        if (factor > 1.0) {
            factor = 1.0;
        }
        float hue = (float)(0.666 - factor * 0.666);
        Color color = Color.getHSBColor(hue, 0.9f, 0.9f);
        return color.getRGB();
    }
}

