/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import java.net.URL;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersFacade;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.impl.CartesianTriangularMeshURLMapLayerImpl;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianTriangularMeshURLMapLayerCustomImpl
extends CartesianTriangularMeshURLMapLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CartesianTriangularMeshURLMapLayerImpl.class);

    @Override
    public void setUrl(String newUrl) {
        super.setUrl(newUrl);
        if (ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this) != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_MAP_LAYER__MESH_IS_DIRTY, (Object)Boolean.TRUE);
        } else {
            this.setMeshIsDirty(true);
        }
    }

    @Override
    public CartesianTriangularMesh getMesh() {
        if (this.isMeshIsDirty() || this.mesh == null) {
            this.mesh = this.loadMesh(this.getUrl());
        }
        return this.mesh;
    }

    @Override
    public CartesianTriangularMesh getCurrentMesh() {
        return this.getMesh();
    }

    private CartesianTriangularMesh loadMesh(String urlString) {
        CartesianTriangularMesh loadedMesh = null;
        Logger.info("Loading Mesh from <" + this.url + "> .");
        try {
            URL url = this.resolveURLString(urlString);
            loadedMesh = (CartesianTriangularMesh)ApogyCommonConvertersFacade.INSTANCE.convert((Object)url, CartesianTriangularMesh.class);
            if (loadedMesh != null) {
                Logger.info("Sucesfully loaded Mesh from url " + url + ">. Mesh contains " + loadedMesh.getPolygons().size() + " triangles.");
            } else {
                Logger.error("Could not load Mesh from url " + url + ">. No converter found.");
            }
        }
        catch (Throwable t) {
            Logger.error("Could not load Mesh from <" + this.url + ">.", t);
            loadedMesh = null;
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_MAP_LAYER__MESH_IS_DIRTY, (Object)Boolean.FALSE);
        return loadedMesh;
    }

    private URL resolveURLString(String urlString) {
        URL url = null;
        try {
            if (urlString.startsWith("file:") || urlString.startsWith("http:")) {
                url = new URL(urlString);
            } else if (urlString.startsWith("platform")) {
                url = FileLocator.find((URL)new URL(urlString));
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return url;
    }
}

