/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.controllers.ui.composite;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.FeaturePathAdapter;
import org.eclipse.apogy.common.emf.impl.FeaturePathAdapterCustomImpl;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersFormatProviderParameters;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersUnitsProviderParameters;
import org.eclipse.apogy.common.emf.ui.preferences.PreferencesConstants;
import org.eclipse.apogy.common.io.jinput.ApogyCommonIOJInputPackage;
import org.eclipse.apogy.common.io.jinput.EComponentQualifier;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.ArgumentsList;
import org.eclipse.apogy.core.programs.controllers.ApogyCoreProgramsControllersPackage;
import org.eclipse.apogy.core.programs.controllers.BindedEDataTypeArgument;
import org.eclipse.apogy.core.programs.controllers.ControllerValueSource;
import org.eclipse.apogy.core.programs.controllers.FixedValueSource;
import org.eclipse.apogy.core.programs.controllers.OperationCallControllerBinding;
import org.eclipse.apogy.core.programs.controllers.ToggleValueSource;
import org.eclipse.apogy.core.programs.controllers.ValueSource;
import org.eclipse.apogy.core.programs.controllers.ui.composite.ConditioningComposite;
import org.eclipse.apogy.core.programs.controllers.ui.composite.ValueSourceComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.DecoratingObservableList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class BindedArgumentsListComposite
extends ScrolledComposite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private final TableViewer tableViewerArguments;
    private final Composite composite;
    private final Composite compositeValueSource;
    private final Section sectionConditioning;
    private Composite compositeConditioning;
    private OperationCallControllerBinding operationCallControllerBinding;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private List<FeaturePathAdapter> adapters;
    private IPropertyChangeListener propertyChangeListener;
    private DataBindingContext m_bindingContext;

    public BindedArgumentsListComposite(Composite parent, int style) {
        super(parent, style);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPropertyChangeListener());
        this.computeSize(1, 1);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (FeaturePathAdapter adapter : BindedArgumentsListComposite.this.getAdapters()) {
                    adapter.dispose();
                }
                BindedArgumentsListComposite.this.toolkit.dispose();
                if (BindedArgumentsListComposite.this.propertyChangeListener != null) {
                    Activator.getDefault().getPreferenceStore().removePropertyChangeListener(BindedArgumentsListComposite.this.getPropertyChangeListener());
                }
            }
        });
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayout((Layout)new GridLayout(2, true));
        Section sectionArgumentsList = this.toolkit.createSection(this.composite, 320);
        sectionArgumentsList.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        sectionArgumentsList.setLayout((Layout)new FillLayout());
        sectionArgumentsList.setText("Arguments");
        Composite compositeArguments = new Composite((Composite)sectionArgumentsList, 0);
        GridLayout gridLayout_arguments = new GridLayout(1, true);
        gridLayout_arguments.marginWidth = 0;
        gridLayout_arguments.marginHeight = 0;
        gridLayout_arguments.marginBottom = 5;
        compositeArguments.setLayout((Layout)gridLayout_arguments);
        this.tableViewerArguments = new TableViewer(compositeArguments, 68356);
        Table tableArguments = this.tableViewerArguments.getTable();
        tableArguments.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tableArguments.setLinesVisible(true);
        tableArguments.setHeaderVisible(true);
        this.tableViewerArguments.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BindedArgumentsListComposite.this.updateDetailsComposites();
                BindedArgumentsListComposite.this.newSelection(event.getSelection());
            }
        });
        TableViewerColumn tableViewerActionColumn = new TableViewerColumn(this.tableViewerArguments, 0);
        TableColumn tableclmnAction = tableViewerActionColumn.getColumn();
        tableclmnAction.setWidth(100);
        tableclmnAction.setText("Parameter");
        TableViewerColumn tableViewerValueSourceColumn = new TableViewerColumn(this.tableViewerArguments, 0);
        TableColumn tableclmnValueSource = tableViewerValueSourceColumn.getColumn();
        tableclmnValueSource.setWidth(100);
        tableclmnValueSource.setText("Value source");
        TableViewerColumn tableViewerValueColumn = new TableViewerColumn(this.tableViewerArguments, 0);
        TableColumn tableclmnValue = tableViewerValueColumn.getColumn();
        tableclmnValue.setWidth(100);
        tableclmnValue.setText("Value");
        TableViewerColumn tableViewerConditioningColumn = new TableViewerColumn(this.tableViewerArguments, 0);
        TableColumn tableclmnConditioning = tableViewerConditioningColumn.getColumn();
        tableclmnConditioning.setWidth(100);
        tableclmnConditioning.setText("Conditioning");
        sectionArgumentsList.setClient((Control)compositeArguments);
        this.compositeValueSource = new Composite(this.composite, 0);
        this.compositeValueSource.setLayout((Layout)new GridLayout(1, false));
        this.compositeValueSource.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.compositeValueSource.setBackground(Display.getCurrent().getSystemColor(1));
        this.compositeValueSource.setBackgroundMode(2);
        this.sectionConditioning = this.toolkit.createSection(this.composite, 320);
        this.sectionConditioning.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sectionConditioning.setLayout((Layout)new GridLayout(1, false));
        this.sectionConditioning.setText("Conditioning");
        this.compositeConditioning = this.getNoContentComposite((Composite)this.sectionConditioning);
        this.updateDetailsComposites();
        this.setContent((Control)this.composite);
        this.setMinSize(this.composite.computeSize(-1, -1));
        this.m_bindingContext = this.initDataBindingsCustom();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BindedArgumentsListComposite.this.m_bindingContext != null) {
                    BindedArgumentsListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    private void updateCompositeValueSource() {
        if (this.compositeValueSource != null) {
            Control[] controlArray = this.compositeValueSource.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
        }
        if (this.getSelectedArgument() != null) {
            ValueSourceComposite contentComposite = new ValueSourceComposite(this.compositeValueSource, 0){

                @Override
                protected void newSelection(ISelection selection) {
                    BindedArgumentsListComposite.this.updateCompositeConditioning();
                }
            };
            contentComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
            contentComposite.setBindedEDataTypeArgument(this.getSelectedArgument());
        } else {
            this.getNoContentComposite(this.compositeValueSource);
        }
        this.compositeValueSource.layout();
        this.layout();
    }

    private void updateCompositeConditioning() {
        if (this.compositeConditioning != null) {
            this.compositeConditioning.dispose();
        }
        if (this.getSelectedArgument() != null && this.getSelectedArgument().getValueSource() instanceof ControllerValueSource) {
            this.compositeConditioning = new ConditioningComposite((Composite)this.sectionConditioning, 16){

                @Override
                protected void newSelection(ISelection selection) {
                    BindedArgumentsListComposite.this.newSelection(selection);
                }
            };
            ((ConditioningComposite)this.compositeConditioning).setAbstractInputConditioning(((ControllerValueSource)this.getSelectedArgument().getValueSource()).getConditioning());
            if (((ControllerValueSource)this.getSelectedArgument().getValueSource()).getEComponentQualifier() != null) {
                ((ConditioningComposite)this.compositeConditioning).setEComponentQualifier(((ControllerValueSource)this.getSelectedArgument().getValueSource()).getEComponentQualifier());
            }
            this.compositeConditioning.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.compositeConditioning.setBackground(Display.getCurrent().getSystemColor(1));
        } else {
            this.compositeConditioning = this.getNoContentComposite((Composite)this.sectionConditioning);
        }
        this.sectionConditioning.setClient((Control)this.compositeConditioning);
        this.sectionConditioning.layout();
        this.layout();
    }

    private void updateDetailsComposites() {
        this.updateCompositeValueSource();
        this.updateCompositeConditioning();
    }

    private Composite getNoContentComposite(Composite parent) {
        NoContentComposite composite = new NoContentComposite(parent, 0){

            protected String getMessage() {
                return "No compatible selection";
            }
        };
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setBackground(Display.getCurrent().getSystemColor(1));
        composite.setBackgroundMode(2);
        return composite;
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("TYPED_ELEMENTS_UNITS_ID") || PreferencesConstants.isFormatPreference((String)event.getProperty())) {
                        BindedArgumentsListComposite.this.refreshViewer();
                    }
                }
            };
        }
        return this.propertyChangeListener;
    }

    protected void refreshViewer() {
        if (!this.tableViewerArguments.getTable().isDisposed() && !this.tableViewerArguments.isBusy()) {
            this.tableViewerArguments.refresh();
            TableColumn[] tableColumnArray = this.tableViewerArguments.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.pack();
                ++n2;
            }
        }
    }

    private BindedEDataTypeArgument getSelectedArgument() {
        if (!this.tableViewerArguments.getStructuredSelection().isEmpty()) {
            return (BindedEDataTypeArgument)this.tableViewerArguments.getStructuredSelection().getFirstElement();
        }
        return null;
    }

    protected void newSelection(ISelection selection) {
    }

    public void setOperationCallControllerBinding(OperationCallControllerBinding operationCallControllerBinding) {
        if (this.operationCallControllerBinding != null) {
            for (FeaturePathAdapter adapter : this.getAdapters()) {
                adapter.dispose();
            }
        }
        this.operationCallControllerBinding = operationCallControllerBinding;
        TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)operationCallControllerBinding);
        if (operationCallControllerBinding != null && operationCallControllerBinding.getArgumentsList() != null) {
            this.tableViewerArguments.setInput((Object)EMFEditProperties.list((EditingDomain)domain, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ARGUMENTS_LIST__ARGUMENTS).observe((Object)operationCallControllerBinding.getArgumentsList()));
        } else {
            this.tableViewerArguments.setInput(null);
        }
        this.refreshViewer();
        if (this.operationCallControllerBinding != null) {
            for (FeaturePathAdapter adapter : this.getAdapters()) {
                adapter.init((EObject)this.operationCallControllerBinding);
            }
        }
    }

    protected DataBindingContext initDataBindingsCustom() {
        this.m_bindingContext = new DataBindingContext();
        this.tableViewerArguments.setContentProvider((IContentProvider)new ArgumentsContentProvider((AdapterFactory)this.adapterFactory));
        this.tableViewerArguments.setLabelProvider((IBaseLabelProvider)new ArgumentsLabelProvider((AdapterFactory)this.adapterFactory));
        return this.m_bindingContext;
    }

    private List<FeaturePathAdapter> getAdapters() {
        if (this.adapters == null) {
            this.adapters = new ArrayList<FeaturePathAdapter>();
            this.adapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    BindedArgumentsListComposite.this.featurePathAdapterNotify(msg);
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> features = new ArrayList<Object>();
                    features.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__ARGUMENTS_LIST);
                    features.add(ApogyCoreInvocatorPackage.Literals.ARGUMENTS_LIST__ARGUMENTS);
                    features.add(ApogyCoreProgramsControllersPackage.Literals.BINDED_EDATA_TYPE_ARGUMENT__VALUE_SOURCE);
                    features.add(ApogyCoreInvocatorPackage.Literals.EDATA_TYPE_ARGUMENT__VALUE);
                    return features;
                }
            });
            this.adapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    BindedArgumentsListComposite.this.featurePathAdapterNotify(msg);
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<EReference> features = new ArrayList<EReference>();
                    features.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__ARGUMENTS_LIST);
                    features.add(ApogyCoreInvocatorPackage.Literals.ARGUMENTS_LIST__ARGUMENTS);
                    features.add(ApogyCoreProgramsControllersPackage.Literals.BINDED_EDATA_TYPE_ARGUMENT__VALUE_SOURCE);
                    features.add(ApogyCoreProgramsControllersPackage.Literals.CONTROLLER_VALUE_SOURCE__COMPONENT);
                    return features;
                }
            });
            this.adapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    BindedArgumentsListComposite.this.featurePathAdapterNotify(msg);
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<EReference> features = new ArrayList<EReference>();
                    features.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__ARGUMENTS_LIST);
                    features.add(ApogyCoreInvocatorPackage.Literals.ARGUMENTS_LIST__ARGUMENTS);
                    features.add(ApogyCoreProgramsControllersPackage.Literals.BINDED_EDATA_TYPE_ARGUMENT__VALUE_SOURCE);
                    features.add(ApogyCoreProgramsControllersPackage.Literals.CONTROLLER_VALUE_SOURCE__CONDITIONING);
                    return features;
                }
            });
            this.adapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    BindedArgumentsListComposite.this.featurePathAdapterNotify(msg);
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> features = new ArrayList<Object>();
                    features.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__ARGUMENTS_LIST);
                    features.add(ApogyCoreInvocatorPackage.Literals.ARGUMENTS_LIST__ARGUMENTS);
                    features.add(ApogyCoreProgramsControllersPackage.Literals.BINDED_EDATA_TYPE_ARGUMENT__VALUE_SOURCE);
                    features.add(ApogyCoreProgramsControllersPackage.Literals.CONTROLLER_VALUE_SOURCE__ECOMPONENT_QUALIFIER);
                    features.add(ApogyCommonIOJInputPackage.Literals.ECOMPONENT_QUALIFIER__ECOMPONENT_NAME);
                    return features;
                }
            });
            this.adapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    BindedArgumentsListComposite.this.featurePathAdapterNotify(msg);
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> features = new ArrayList<Object>();
                    features.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__ARGUMENTS_LIST);
                    features.add(ApogyCoreInvocatorPackage.Literals.ARGUMENTS_LIST__ARGUMENTS);
                    features.add(ApogyCoreProgramsControllersPackage.Literals.BINDED_EDATA_TYPE_ARGUMENT__VALUE_SOURCE);
                    features.add(ApogyCoreProgramsControllersPackage.Literals.CONTROLLER_VALUE_SOURCE__ECOMPONENT_QUALIFIER);
                    features.add(ApogyCommonIOJInputPackage.Literals.ECOMPONENT_QUALIFIER__ECONTROLLER_NAME);
                    return features;
                }
            });
        }
        return this.adapters;
    }

    private void featurePathAdapterNotify(Notification msg) {
        if (msg.getFeature() == ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__ARGUMENTS_LIST && msg.getNewValue() != null) {
            this.setOperationCallControllerBinding((OperationCallControllerBinding)((ArgumentsList)msg.getNewValue()).getOperationCall());
            this.composite.layout();
            this.compositeValueSource.layout();
            this.sectionConditioning.layout();
        }
        this.refreshViewer();
        this.newSelection(null);
    }

    private class ArgumentsContentProvider
    extends AdapterFactoryContentProvider {
        public ArgumentsContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            ArrayList objects = new ArrayList();
            for (Object object1 : (DecoratingObservableList)object) {
                if (!(object1 instanceof BindedEDataTypeArgument)) continue;
                objects.add(object1);
            }
            return objects.toArray();
        }

        public boolean hasChildren(Object object) {
            return false;
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            BindedArgumentsListComposite.this.refreshViewer();
        }
    }

    private class ArgumentsLabelProvider
    extends AdapterFactoryLabelProvider {
        private static final int PARAMETER_COLUMN_ID = 0;
        private static final int VALUE_SOURCE_ID = 1;
        private static final int VALUE_ID = 2;
        private static final int CONDITIONING_ID = 3;

        public ArgumentsLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String str = "<undefined>";
            if (BindedArgumentsListComposite.this.operationCallControllerBinding.getArgumentsList() == null || !BindedArgumentsListComposite.this.operationCallControllerBinding.getArgumentsList().getArguments().contains(object)) {
                return str;
            }
            ValueSource valueSource = ((BindedEDataTypeArgument)object).getValueSource();
            switch (columnIndex) {
                case 0: {
                    str = super.getColumnText(object, 0);
                    break;
                }
                case 1: {
                    if (valueSource == null) break;
                    str = valueSource.eClass().getName();
                    break;
                }
                case 2: {
                    if (valueSource instanceof FixedValueSource) {
                        Double valueDouble = 0.0;
                        str = ((FixedValueSource)valueSource).getValue();
                        try {
                            valueDouble = Double.parseDouble(str);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        EParameter param = ((FixedValueSource)valueSource).getEParameter();
                        Unit unit = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)param);
                        if (unit == null) break;
                        if (((FixedValueSource)valueSource).getValue() == null) {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)valueSource, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.EDATA_TYPE_ARGUMENT__VALUE, (Object)"0.0");
                        }
                        EOperationEParametersFormatProviderParameters formatParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersFormatProviderParameters();
                        formatParams.setParam(param);
                        EOperationEParametersUnitsProviderParameters unitsParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersUnitsProviderParameters();
                        unitsParams.setParam(param);
                        DecimalFormat format = ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat(param.getEOperation(), formatParams);
                        Unit displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(param.getEOperation(), unitsParams);
                        if (displayUnits != null && !displayUnits.equals((Object)unit)) {
                            valueDouble = unit.getConverterTo(displayUnits).convert(valueDouble.doubleValue());
                        }
                        str = String.valueOf(format.format(valueDouble)) + " " + displayUnits.toString();
                        break;
                    }
                    if (valueSource instanceof ToggleValueSource) {
                        str = "Initial : " + String.valueOf(((ToggleValueSource)valueSource).isInitialValue()) + ", Current : " + String.valueOf(((ToggleValueSource)valueSource).isCurrentValue());
                        break;
                    }
                    if (!(valueSource instanceof ControllerValueSource)) break;
                    EComponentQualifier qualifier = ((ControllerValueSource)valueSource).getEComponentQualifier();
                    str = String.valueOf(qualifier.getEControllerName()) + "." + qualifier.getEComponentName();
                    break;
                }
                case 3: {
                    if (valueSource instanceof ControllerValueSource) {
                        str = super.getColumnText((Object)((ControllerValueSource)valueSource).getConditioning(), columnIndex);
                        break;
                    }
                    str = "N/A";
                    break;
                }
            }
            return str;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            ValueSource valueSource = ((BindedEDataTypeArgument)object).getValueSource();
            switch (columnIndex) {
                case 3: {
                    if (!(valueSource instanceof ControllerValueSource)) break;
                    return super.getColumnImage((Object)((ControllerValueSource)valueSource).getConditioning(), columnIndex);
                }
            }
            return null;
        }
    }
}

