/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.rover.impl;

import org.eclipse.apogy.addons.actuators.ApogyAddonsActuatorsPackage;
import org.eclipse.apogy.addons.sensors.ApogyAddonsSensorsPackage;
import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVPackage;
import org.eclipse.apogy.addons.sensors.imaging.ApogyAddonsSensorsImagingPackage;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.geometry.data.ApogyCommonGeometryDataPackage;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DPackage;
import org.eclipse.apogy.common.images.ApogyCommonImagesPackage;
import org.eclipse.apogy.common.math.ApogyCommonMathPackage;
import org.eclipse.apogy.common.processors.ApogyCommonProcessorsPackage;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.examples.camera.ApogyExamplesCameraPackage;
import org.eclipse.apogy.examples.mobile_platform.ApogyExamplesMobilePlatformPackage;
import org.eclipse.apogy.examples.robotic_arm.ApogyExamplesRoboticArmPackage;
import org.eclipse.apogy.examples.rover.ApogyExamplesRoverFactory;
import org.eclipse.apogy.examples.rover.ApogyExamplesRoverPackage;
import org.eclipse.apogy.examples.rover.Battery;
import org.eclipse.apogy.examples.rover.PowerSystem;
import org.eclipse.apogy.examples.rover.Rover;
import org.eclipse.apogy.examples.rover.RoverSimulated;
import org.eclipse.apogy.examples.rover.RoverStub;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;

public class ApogyExamplesRoverPackageImpl
extends EPackageImpl
implements ApogyExamplesRoverPackage {
    private EClass batteryEClass = null;
    private EClass powerSystemEClass = null;
    private EClass roverEClass = null;
    private EClass roverStubEClass = null;
    private EClass roverSimulatedEClass = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    private ApogyExamplesRoverPackageImpl() {
        super("org.eclipse.apogy.examples.rover", (EFactory)ApogyExamplesRoverFactory.eINSTANCE);
    }

    public static ApogyExamplesRoverPackage init() {
        if (isInited) {
            return (ApogyExamplesRoverPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.examples.rover");
        }
        Object registeredApogyExamplesRoverPackage = EPackage.Registry.INSTANCE.get((Object)"org.eclipse.apogy.examples.rover");
        ApogyExamplesRoverPackageImpl theApogyExamplesRoverPackage = registeredApogyExamplesRoverPackage instanceof ApogyExamplesRoverPackageImpl ? (ApogyExamplesRoverPackageImpl)registeredApogyExamplesRoverPackage : new ApogyExamplesRoverPackageImpl();
        isInited = true;
        EcorePackage.eINSTANCE.eClass();
        ApogyCommonEMFPackage.eINSTANCE.eClass();
        ApogyExamplesRoboticArmPackage.eINSTANCE.eClass();
        ApogyExamplesMobilePlatformPackage.eINSTANCE.eClass();
        ApogyExamplesCameraPackage.eINSTANCE.eClass();
        ApogyAddonsSensorsImagingPackage.eINSTANCE.eClass();
        ApogyCommonTopologyPackage.eINSTANCE.eClass();
        ApogyAddonsSensorsPackage.eINSTANCE.eClass();
        ApogyAddonsSensorsFOVPackage.eINSTANCE.eClass();
        ApogyAddonsActuatorsPackage.eINSTANCE.eClass();
        ApogyCommonImagesPackage.eINSTANCE.eClass();
        ApogyCommonMathPackage.eINSTANCE.eClass();
        ApogyCommonGeometryDataPackage.eINSTANCE.eClass();
        ApogyCommonGeometryData3DPackage.eINSTANCE.eClass();
        ApogyCommonProcessorsPackage.eINSTANCE.eClass();
        theApogyExamplesRoverPackage.createPackageContents();
        theApogyExamplesRoverPackage.initializePackageContents();
        theApogyExamplesRoverPackage.freeze();
        EPackage.Registry.INSTANCE.put((Object)"org.eclipse.apogy.examples.rover", (Object)theApogyExamplesRoverPackage);
        return theApogyExamplesRoverPackage;
    }

    @Override
    public EClass getBattery() {
        return this.batteryEClass;
    }

    @Override
    public EAttribute getBattery_Active() {
        return (EAttribute)this.batteryEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getBattery_Voltage() {
        return (EAttribute)this.batteryEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getBattery_Current() {
        return (EAttribute)this.batteryEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EOperation getBattery__Activate() {
        return (EOperation)this.batteryEClass.getEOperations().get(0);
    }

    @Override
    public EOperation getBattery__Deactivate() {
        return (EOperation)this.batteryEClass.getEOperations().get(1);
    }

    @Override
    public EClass getPowerSystem() {
        return this.powerSystemEClass;
    }

    @Override
    public EReference getPowerSystem_Batteries() {
        return (EReference)this.powerSystemEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getPowerSystem_ActiveBattery() {
        return (EReference)this.powerSystemEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getPowerSystem_CurrentVoltage() {
        return (EAttribute)this.powerSystemEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getPowerSystem_CurrentCurrent() {
        return (EAttribute)this.powerSystemEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EOperation getPowerSystem__ChangeActiveBatteryTo__int() {
        return (EOperation)this.powerSystemEClass.getEOperations().get(0);
    }

    @Override
    public EClass getRover() {
        return this.roverEClass;
    }

    @Override
    public EReference getRover_IntegratedRoboticArm() {
        return (EReference)this.roverEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getRover_MobilePlatform() {
        return (EReference)this.roverEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EReference getRover_CenterCamera() {
        return (EReference)this.roverEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EReference getRover_PowerSystem() {
        return (EReference)this.roverEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EAttribute getRover_LinearVelocity() {
        return (EAttribute)this.roverEClass.getEStructuralFeatures().get(4);
    }

    @Override
    public EAttribute getRover_AngularVelocity() {
        return (EAttribute)this.roverEClass.getEStructuralFeatures().get(5);
    }

    @Override
    public EAttribute getRover_Initialized() {
        return (EAttribute)this.roverEClass.getEStructuralFeatures().get(6);
    }

    @Override
    public EAttribute getRover_Disposed() {
        return (EAttribute)this.roverEClass.getEStructuralFeatures().get(7);
    }

    @Override
    public EOperation getRover__Init() {
        return (EOperation)this.roverEClass.getEOperations().get(0);
    }

    @Override
    public EOperation getRover__CmdChangeName__String() {
        return (EOperation)this.roverEClass.getEOperations().get(1);
    }

    @Override
    public EOperation getRover__CmdLinearVelocity__double() {
        return (EOperation)this.roverEClass.getEOperations().get(2);
    }

    @Override
    public EOperation getRover__CmdAngularVelocity__double() {
        return (EOperation)this.roverEClass.getEOperations().get(3);
    }

    @Override
    public EOperation getRover__CmdVelocities__double_double() {
        return (EOperation)this.roverEClass.getEOperations().get(4);
    }

    @Override
    public EClass getRoverStub() {
        return this.roverStubEClass;
    }

    @Override
    public EClass getRoverSimulated() {
        return this.roverSimulatedEClass;
    }

    @Override
    public ApogyExamplesRoverFactory getApogyExamplesRoverFactory() {
        return (ApogyExamplesRoverFactory)this.getEFactoryInstance();
    }

    public void createPackageContents() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.batteryEClass = this.createEClass(0);
        this.createEAttribute(this.batteryEClass, 0);
        this.createEAttribute(this.batteryEClass, 1);
        this.createEAttribute(this.batteryEClass, 2);
        this.createEOperation(this.batteryEClass, 0);
        this.createEOperation(this.batteryEClass, 1);
        this.powerSystemEClass = this.createEClass(1);
        this.createEReference(this.powerSystemEClass, 0);
        this.createEReference(this.powerSystemEClass, 1);
        this.createEAttribute(this.powerSystemEClass, 2);
        this.createEAttribute(this.powerSystemEClass, 3);
        this.createEOperation(this.powerSystemEClass, 0);
        this.roverEClass = this.createEClass(2);
        this.createEReference(this.roverEClass, 1);
        this.createEReference(this.roverEClass, 2);
        this.createEReference(this.roverEClass, 3);
        this.createEReference(this.roverEClass, 4);
        this.createEAttribute(this.roverEClass, 5);
        this.createEAttribute(this.roverEClass, 6);
        this.createEAttribute(this.roverEClass, 7);
        this.createEAttribute(this.roverEClass, 8);
        this.createEOperation(this.roverEClass, 1);
        this.createEOperation(this.roverEClass, 2);
        this.createEOperation(this.roverEClass, 3);
        this.createEOperation(this.roverEClass, 4);
        this.createEOperation(this.roverEClass, 5);
        this.roverStubEClass = this.createEClass(3);
        this.roverSimulatedEClass = this.createEClass(4);
    }

    public void initializePackageContents() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setName("rover");
        this.setNsPrefix("rover");
        this.setNsURI("org.eclipse.apogy.examples.rover");
        EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        ApogyCommonEMFPackage theApogyCommonEMFPackage = (ApogyCommonEMFPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.emf");
        ApogyExamplesRoboticArmPackage theApogyExamplesRoboticArmPackage = (ApogyExamplesRoboticArmPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.examples.robotic_arm");
        ApogyExamplesMobilePlatformPackage theApogyExamplesMobilePlatformPackage = (ApogyExamplesMobilePlatformPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.examples.mobile_platform");
        ApogyExamplesCameraPackage theApogyExamplesCameraPackage = (ApogyExamplesCameraPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.examples.camera");
        this.roverEClass.getESuperTypes().add((Object)theApogyCommonEMFPackage.getDisposable());
        this.roverEClass.getESuperTypes().add((Object)theApogyCommonEMFPackage.getNamed());
        this.roverStubEClass.getESuperTypes().add((Object)this.getRover());
        this.roverSimulatedEClass.getESuperTypes().add((Object)this.getRover());
        this.initEClass(this.batteryEClass, Battery.class, "Battery", false, false, true);
        this.initEAttribute(this.getBattery_Active(), (EClassifier)theEcorePackage.getEBoolean(), "active", null, 0, 1, Battery.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getBattery_Voltage(), (EClassifier)theEcorePackage.getEDouble(), "voltage", "0.0", 0, 1, Battery.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getBattery_Current(), (EClassifier)theEcorePackage.getEDouble(), "current", "0.0", 0, 1, Battery.class, false, false, true, false, false, false, false, true);
        this.initEOperation(this.getBattery__Activate(), null, "activate", 0, 1, false, true);
        this.initEOperation(this.getBattery__Deactivate(), null, "deactivate", 0, 1, false, true);
        this.initEClass(this.powerSystemEClass, PowerSystem.class, "PowerSystem", false, false, true);
        this.initEReference(this.getPowerSystem_Batteries(), (EClassifier)this.getBattery(), null, "batteries", null, 1, -1, PowerSystem.class, false, false, true, true, false, false, true, false, true);
        this.initEReference(this.getPowerSystem_ActiveBattery(), (EClassifier)this.getBattery(), null, "activeBattery", null, 1, 1, PowerSystem.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getPowerSystem_CurrentVoltage(), (EClassifier)theEcorePackage.getEDouble(), "currentVoltage", null, 0, 1, PowerSystem.class, true, true, false, false, false, false, true, true);
        this.initEAttribute(this.getPowerSystem_CurrentCurrent(), (EClassifier)theEcorePackage.getEDouble(), "currentCurrent", null, 0, 1, PowerSystem.class, true, true, false, false, false, false, true, true);
        EOperation op = this.initEOperation(this.getPowerSystem__ChangeActiveBatteryTo__int(), null, "changeActiveBatteryTo", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEInt(), "batteryIndex", 0, 1, false, true);
        this.initEClass(this.roverEClass, Rover.class, "Rover", true, false, true);
        this.initEReference(this.getRover_IntegratedRoboticArm(), (EClassifier)theApogyExamplesRoboticArmPackage.getIntegratedRoboticArm(), null, "integratedRoboticArm", null, 1, 1, Rover.class, true, false, true, false, true, false, true, false, true);
        this.initEReference(this.getRover_MobilePlatform(), (EClassifier)theApogyExamplesMobilePlatformPackage.getMobilePlatform(), null, "mobilePlatform", null, 1, 1, Rover.class, true, false, true, false, true, false, true, false, true);
        this.initEReference(this.getRover_CenterCamera(), (EClassifier)theApogyExamplesCameraPackage.getPTUCamera(), null, "centerCamera", null, 1, 1, Rover.class, true, false, true, false, true, false, true, false, true);
        this.initEReference(this.getRover_PowerSystem(), (EClassifier)this.getPowerSystem(), null, "powerSystem", null, 1, 1, Rover.class, false, false, true, true, false, false, true, false, true);
        this.initEAttribute(this.getRover_LinearVelocity(), (EClassifier)theEcorePackage.getEDouble(), "linearVelocity", null, 0, 1, Rover.class, true, true, false, false, false, false, true, true);
        this.initEAttribute(this.getRover_AngularVelocity(), (EClassifier)theEcorePackage.getEDouble(), "angularVelocity", null, 0, 1, Rover.class, true, true, false, false, false, false, true, true);
        this.initEAttribute(this.getRover_Initialized(), (EClassifier)theEcorePackage.getEBoolean(), "initialized", "false", 0, 1, Rover.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getRover_Disposed(), (EClassifier)theEcorePackage.getEBoolean(), "disposed", "false", 0, 1, Rover.class, false, false, true, false, false, false, false, true);
        this.initEOperation(this.getRover__Init(), (EClassifier)theEcorePackage.getEBoolean(), "init", 0, 1, false, true);
        op = this.initEOperation(this.getRover__CmdChangeName__String(), null, "cmdChangeName", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEString(), "name", 0, 1, false, true);
        op = this.initEOperation(this.getRover__CmdLinearVelocity__double(), null, "cmdLinearVelocity", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "linearVelocity", 0, 1, false, true);
        op = this.initEOperation(this.getRover__CmdAngularVelocity__double(), null, "cmdAngularVelocity", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "angularVelocity", 0, 1, false, true);
        op = this.initEOperation(this.getRover__CmdVelocities__double_double(), null, "cmdVelocities", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "linearVelocity", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "angularVelocity", 0, 1, false, true);
        this.initEClass(this.roverStubEClass, RoverStub.class, "RoverStub", false, false, true);
        this.initEClass(this.roverSimulatedEClass, RoverSimulated.class, "RoverSimulated", false, false, true);
        this.createResource("org.eclipse.apogy.examples.rover");
        this.createGenModelAnnotations();
        this.createApogyAnnotations();
    }

    protected void createGenModelAnnotations() {
        String source = "http://www.eclipse.org/emf/2002/GenModel";
        this.addAnnotation((ENamedElement)this, source, new String[]{"prefix", "ApogyExamplesRover", "copyrightText", "*******************************************************************************\nCopyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency \nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n\nContributors:\n     Pierre Allard - initial API and implementation\n     Regent L'Archeveque\n        \nSPDX-License-Identifier: EPL-1.0    \n*******************************************************************************", "modelName", "ApogyExamplesRover", "childCreationExtenders", "true", "extensibleProviderFactory", "true", "suppressGenModelAnnotations", "false", "dynamicTemplates", "true", "templateDirectory", "platform:/plugin/org.eclipse.apogy.common.emf.codegen/templates", "modelDirectory", "/org.eclipse.apogy.examples.rover/src-gen", "editDirectory", "/org.eclipse.apogy.examples.rover.edit/src-gen", "basePackage", "org.eclipse.apogy.examples"});
        this.addAnnotation((ENamedElement)this.batteryEClass, source, new String[]{"documentation", "*\nThis class represents a battery in the rover's\npower system; note that the rover's power supply\nis comprised of several battery."});
        this.addAnnotation((ENamedElement)this.getBattery__Activate(), source, new String[]{"documentation", "*\nThis is used to activate this battery, changing\nthe voltage and current that it outputs from zero."});
        this.addAnnotation((ENamedElement)this.getBattery__Deactivate(), source, new String[]{"documentation", "*\nThis is used to deactivate this battery, changing\nthe voltage and current that it outputs to zero."});
        this.addAnnotation((ENamedElement)this.getBattery_Active(), source, new String[]{"documentation", "*\nThis is whether or not the battery is active", "notify", "true", "children", "false", "property", "Readonly"});
        this.addAnnotation((ENamedElement)this.getBattery_Voltage(), source, new String[]{"documentation", "*\nThis is the voltage output by the battery,\nas measured in volts; initially, zero", "notify", "true", "property", "Readonly"});
        this.addAnnotation((ENamedElement)this.getBattery_Current(), source, new String[]{"documentation", "*\nThis is the current output by the battery,\nas measured in amps; initially, zero", "notify", "true", "property", "Readonly"});
        this.addAnnotation((ENamedElement)this.powerSystemEClass, source, new String[]{"documentation", "This is the rover's internal power system, which is\nused to return the"});
        this.addAnnotation((ENamedElement)this.getPowerSystem__ChangeActiveBatteryTo__int(), source, new String[]{"documentation", "*\nThis is used to change the active battery to\nthe battery located at the given index in the\nlist (or array) of batteries.\n@param batteryIndex The index of the battery to change to"});
        this.addAnnotation((ENamedElement)this.getPowerSystem_Batteries(), source, new String[]{"documentation", "*\nThis is the array of batteries comprising the\npower system.", "notify", "true", "createChild", "false"});
        this.addAnnotation((ENamedElement)this.getPowerSystem_ActiveBattery(), source, new String[]{"documentation", "*\nThis is the currently active battery", "notify", "true"});
        this.addAnnotation((ENamedElement)this.getPowerSystem_CurrentVoltage(), source, new String[]{"documentation", "*\nThis is used to get the voltage that the power system\nis currently outputting.", "notify", "true", "get", "<%org.eclipse.apogy.examples.rover.Battery%> _activeBattery = this.getActiveBattery();\nboolean _tripleNotEquals = (_activeBattery != null);\nif (_tripleNotEquals)\n{\n\treturn this.getActiveBattery().getVoltage();\n}\nelse\n{\n\treturn 0.0;\n}"});
        this.addAnnotation((ENamedElement)this.getPowerSystem_CurrentCurrent(), source, new String[]{"documentation", "*\nThis is used to get the current that the power system\nis currently outputting.", "notify", "true", "get", "<%org.eclipse.apogy.examples.rover.Battery%> _activeBattery = this.getActiveBattery();\nboolean _tripleNotEquals = (_activeBattery != null);\nif (_tripleNotEquals)\n{\n\treturn this.getActiveBattery().getCurrent();\n}\nelse\n{\n\treturn 0.0;\n}"});
        this.addAnnotation((ENamedElement)this.roverEClass, source, new String[]{"documentation", "*\nThis abstract class represents a rover assembly, including\nits relevant state (e.g. component parts) as well as the\noperations that it can perform."});
        this.addAnnotation((ENamedElement)this.getRover__Init(), source, new String[]{"documentation", "*\nThis operation is used to perform the required initialization functions\non the rover assembly; this may involve bootstrapping the components\nof the rover (e.g. mobile platform, cameras, etc.)\n@return Whether or not the rover assembly was successfully initialized"});
        this.addAnnotation((ENamedElement)this.getRover__CmdChangeName__String(), source, new String[]{"documentation", "*\nThis operation is used to change the name of the rover.\n@param name New name."});
        this.addAnnotation((ENamedElement)this.getRover__CmdLinearVelocity__double(), source, new String[]{"documentation", "*\nThis operation is used to change the linear velocity of the rover\nassembly to the provided value (given in m/s); internally, this is\nlikely to cause a change to the mobile platform, as it is this component\nwhich actually moves the rover.\n<p>\nNote: Unlike the traditional definition of linear velocity as a vector,\nthis is simply a signed scalar; a positive value indicates the speed\nforward while a negative value is the speed backwards.  Zero means there\nis no movement.\n\n@param linearVelocity The rover assembly's new linear velocity (in m/s)\n@see #cmdVelocities(double, double)"});
        this.addAnnotation((ENamedElement)this.getRover__CmdAngularVelocity__double(), source, new String[]{"documentation", "*\nThis operation is used to change the angular velocity of the rover\nassembly to the provided value (given in radians / second); internally,\nthis is likely to cause a change to the mobile platform, as it is this\ncomponent which actually moves the rover.\n<p>\nNote: Unlike the traditional definition of angular velocity as a vector,\nthis is simply a signed scalar; a positive value is the rotation in the\nclockwise direction while a negative value implies the rotation is in the\ncounter-clockwise direction.  Zero means there is no rotation.\n\n@param angularVelocity The rover assembly's new angular velocity (in rad/s)\n@see #cmdVelocities(double, double)"});
        this.addAnnotation((ENamedElement)this.getRover__CmdVelocities__double_double(), source, new String[]{"documentation", "*\nThis operation is used to change both the linear velocity (given in m/s)\nand angular velocity (given in rad/s) of the rover assembly to the\nprovided values; internally, this is likely to cause a change to the\nmobile platform, as it is this component which actually moves the rover.\n<p>\nNote 1: Unlike the traditional definition of linear velocity as a vector,\nthis is simply a signed scalar; a positive value indicates the speed\nforward while a negative value is the speed backwards.  Zero means there\nis no movement.\n<p>\nNote 2: Unlike the traditional definition of angular velocity as a vector,\nthis is simply a signed scalar; a positive value is the rotation in the\nclockwise direction while a negative value implies the rotation is in the\ncounter-clockwise direction.  Zero means there is no rotation.\n\n@param linearVelocity The rover assembly's new linear velocity (in m/s)\n@param angularVelocity The rover assembly's new angular velocity (in rad/s)\n@see #cmdLinearVelocity(double)\n@see #cmdAngularVelocity(double)"});
        this.addAnnotation((ENamedElement)this.getRover_IntegratedRoboticArm(), source, new String[]{"documentation", "*\nA robotic arm used by the rover assembly to interact\nwith the environment.", "notify", "true", "propertyCategory", "Subcomponents", "children", "true"});
        this.addAnnotation((ENamedElement)this.getRover_MobilePlatform(), source, new String[]{"documentation", "*\nA mobile platform used by the rover assembly to move\naround the environment", "notify", "true", "propertyCategory", "Subcomponents", "children", "true"});
        this.addAnnotation((ENamedElement)this.getRover_CenterCamera(), source, new String[]{"documentation", " *\nA camera mounted on the center of the rover mast assembly to\ntake pictures of the environment; from those photos,\nadditional visual information may be extracted.", "notify", "true", "propertyCategory", "Subcomponents", "children", "true"});
        this.addAnnotation((ENamedElement)this.getRover_PowerSystem(), source, new String[]{"documentation", "*\nA power system which is used to power the Rover.", "notify", "true", "propertyCategory", "Subcomponents"});
        this.addAnnotation((ENamedElement)this.getRover_LinearVelocity(), source, new String[]{"documentation", "*\nThis is the linear velocity of the rover (given in\nmetres per second.)\n<p>\nNote: Unlike the traditional definition of linear velocity\nas a vector, this is simply a signed scalar; a positive\nvalue indicates the speed forward while a negative value\nis the speed backwards.  Zero means there is no movement.", "children", "false", "notify", "true", "property", "Readonly", "propertyCategory", "Velocities", "get", "<%org.eclipse.apogy.examples.mobile_platform.MobilePlatform%> _mobilePlatform = this.getMobilePlatform();\nboolean _tripleNotEquals = (_mobilePlatform != null);\nif (_tripleNotEquals)\n{\n\treturn this.getMobilePlatform().getLinearVelocity();\n}\nelse\n{\n\treturn 0.0;\n}"});
        this.addAnnotation((ENamedElement)this.getRover_AngularVelocity(), source, new String[]{"documentation", "*\nThis is the angular velocity of the rover (given in\nradians per second.)\n<p>\nNote: Unlike the traditional definition of angular\nvelocity as a vector, this is simply a signed scalar;\na positive value is the rotation in the clockwise\ndirection while a negative value implies the rotation\nis in the counter-clockwise direction.  Zero means\nthere is no rotation.", "children", "false", "notify", "true", "property", "Readonly", "propertyCategory", "Velocities", "get", "<%org.eclipse.apogy.examples.mobile_platform.MobilePlatform%> _mobilePlatform = this.getMobilePlatform();\nboolean _tripleNotEquals = (_mobilePlatform != null);\nif (_tripleNotEquals)\n{\n\treturn this.getMobilePlatform().getAngularVelocity();\n}\nelse\n{\n\treturn 0.0;\n}"});
        this.addAnnotation((ENamedElement)this.getRover_Initialized(), source, new String[]{"documentation", "*\nThis is whether or not the rover has been initialized\nsuccessfully; initially false.\n@see #init()", "children", "false", "notify", "true", "property", "Readonly", "propertyCategory", "Status"});
        this.addAnnotation((ENamedElement)this.getRover_Disposed(), source, new String[]{"documentation", "*\nThis is whether or not the rover has been disposed\nsuccessfully; initially false.\n@see #dispose()", "children", "false", "notify", "true", "property", "Readonly", "propertyCategory", "Status"});
        this.addAnnotation((ENamedElement)this.roverStubEClass, source, new String[]{"documentation", "*\nThis is a specific implementation of the rover, in which all operations\nare stubs and hence, non-functional; the operations should simply log a\nmessage, indicating that they were performed."});
        this.addAnnotation((ENamedElement)this.roverSimulatedEClass, source, new String[]{"documentation", "*\nThis is a simulated implementation of the rover, where all operations\nare executed upon a simulated (i.e. virtual) rover. While there are no\nphysical components interacted with, it attempts to emulate, wherever\npossible, the actions and results of its real world counterpart(s)."});
    }

    protected void createApogyAnnotations() {
        String source = "http://www.eclipse.org/apogy";
        this.addAnnotation((ENamedElement)this.batteryEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.getBattery_Voltage(), source, new String[]{"units", "V"});
        this.addAnnotation((ENamedElement)this.getBattery_Current(), source, new String[]{"units", "V"});
        this.addAnnotation((ENamedElement)this.powerSystemEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.getPowerSystem_CurrentVoltage(), source, new String[]{"units", "V"});
        this.addAnnotation((ENamedElement)this.getPowerSystem_CurrentCurrent(), source, new String[]{"units", "A"});
        this.addAnnotation((ENamedElement)this.roverEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.getRover__CmdLinearVelocity__double().getEParameters().get(0), source, new String[]{"units", "m/s"});
        this.addAnnotation((ENamedElement)this.getRover__CmdAngularVelocity__double().getEParameters().get(0), source, new String[]{"units", "rad/s"});
        this.addAnnotation((ENamedElement)this.getRover__CmdVelocities__double_double().getEParameters().get(0), source, new String[]{"units", "m/s"});
        this.addAnnotation((ENamedElement)this.getRover__CmdVelocities__double_double().getEParameters().get(1), source, new String[]{"units", "rad/s"});
        this.addAnnotation((ENamedElement)this.getRover_LinearVelocity(), source, new String[]{"units", "m/s"});
        this.addAnnotation((ENamedElement)this.getRover_AngularVelocity(), source, new String[]{"units", "rad/s"});
        this.addAnnotation((ENamedElement)this.roverStubEClass, source, new String[]{"hasCustomClass", "true", "hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.roverSimulatedEClass, source, new String[]{"hasCustomClass", "true", "hasCustomItemProvider", "true"});
    }
}

