/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.eclipse.apogy.addons.sensors.imaging.AzimuthDirection;
import org.eclipse.apogy.addons.sensors.imaging.ElevationDirection;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.impl.ImagingUtilitiesImpl;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;

public class ImagingUtilitiesCustomImpl
extends ImagingUtilitiesImpl {
    @Override
    public double linearConvertToHorizontalAngle(ImageSnapshot imageSnapshot, int horizontalPixelPosition) {
        double hCenter = (double)imageSnapshot.getImage().getWidth() / 2.0;
        double ratio = (hCenter - (double)horizontalPixelPosition) / (double)imageSnapshot.getImage().getWidth();
        double angle = ratio * imageSnapshot.getFieldOfView().getHorizontalFieldOfViewAngle();
        return angle;
    }

    @Override
    public double linearConvertToVerticalAngle(ImageSnapshot imageSnapshot, int verticalPixelPosition) {
        double vCenter = (double)imageSnapshot.getImage().getHeight() / 2.0;
        double ratio = (vCenter - (double)verticalPixelPosition) / (double)imageSnapshot.getImage().getHeight();
        double angle = ratio * imageSnapshot.getFieldOfView().getVerticalFieldOfViewAngle();
        return angle;
    }

    @Override
    public AbstractEImage getAzimuthElevationOverlay(int imageWidth, int imageHeight, double panAngle, double tiltAngle, double horizontalFOVAngle, double verticalFOVAngle, AzimuthDirection azimuthDirection, ElevationDirection elevationDirection, int angleInterval, String fontName, int fontSize, Color positiveColor, Color negativeColor, int lineWidth) {
        int elevationZero;
        AbstractEImage abstractImage = EImagesUtilities.INSTANCE.createTransparentImage(imageWidth, imageHeight);
        BufferedImage image = abstractImage.asBufferedImage();
        Graphics2D g2d = image.createGraphics();
        Font font = new Font(fontName, 1, fontSize);
        g2d.setFont(font);
        g2d.setStroke(new BasicStroke(lineWidth));
        g2d.setColor(positiveColor);
        int centerX = (int)Math.round((double)imageWidth / 2.0);
        int centerY = (int)Math.round((double)imageHeight / 2.0);
        double leftSideAzimuth = 0.0;
        double rightSideAzimuth = 0.0;
        if (azimuthDirection == AzimuthDirection.POSITIVE_TOWARD_LEFT) {
            leftSideAzimuth = panAngle + horizontalFOVAngle / 2.0;
            rightSideAzimuth = panAngle - horizontalFOVAngle / 2.0;
        } else {
            leftSideAzimuth = panAngle - horizontalFOVAngle / 2.0;
            rightSideAzimuth = panAngle + horizontalFOVAngle / 2.0;
        }
        double topSideElevation = 0.0;
        double bottomSideElevation = 0.0;
        if (elevationDirection == ElevationDirection.POSITIVE_UP) {
            topSideElevation = tiltAngle + verticalFOVAngle / 2.0;
            bottomSideElevation = tiltAngle - verticalFOVAngle / 2.0;
        } else {
            topSideElevation = tiltAngle - verticalFOVAngle / 2.0;
            bottomSideElevation = tiltAngle + verticalFOVAngle / 2.0;
        }
        double pixelPerAzimuthDegree = (double)imageWidth / horizontalFOVAngle;
        double pixelPerElevationDegree = (double)imageHeight / verticalFOVAngle;
        int leftMostAngle = (int)Math.round(leftSideAzimuth);
        double azimuth = leftMostAngle;
        boolean done = false;
        while (!done) {
            if (azimuth >= 0.0) {
                g2d.setColor(positiveColor);
            } else {
                g2d.setColor(negativeColor);
            }
            int x = 0;
            x = azimuthDirection == AzimuthDirection.POSITIVE_TOWARD_LEFT ? (int)Math.round((leftSideAzimuth - azimuth) * pixelPerAzimuthDegree) : (int)Math.round((azimuth - leftSideAzimuth) * pixelPerAzimuthDegree);
            if (Math.IEEEremainder(azimuth, angleInterval) == 0.0) {
                String text = Double.toString(azimuth);
                FontMetrics fontMetrics = g2d.getFontMetrics(font);
                Rectangle2D textArea = fontMetrics.getStringBounds(text, g2d);
                int xOffset = Math.round((float)textArea.getWidth() / 2.0f);
                g2d.drawLine(x, centerY - 10, x, centerY + 10);
                g2d.drawString(text, x - xOffset, centerY + 10 + (int)textArea.getHeight());
            } else {
                g2d.drawLine(x, centerY - 5, x, centerY + 5);
            }
            if (azimuthDirection == AzimuthDirection.POSITIVE_TOWARD_LEFT) {
                done = (azimuth -= 1.0) <= rightSideAzimuth;
                continue;
            }
            boolean bl = done = (azimuth += 1.0) >= rightSideAzimuth;
        }
        int azimuthZero = -1;
        if (leftSideAzimuth >= 0.0) {
            if (rightSideAzimuth >= 0.0) {
                g2d.setColor(positiveColor);
                g2d.drawLine(0, centerY, imageWidth, centerY);
            } else {
                azimuthZero = (int)(pixelPerAzimuthDegree * leftSideAzimuth);
                g2d.setColor(positiveColor);
                g2d.drawLine(0, centerY, azimuthZero, centerY);
                g2d.setColor(negativeColor);
                g2d.drawLine(azimuthZero, centerY, imageWidth, centerY);
            }
        } else if (rightSideAzimuth <= 0.0) {
            g2d.setColor(negativeColor);
            g2d.drawLine(0, centerY, imageWidth, centerY);
        } else {
            azimuthZero = (int)Math.abs(pixelPerAzimuthDegree * leftSideAzimuth);
            g2d.setColor(negativeColor);
            g2d.drawLine(0, centerY, azimuthZero, centerY);
            g2d.setColor(positiveColor);
            g2d.drawLine(azimuthZero, centerY, imageWidth, centerY);
        }
        int topMostAngle = (int)Math.round(topSideElevation);
        double elevation = topMostAngle;
        done = false;
        while (!done) {
            if (elevation >= 0.0) {
                g2d.setColor(positiveColor);
            } else {
                g2d.setColor(negativeColor);
            }
            int y = 0;
            y = elevationDirection == ElevationDirection.POSITIVE_UP ? (int)Math.round((topSideElevation - elevation) * pixelPerElevationDegree) : (int)Math.round((elevation - topSideElevation) * pixelPerElevationDegree);
            if (Math.IEEEremainder(elevation, angleInterval) == 0.0) {
                String text = Double.toString(elevation);
                FontMetrics fontMetrics = g2d.getFontMetrics(font);
                Rectangle2D textArea = fontMetrics.getStringBounds(text, g2d);
                int xOffset = (int)textArea.getWidth() + 14;
                int yOffset = (int)(textArea.getHeight() / 2.0);
                g2d.drawLine(centerX - 10, y, centerX + 10, y);
                g2d.drawString(text, centerX - xOffset, y + yOffset);
            } else {
                g2d.drawLine(centerX - 5, y, centerX + 5, y);
            }
            if (elevationDirection == ElevationDirection.POSITIVE_UP) {
                done = (elevation -= 1.0) <= bottomSideElevation;
                continue;
            }
            boolean bl = done = (elevation += 1.0) >= bottomSideElevation;
        }
        if (topSideElevation >= 0.0) {
            if (bottomSideElevation >= 0.0) {
                g2d.setColor(positiveColor);
                g2d.drawLine(centerX, 0, centerX, imageHeight);
            } else {
                elevationZero = (int)Math.round(pixelPerElevationDegree * topSideElevation);
                g2d.setColor(positiveColor);
                g2d.drawLine(centerX, 0, centerX, elevationZero);
                g2d.setColor(negativeColor);
                g2d.drawLine(centerX, elevationZero, centerX, imageHeight);
            }
        } else if (bottomSideElevation >= 0.0) {
            elevationZero = (int)Math.abs(pixelPerElevationDegree * topSideElevation);
            g2d.setColor(negativeColor);
            g2d.drawLine(centerX, 0, centerX, elevationZero);
            g2d.setColor(positiveColor);
            g2d.drawLine(centerX, elevationZero, centerX, imageHeight);
        } else {
            g2d.setColor(negativeColor);
            g2d.drawLine(centerX, 0, centerX, imageHeight);
        }
        EImage result = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        result.setImageContent(image);
        g2d.dispose();
        return result;
    }
}

