/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.apogy.addons.telecoms.ApogyAddonsTelecomsPackage;
import org.eclipse.apogy.addons.telecoms.TelecomNode;
import org.eclipse.apogy.addons.telecoms.impl.TelecomStatusMonitorToolImpl;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TelecomStatusMonitorToolCustomImpl
extends TelecomStatusMonitorToolImpl {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").indexOf("Windows") != -1;
    private final List<TelecomNodeJob> nodeJobs = new ArrayList<TelecomNodeJob>();
    Adapter nodeListener = new TelecomStatusMonitorChangeListener();

    protected TelecomStatusMonitorToolCustomImpl() {
        this.eAdapters().add((Object)this.nodeListener);
    }

    @Override
    public void start() {
        if (!this.isDisposed() && !this.isRunning()) {
            this.setRunning(true);
            for (TelecomNode node : this.telecomNodes) {
                TelecomNodeJob nodeJob = new TelecomNodeJob(node);
                nodeJob.schedule();
                this.nodeJobs.add(nodeJob);
            }
        }
    }

    @Override
    public void stop() {
        if (!this.isDisposed() && this.isRunning()) {
            for (TelecomNodeJob nodeJob : this.nodeJobs) {
                nodeJob.cancel();
            }
            this.nodeJobs.clear();
            this.setRunning(false);
        }
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            if (this.isRunning()) {
                this.stop();
            }
            this.eAdapters().remove((Object)this.nodeListener);
            this.setDisposed(true);
        }
    }

    private class TelecomNodeJob
    extends Job {
        private static final int SLEEP_DURATION = 500;
        private static final int TIMEOUT_OFFSET = 30;
        private static final String PACKET_LINE_ERROR_STR = "errors";
        private final TelecomNode node;

        public TelecomNodeJob(TelecomNode telecomNode) {
            super("Job for NetworkNode " + telecomNode.getName());
            this.node = telecomNode;
            this.setSystem(true);
        }

        public TelecomNode getTelecomNode() {
            return this.node;
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!monitor.isCanceled() && this.node.getStatusMonitorTool().isRunning()) {
                if (this.node.isEnabled()) {
                    ProcessBuilder pingPB = null;
                    if (IS_WINDOWS) {
                        pingPB = new ProcessBuilder("ping", "-n", Integer.toString(this.node.getPacketsToSend()), "-w", Double.toString(this.node.getConnectionTimeout()), this.node.getAddress());
                    } else {
                        double timeoutInSec = (double)this.node.getConnectionTimeout() / 1000.0;
                        pingPB = new ProcessBuilder("ping", "-c", Integer.toString(this.node.getPacketsToSend()), "-W", Double.toString(timeoutInSec), this.node.getAddress());
                    }
                    try {
                        long waitForTimeout = this.node.getPacketsToSend() * this.node.getConnectionTimeout() + 30;
                        Process pingProcess = pingPB.start();
                        boolean finished = pingProcess.waitFor(waitForTimeout, TimeUnit.MILLISECONDS);
                        if (finished) {
                            this.extractValuesFromPingOutput(pingProcess);
                        } else {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.node, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__LATENCY, (Object)new Double(0.0), true);
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.node, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__PACKET_LOSS, (Object)new Double(100.0), true);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        break;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        break;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return Status.OK_STATUS;
        }

        private void extractValuesFromPingOutput(Process proc) {
            block23: {
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        String line = null;
                        boolean startStatLineFound = false;
                        boolean packetStatLineFound = false;
                        boolean latencyStatLineFound = false;
                        if (IS_WINDOWS) {
                            Pattern statLine = Pattern.compile("^Ping statistics for .+:$");
                            Pattern packetLine = Pattern.compile("^Packets: Sent = .+, Received = .+, Lost = .+ \\(.+% loss\\),$");
                            Pattern latencyLine = Pattern.compile("^Minimum = .+ms, Maximum = .+ms, Average = .+ms$");
                            while ((line = br.readLine()) != null) {
                                if (statLine.matcher(line = line.trim()).matches()) {
                                    startStatLineFound = true;
                                    continue;
                                }
                                if (!startStatLineFound) continue;
                                if (!packetStatLineFound) {
                                    if (!packetLine.matcher(line).matches()) continue;
                                    packetStatLineFound = true;
                                    String[] packetStats = line.split(",");
                                    packetStats = packetStats[2].split("\\(");
                                    packetStats = packetStats[1].split("%");
                                    String packetLossVal = packetStats[0];
                                    packetLossVal = packetLossVal.trim();
                                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.node, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__PACKET_LOSS, (Object)Double.parseDouble(packetLossVal), true);
                                    continue;
                                }
                                if (latencyStatLineFound || !latencyLine.matcher(line).matches()) continue;
                                latencyStatLineFound = true;
                                String[] latencyStats = line.split(",");
                                latencyStats = latencyStats[2].split("=");
                                String averageLatency = latencyStats[1].trim();
                                averageLatency = averageLatency.substring(0, averageLatency.length() - 2);
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.node, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__LATENCY, (Object)Double.parseDouble(averageLatency), true);
                            }
                        } else {
                            Pattern statLine = Pattern.compile("^--- .+ ping statistics ---$");
                            Pattern packetLine = Pattern.compile("^.+ packets transmitted, .+ received, .+% packet loss, time .+ms$");
                            Pattern latencyLine = Pattern.compile("^rtt min/avg/max/mdev = .+/.+/.+/.+ ms$");
                            while ((line = br.readLine()) != null) {
                                if (statLine.matcher(line = line.trim()).matches()) {
                                    startStatLineFound = true;
                                    continue;
                                }
                                if (!startStatLineFound) continue;
                                if (!packetStatLineFound) {
                                    if (!packetLine.matcher(line).matches()) continue;
                                    packetStatLineFound = true;
                                    String[] packetStats = line.split(",");
                                    int packetLossStatIndex = 2;
                                    if (line.contains(PACKET_LINE_ERROR_STR)) {
                                        packetLossStatIndex = 3;
                                    }
                                    String packetLossStat = packetStats[packetLossStatIndex].trim();
                                    String packetLossVal = packetLossStat.split("%")[0];
                                    packetLossVal = packetLossVal.trim();
                                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.node, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__PACKET_LOSS, (Object)Double.parseDouble(packetLossVal), true);
                                    continue;
                                }
                                if (latencyStatLineFound || !latencyLine.matcher(line).matches()) continue;
                                latencyStatLineFound = true;
                                String[] latencyStats = line.split("=");
                                latencyStats = latencyStats[1].split("/");
                                String averageLatency = latencyStats[1];
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.node, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__LATENCY, (Object)Double.parseDouble(averageLatency), true);
                            }
                        }
                        if (!packetStatLineFound) {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.node, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__PACKET_LOSS, (Object)0.0, true);
                        }
                        if (!latencyStatLineFound) {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.node, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__LATENCY, (Object)0.0, true);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        if (br == null) break block23;
                        try {
                            br.close();
                            br = null;
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                            br = null;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private class TelecomStatusMonitorChangeListener
    extends AdapterImpl {
        private TelecomStatusMonitorChangeListener() {
        }

        public void notifyChanged(Notification notification) {
            block5: {
                block6: {
                    if (notification.getFeatureID(TelecomStatusMonitorToolCustomImpl.class) != 0 || TelecomStatusMonitorToolCustomImpl.this.isDisposed() || !TelecomStatusMonitorToolCustomImpl.this.isRunning()) break block5;
                    if (notification.getEventType() != 3 && notification.getEventType() != 5) break block6;
                    for (TelecomNode node : TelecomStatusMonitorToolCustomImpl.this.getTelecomNodes()) {
                        boolean found = false;
                        for (TelecomNodeJob job : TelecomStatusMonitorToolCustomImpl.this.nodeJobs) {
                            if (job.getTelecomNode() != node) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        TelecomNodeJob newJob = new TelecomNodeJob(node);
                        newJob.schedule();
                        TelecomStatusMonitorToolCustomImpl.this.nodeJobs.add(newJob);
                    }
                    break block5;
                }
                if (notification.getEventType() != 4 && notification.getEventType() != 6) break block5;
                ArrayList<TelecomNodeJob> removeJobs = new ArrayList<TelecomNodeJob>();
                for (TelecomNodeJob nodeJob : TelecomStatusMonitorToolCustomImpl.this.nodeJobs) {
                    boolean found = false;
                    for (TelecomNode node : TelecomStatusMonitorToolCustomImpl.this.getTelecomNodes()) {
                        if (nodeJob.getTelecomNode() != node) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    removeJobs.add(nodeJob);
                }
                for (TelecomNodeJob removeJob : removeJobs) {
                    removeJob.cancel();
                    TelecomStatusMonitorToolCustomImpl.this.nodeJobs.remove((Object)removeJob);
                }
            }
        }
    }
}

