/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.databinding.converters;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.apogy.common.databinding.converters.AbstractNumberConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToLongConverter
extends AbstractNumberConverter {
    private static final Logger Logger = LoggerFactory.getLogger(StringToLongConverter.class);

    public StringToLongConverter() {
        super(String.class, Long.class);
    }

    public StringToLongConverter(NumberFormat numberFormat) {
        super(String.class, Long.class);
        this.setNumberFormat(numberFormat);
    }

    public Object convert(Object fromObject) {
        if (this.getNumberFormat() != null) {
            try {
                return new Long(this.getNumberFormat().parse((String)fromObject).longValue());
            }
            catch (ParseException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new Long((String)fromObject);
    }
}

