/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.descriptors;

import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractUnitItemPropertyDescriptor
extends ItemPropertyDescriptor {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractUnitItemPropertyDescriptor.class);
    private IPropertyChangeListener preferencesListener = null;
    private Unit<?> nativeUnit = null;
    private Unit<?> displayUnit = null;
    private Boolean unitsAreDefined = null;
    private Boolean unitsAreValid = null;

    public AbstractUnitItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, boolean multiLine, boolean sortChoices, Object staticImage, String category, String[] filterFlags) {
        super(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, staticImage, category, filterFlags);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
    }

    public void setPropertyValue(Object object, Object value) {
        Object nativeValue = value;
        if (this.areUnitsValid() && value instanceof Number) {
            try {
                double displayValue = ((Number)value).doubleValue();
                double tempNativeValue = this.getDisplayUnit().getConverterTo(this.getNativeUnit()).convert(displayValue);
                if (nativeValue instanceof Byte) {
                    nativeValue = ((Number)tempNativeValue).byteValue();
                } else if (nativeValue instanceof Short) {
                    nativeValue = ((Number)tempNativeValue).shortValue();
                } else if (nativeValue instanceof Integer) {
                    nativeValue = ((Number)tempNativeValue).intValue();
                } else if (nativeValue instanceof Long) {
                    nativeValue = ((Number)tempNativeValue).longValue();
                } else if (nativeValue instanceof Float) {
                    nativeValue = Float.valueOf(((Number)tempNativeValue).floatValue());
                } else if (nativeValue instanceof Double) {
                    nativeValue = tempNativeValue;
                }
            }
            catch (Throwable t) {
                String featureID = String.valueOf(this.feature.getEContainingClass().getInstanceClassName()) + "." + this.feature.getName();
                Logger.error(String.valueOf(featureID) + " : Failed to convert from display units to native units.", t);
            }
        }
        super.setPropertyValue(object, nativeValue);
    }

    public String getDisplayName(Object object) {
        String displayName = super.getDisplayName(object);
        if (this.areUnitsValid()) {
            displayName = String.valueOf(displayName) + " (" + this.getDisplayUnit().toString() + ")";
        }
        return displayName;
    }

    public boolean areUnitsDefined() {
        if (this.unitsAreDefined == null) {
            this.unitsAreDefined = new Boolean(this.getNativeUnit() != null && this.getDisplayUnit() != null);
        }
        return this.unitsAreDefined;
    }

    public boolean areUnitsValid() {
        if (this.unitsAreValid == null) {
            this.unitsAreValid = Boolean.FALSE;
            if (this.areUnitsDefined()) {
                try {
                    this.getNativeUnit().getConverterTo(this.getDisplayUnit());
                    this.unitsAreValid = true;
                }
                catch (Throwable e) {
                    String featureID = String.valueOf(this.feature.getEContainingClass().getInstanceClassName()) + "." + this.feature.getName();
                    Logger.error("Invalid Units for feature <" + featureID + "> : Display Unit <" + this.getDisplayUnit().toString() + "> is not compatible with Native Unit <" + this.getNativeUnit().toString() + ">.", e);
                }
            }
        }
        return this.unitsAreValid;
    }

    protected Object getValue(EObject object, EStructuralFeature feature) {
        if (this.areUnitsValid()) {
            try {
                Object value = super.getValue(object, feature);
                if (value instanceof Number) {
                    double nativeValue = ((Number)value).doubleValue();
                    double displayValue = this.getNativeUnit().getConverterTo(this.getDisplayUnit()).convert(nativeValue);
                    return Double.toString(displayValue);
                }
            }
            catch (Throwable t) {
                String featureID = String.valueOf(feature.getEContainingClass().getInstanceClassName()) + "." + feature.getName();
                Logger.error(String.valueOf(featureID) + " : Failed to convert from native units to display units !", t);
            }
        }
        return super.getValue(object, feature);
    }

    protected Unit<?> getDisplayUnit() {
        if (this.displayUnit == null) {
            this.displayUnit = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)this.feature);
        }
        return this.displayUnit;
    }

    protected Unit<?> getNativeUnit() {
        if (this.nativeUnit == null) {
            this.nativeUnit = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.feature);
        }
        return this.nativeUnit;
    }

    private IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    AbstractUnitItemPropertyDescriptor.this.displayUnit = null;
                    AbstractUnitItemPropertyDescriptor.this.unitsAreDefined = null;
                    AbstractUnitItemPropertyDescriptor.this.unitsAreValid = null;
                }
            };
        }
        return this.preferencesListener;
    }
}

