/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.wizards;

import org.eclipse.apogy.common.emf.Described;
import org.eclipse.apogy.common.emf.Named;
import org.eclipse.apogy.common.emf.ui.composites.DescribedComposite;
import org.eclipse.apogy.common.emf.ui.composites.NamedComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class NamedDescribedWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.emf.ui.wizards.NamedDescribedWizardPage";
    private NamedComposite namedComposite;
    private DescribedComposite describedComposite;
    private Adapter adapter;
    private Named named;
    private Described described;

    public NamedDescribedWizardPage() {
        super(WIZARD_PAGE_ID);
        this.setTitle("Name and Description");
        this.setDescription("Enter a name and a description (optional).");
    }

    public NamedDescribedWizardPage(Named name, Described description) {
        this();
        if (this.named != null) {
            this.named.eAdapters().remove((Object)this.getAdapter());
        }
        if (this.described != null) {
            this.described.eAdapters().remove((Object)this.getAdapter());
        }
        this.named = name;
        this.described = description;
        if (name != null) {
            name.eAdapters().add((Object)this.getAdapter());
        }
        if (description != null) {
            description.eAdapters().add((Object)this.getAdapter());
        }
        this.validate();
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    NamedDescribedWizardPage.this.validate();
                }
            };
        }
        return this.adapter;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.namedComposite = new NamedComposite(container, 0);
        this.namedComposite.setNamed(this.named);
        this.namedComposite.setLayoutData(new GridData(4, 4, true, false));
        this.describedComposite = new DescribedComposite(container, 0);
        this.describedComposite.setDescribed(this.described);
        this.describedComposite.setLayoutData(new GridData(4, 4, true, true));
        this.setControl((Control)container);
        this.namedComposite.setFocus();
        this.validate();
    }

    public void dispose() {
        super.dispose();
        if (this.named != null) {
            this.named.eAdapters().remove((Object)this.getAdapter());
        }
        if (this.described != null) {
            this.described.eAdapters().remove((Object)this.getAdapter());
        }
    }

    public boolean isNamedDesctibedSet() {
        return this.named != null && this.described != null;
    }

    protected void validate() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String errorStr = null;
                String infoStr = null;
                if (NamedDescribedWizardPage.this.named == null || NamedDescribedWizardPage.this.named.getName() == null || NamedDescribedWizardPage.this.named.getName().isEmpty()) {
                    errorStr = "A name must be provided.";
                }
                if (NamedDescribedWizardPage.this.described == null || NamedDescribedWizardPage.this.described.getDescription() == null || NamedDescribedWizardPage.this.described.getDescription().isEmpty()) {
                    infoStr = "It is recommended to enter a description.";
                }
                NamedDescribedWizardPage.this.setMessage(infoStr);
                NamedDescribedWizardPage.this.setErrorMessage(errorStr);
                NamedDescribedWizardPage.this.setPageComplete(errorStr == null);
            }
        });
    }
}

