/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Ranges implements Enumerator
{
    UNKNOWN(0, "UNKNOWN", "UNKNOWN"),
    NOMINAL(1, "NOMINAL", "NOMINAL"),
    WARNING(2, "WARNING", "WARNING"),
    ALARM(3, "ALARM", "ALARM"),
    OUT_OF_RANGE(4, "OUT_OF_RANGE", "OUT_OF_RANGE");

    public static final int UNKNOWN_VALUE = 0;
    public static final int NOMINAL_VALUE = 1;
    public static final int WARNING_VALUE = 2;
    public static final int ALARM_VALUE = 3;
    public static final int OUT_OF_RANGE_VALUE = 4;
    private static final Ranges[] VALUES_ARRAY;
    public static final List<Ranges> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Ranges[]{UNKNOWN, NOMINAL, WARNING, ALARM, OUT_OF_RANGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Ranges get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Ranges result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Ranges getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Ranges result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Ranges get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return NOMINAL;
            }
            case 2: {
                return WARNING;
            }
            case 3: {
                return ALARM;
            }
            case 4: {
                return OUT_OF_RANGE;
            }
        }
        return null;
    }

    private Ranges(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

