/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.apogy.common.converters.FileExporterUtilities;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSetExtent;
import org.eclipse.apogy.common.geometry.data3d.Data3DIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianCoordinatesSetFileExporter
implements IFileExporter {
    private static final Logger Logger = LoggerFactory.getLogger(CartesianCoordinatesSetFileExporter.class);
    public static final String XYZ_FILE_EXTENSION = "xyz";

    public Class<?> getOutputType() {
        return File.class;
    }

    public Class<?> getInputType() {
        return CartesianCoordinatesSet.class;
    }

    public boolean canConvert(Object input) {
        if (input instanceof CartesianCoordinatesSet) {
            CartesianCoordinatesSet points = (CartesianCoordinatesSet)input;
            return points.getPoints().size() > 0;
        }
        return false;
    }

    public Object convert(Object input) throws Exception {
        CartesianCoordinatesSet points = (CartesianCoordinatesSet)input;
        String tmpFolder = String.valueOf(System.getProperty("user.home")) + File.separator + System.getProperty("java.io.tmpdir");
        Date now = new Date();
        String fileName = null;
        try {
            fileName = String.valueOf(tmpFolder) + File.separator + now.getTime() + "." + XYZ_FILE_EXTENSION;
            Data3DIO.INSTANCE.saveCoordinatesSetToXYZ(points, fileName);
            return new File(fileName);
        }
        catch (Exception e) {
            File toDelete = new File(fileName);
            toDelete.delete();
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void exportToFile(Object input, String filePath, List<String> extensions) throws Exception {
        CartesianCoordinatesSet points = (CartesianCoordinatesSet)input;
        for (String extension : extensions) {
            String fullPathString = String.valueOf(filePath) + "." + extension;
            if (extension.equalsIgnoreCase(XYZ_FILE_EXTENSION)) {
                if (!fullPathString.endsWith(".xyz")) {
                    fullPathString = String.valueOf(fullPathString) + ".xyz";
                }
                Data3DIO.INSTANCE.saveCoordinatesSetToXYZ(points, fullPathString);
                continue;
            }
            if (!extension.equalsIgnoreCase("metadata")) continue;
            FileExporterUtilities.saveMetaDataToFile((String)fullPathString, (String)CartesianCoordinatesSetFileExporter.getMetaData(points));
        }
    }

    public List<String> getSupportedFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(XYZ_FILE_EXTENSION);
        extensions.add("metadata");
        return extensions;
    }

    public String getDescription(String fileExtension) {
        if (fileExtension.contains(XYZ_FILE_EXTENSION)) {
            return "The mesh vertices in a xyz file format.";
        }
        if (fileExtension.contains("metadata")) {
            return "The mesh metadata.";
        }
        return null;
    }

    public static String getMetaData(CartesianCoordinatesSet points) {
        String metadata = "";
        if (points != null) {
            metadata = String.valueOf(metadata) + "Mesh number of points = " + points.getPoints().size() + "\n";
            CartesianCoordinatesSetExtent extent = points.getExtent();
            metadata = String.valueOf(metadata) + "Mesh minimum X = " + extent.getXMin() + "\n";
            metadata = String.valueOf(metadata) + "Mesh maximum X = " + extent.getXMax() + "\n";
            metadata = String.valueOf(metadata) + "Mesh minimum Y = " + extent.getYMin() + "\n";
            metadata = String.valueOf(metadata) + "Mesh maximum Y = " + extent.getYMax() + "\n";
            metadata = String.valueOf(metadata) + "Mesh minimum Z = " + extent.getZMin() + "\n";
            metadata = String.valueOf(metadata) + "Mesh maximum Z = " + extent.getZMax() + "\n";
        }
        return metadata;
    }
}

