/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.ui;

import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.ui.Activator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagesUiUtilities {
    private static final Logger Logger = LoggerFactory.getLogger(ImagesUiUtilities.class);

    private ImagesUiUtilities() {
    }

    public static void export(ImageData imageData) {
        ImagesUiUtilities.export(imageData, null);
    }

    public static void export(ImageData imageData, String defaultFilename) {
        String currentDir = System.getProperty("user.dir");
        FileDialog fileChooser = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        if (defaultFilename != null) {
            fileChooser.setFileName(defaultFilename);
        }
        fileChooser.setText("Open image file");
        fileChooser.setFilterPath(currentDir);
        fileChooser.setFilterExtensions(new String[]{"*.jpg;*.png;"});
        String filename = fileChooser.open();
        if (filename != null) {
            try {
                EImage image = ApogyCommonImagesFactory.eINSTANCE.createEImage();
                image.setImageContent(EImagesUtilities.INSTANCE.convertToBufferedImage(imageData));
                if (filename.endsWith(".jpg")) {
                    ImagesUiUtilities.saveImageInJob((AbstractEImage)image, filename, 4);
                } else if (filename.endsWith(".png")) {
                    ImagesUiUtilities.saveImageInJob((AbstractEImage)image, filename, 5);
                } else {
                    String fileExtension = "";
                    if (filename.lastIndexOf(".") > 0) {
                        fileExtension = filename.substring(filename.lastIndexOf("."));
                    }
                    String message = "Failed to save the image. The specified file extension <" + fileExtension + "> is not supported.";
                    Status status = new Status(4, "org.eclipse.apogy.common.images.ui", message);
                    Activator.getDefault().getLog().log((IStatus)status);
                    MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 33);
                    messageBox.setMessage(message);
                    messageBox.open();
                }
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            currentDir = fileChooser.getFilterPath();
        }
    }

    private static void saveImageInJob(final AbstractEImage image, final String fileName, final int fileType) {
        UIJob job = new UIJob("Saving Image to file <" + fileName + ">"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (fileType == 4) {
                        EImagesUtilities.INSTANCE.saveImageAsJPEG(fileName, image);
                    } else if (fileType == 5) {
                        EImagesUtilities.INSTANCE.saveImageAsPNG(fileName, image);
                    }
                    Status status = new Status(0, "org.eclipse.apogy.common.images.ui", "Sucessfully saved image to file <" + fileName + ">.");
                    Activator.getDefault().getLog().log((IStatus)status);
                    return status;
                }
                catch (Exception e) {
                    String message = "Failed to save the image to file <" + fileName + ">. The following exception was thrown : \n\n " + e.getMessage();
                    Status status = new Status(4, "org.eclipse.apogy.common.images.ui", message, (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    return status;
                }
            }
        };
        job.schedule();
    }
}

