/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.ui.renderers;

import javax.inject.Inject;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.ui.composites.Tuple3dComposite;
import org.eclipse.core.databinding.Binding;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuple3dControlRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(Tuple3dControlRenderer.class);
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());

    @Inject
    public Tuple3dControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        return new Binding[0];
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        Tuple3d tuple3d = (Tuple3d)this.getValue();
        if (tuple3d == null) {
            tuple3d = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
            this.getModelValue().setValue((Object)tuple3d);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        Section section = this.toolkit.createSection(composite, 320);
        this.toolkit.adapt((Composite)section);
        section.setText("Tuple 3D");
        section.setExpanded(true);
        Tuple3dComposite tupleComposite = new Tuple3dComposite((Composite)section, 0, (EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)tuple3d));
        tupleComposite.setTuple3d(tuple3d);
        tupleComposite.setBackground(tupleComposite.getDisplay().getSystemColor(1));
        section.setClient((Control)tupleComposite);
        return composite;
    }

    protected String getUnsetText() {
        return "Unset";
    }

    protected Object getValue() {
        try {
            Object obj = this.getModelValue().getValue();
            return obj;
        }
        catch (DatabindingFailedException e) {
            Logger.error("Unable to set the RGB value.");
            return null;
        }
    }

    protected void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }
}

