/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.dynamics.ui.composites;

import org.eclipse.apogy.common.topology.addons.dynamics.ApogyCommonTopologyAddonsDynamicsPackage;
import org.eclipse.apogy.common.topology.addons.dynamics.ConstraintState;
import org.eclipse.apogy.common.topology.addons.dynamics.CylindricalConstraint;
import org.eclipse.apogy.common.topology.addons.dynamics.ui.composites.ConstraintStateComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class CylindricalConstraintComposite
extends Composite {
    private DataBindingContext m_bindingContext;
    private CylindricalConstraint cylindricalConstraint;
    private final Button enabledButton;
    private final ConstraintStateComposite angularConstraintStateComposite;
    private final ConstraintStateComposite linearConstraintStateComposite;
    private Adapter constraintStatesAdapter;

    public CylindricalConstraintComposite(Composite parent, int style, CylindricalConstraint newCylindricalConstraint) {
        this(parent, style);
        this.setCylindricalConstraint(newCylindricalConstraint);
    }

    public CylindricalConstraintComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this, 0).setText("Enabled:");
        this.enabledButton = new Button((Composite)this, 32);
        this.enabledButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group angularCurrentStateGroup = new Group((Composite)this, 0);
        angularCurrentStateGroup.setText("Current Angular State");
        angularCurrentStateGroup.setLayout((Layout)new FillLayout(256));
        angularCurrentStateGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.angularConstraintStateComposite = new ConstraintStateComposite((Composite)angularCurrentStateGroup, 0);
        Group linearCurrentStateGroup = new Group((Composite)this, 0);
        linearCurrentStateGroup.setText("Current Linear State");
        linearCurrentStateGroup.setLayout((Layout)new FillLayout(256));
        linearCurrentStateGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.linearConstraintStateComposite = new ConstraintStateComposite((Composite)linearCurrentStateGroup, 0);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        if (this.cylindricalConstraint != null) {
            this.m_bindingContext = this.initDataBindings();
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CylindricalConstraintComposite.this.m_bindingContext != null) {
                    CylindricalConstraintComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void checkSubclass() {
    }

    private DataBindingContext initDataBindings() {
        ISWTObservableValue enabledObserveWidget = WidgetProperties.selection().observe((Widget)this.enabledButton);
        IObservableValue enabledObserveValue = EMFProperties.value((EStructuralFeature)ApogyCommonTopologyAddonsDynamicsPackage.Literals.ABSTRACT_CONSTRAINT__ENABLED).observe((Object)this.cylindricalConstraint);
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)enabledObserveWidget, enabledObserveValue, null, null);
        return bindingContext;
    }

    public CylindricalConstraint getCylindricalConstraint() {
        return this.cylindricalConstraint;
    }

    public void setCylindricalConstraint(CylindricalConstraint newCylindricalConstraint) {
        if (this.getCylindricalConstraint() != null) {
            this.getCylindricalConstraint().eAdapters().remove((Object)this.getConstraintStatesAdapter());
        }
        this.setCylindricalConstraint(newCylindricalConstraint, true);
        if (newCylindricalConstraint != null) {
            newCylindricalConstraint.eAdapters().add((Object)this.getConstraintStatesAdapter());
            this.angularConstraintStateComposite.setConstraintState(newCylindricalConstraint.getAngularCurrentState());
            this.linearConstraintStateComposite.setConstraintState(newCylindricalConstraint.getLinearCurrentState());
        } else {
            this.angularConstraintStateComposite.setConstraintState(null);
            this.linearConstraintStateComposite.setConstraintState(null);
        }
    }

    public void setCylindricalConstraint(CylindricalConstraint newCylindricalConstraint, boolean update) {
        this.cylindricalConstraint = newCylindricalConstraint;
        if (update) {
            if (this.m_bindingContext != null) {
                this.m_bindingContext.dispose();
                this.m_bindingContext = null;
            }
            if (this.cylindricalConstraint != null) {
                this.m_bindingContext = this.initDataBindings();
            } else {
                this.enabledButton.setSelection(false);
            }
        }
    }

    private Adapter getConstraintStatesAdapter() {
        if (this.constraintStatesAdapter == null) {
            this.constraintStatesAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == ApogyCommonTopologyAddonsDynamicsPackage.Literals.CYLINDRICAL_CONSTRAINT__ANGULAR_CURRENT_STATE) {
                        CylindricalConstraintComposite.this.angularConstraintStateComposite.setConstraintState((ConstraintState)msg.getNewValue(), true);
                    } else if (msg.getFeature() == ApogyCommonTopologyAddonsDynamicsPackage.Literals.CYLINDRICAL_CONSTRAINT__LINEAR_CURRENT_STATE) {
                        CylindricalConstraintComposite.this.linearConstraintStateComposite.setConstraintState((ConstraintState)msg.getNewValue());
                    }
                }
            };
        }
        return this.constraintStatesAdapter;
    }
}

