/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3.internal;

import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.renderer.Camera;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;

public abstract class MouseClickListener
implements ActionListener {
    public static final String LEFT_MOUSE_CLICK_EVENT = "LeftMouseButtonClickEvent";
    public static final String MIDDLE_MOUSE_CLICK_EVENT = "MiddleMouseButtonClickEvent";
    public static final String RIGHT_MOUSE_CLICK_EVENT = "RightMouseButtonClickEvent";
    private final InputManager inputManager;
    private boolean mouseInputRegistered = false;
    private boolean enabled = false;

    public MouseClickListener(Camera camera, JME3Application jme3Application, InputManager inputManager) {
        this.inputManager = inputManager;
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            if (!this.mouseInputRegistered) {
                this.registerMouseInput();
            }
        } else if (this.mouseInputRegistered) {
            this.unregisterMouseInput();
        }
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void onAction(String name, boolean keyPressed, float tpf) {
        if (name.equals(LEFT_MOUSE_CLICK_EVENT) && keyPressed) {
            this.mouseClicked(0);
        }
        if (name.equals(MIDDLE_MOUSE_CLICK_EVENT) && keyPressed) {
            this.mouseClicked(2);
        }
        if (name.equals(RIGHT_MOUSE_CLICK_EVENT) && keyPressed) {
            this.mouseClicked(1);
        }
    }

    protected abstract void mouseClicked(int var1);

    private void registerMouseInput() {
        if (!this.inputManager.hasMapping(LEFT_MOUSE_CLICK_EVENT)) {
            this.inputManager.addMapping(LEFT_MOUSE_CLICK_EVENT, new Trigger[]{new MouseButtonTrigger(0)});
            this.inputManager.addListener((InputListener)this, new String[]{LEFT_MOUSE_CLICK_EVENT});
        }
        if (!this.inputManager.hasMapping(MIDDLE_MOUSE_CLICK_EVENT)) {
            this.inputManager.addMapping(MIDDLE_MOUSE_CLICK_EVENT, new Trigger[]{new MouseButtonTrigger(2)});
            this.inputManager.addListener((InputListener)this, new String[]{MIDDLE_MOUSE_CLICK_EVENT});
        }
        if (!this.inputManager.hasMapping(RIGHT_MOUSE_CLICK_EVENT)) {
            this.inputManager.addMapping(RIGHT_MOUSE_CLICK_EVENT, new Trigger[]{new MouseButtonTrigger(1)});
            this.inputManager.addListener((InputListener)this, new String[]{RIGHT_MOUSE_CLICK_EVENT});
        }
        this.mouseInputRegistered = true;
    }

    private void unregisterMouseInput() {
        if (this.inputManager.hasMapping(LEFT_MOUSE_CLICK_EVENT)) {
            this.inputManager.deleteMapping(LEFT_MOUSE_CLICK_EVENT);
        }
        if (this.inputManager.hasMapping(MIDDLE_MOUSE_CLICK_EVENT)) {
            this.inputManager.deleteMapping(MIDDLE_MOUSE_CLICK_EVENT);
        }
        if (this.inputManager.hasMapping(RIGHT_MOUSE_CLICK_EVENT)) {
            this.inputManager.deleteMapping(RIGHT_MOUSE_CLICK_EVENT);
        }
        this.mouseInputRegistered = false;
    }
}

