/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.wizards;

import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NodeWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.topology.ui.wizards.NodeWizardPage";
    private Text nodeIDText;
    private Text descriptionText;
    private final Node node;
    private DataBindingContext m_bindingContext;

    public NodeWizardPage(Node node) {
        super(WIZARD_PAGE_ID);
        this.node = node;
        this.setTitle("Node");
        this.setDescription("Sets the Node ID and description.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        Composite settingComposite = new Composite(top, 0);
        settingComposite.setLayout((Layout)new GridLayout(2, false));
        settingComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblNodeId = new Label(settingComposite, 0);
        lblNodeId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNodeId.setText("Node ID:");
        this.nodeIDText = new Text(settingComposite, 2048);
        this.nodeIDText.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.nodeIDText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                NodeWizardPage.this.validate();
            }

            public void keyPressed(KeyEvent e) {
                NodeWizardPage.this.validate();
            }
        });
        Label lblDescription = new Label(settingComposite, 0);
        lblDescription.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblDescription.setText("Description:");
        this.descriptionText = new Text(settingComposite, 2114);
        this.descriptionText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.descriptionText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                NodeWizardPage.this.validate();
            }

            public void keyPressed(KeyEvent e) {
                NodeWizardPage.this.validate();
            }
        });
        this.setControl((Control)top);
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NodeWizardPage.this.m_bindingContext != null) {
                    NodeWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.node.getNodeId() == null || this.node.getNodeId().length() == 0) {
            this.setErrorMessage("The specified Node ID is invalid!");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeImageWidthResolution = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.node), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonTopologyPackage.Literals.NODE__NODE_ID})).observe((Object)this.node);
        ISWTObservableValue observeImageWidthText = WidgetProperties.text((int)24).observe((Widget)this.nodeIDText);
        bindingContext.bindValue((IObservableValue)observeImageWidthText, observeImageWidthResolution, new UpdateValueStrategy(), new UpdateValueStrategy());
        IObservableValue observeImageHeight = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.node), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonTopologyPackage.Literals.NODE__DESCRIPTION})).observe((Object)this.node);
        ISWTObservableValue observeImageHeightText = WidgetProperties.text((int)24).observe((Widget)this.descriptionText);
        bindingContext.bindValue((IObservableValue)observeImageHeightText, observeImageHeight, new UpdateValueStrategy(), new UpdateValueStrategy());
        return bindingContext;
    }
}

