/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite.ui.composites;

import org.eclipse.apogy.examples.satellite.AbstractConstellationRequest;
import org.eclipse.apogy.examples.satellite.ConstellationDownlinksList;
import org.eclipse.apogy.examples.satellite.ConstellationState;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ConstellationStateDashboardComposite
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private TableViewer plansViewer;
    private TreeViewer downlinksViewer;
    private TableViewer requestsViewer;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private ConstellationState constellationState;
    private DataBindingContext m_bindingContext;
    private Label lblLoadingStatus;

    public ConstellationStateDashboardComposite(Composite parent, int style) {
        super(parent, 0);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ConstellationStateDashboardComposite.this.toolkit.dispose();
            }
        });
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new GridLayout(1, false));
        Section sctnOverview = this.toolkit.createSection((Composite)this, 320);
        sctnOverview.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.toolkit.paintBordersFor((Composite)sctnOverview);
        sctnOverview.setText("Overview");
        Composite compositeOverview = new Composite((Composite)sctnOverview, 0);
        this.toolkit.adapt(compositeOverview);
        this.toolkit.paintBordersFor(compositeOverview);
        sctnOverview.setClient((Control)compositeOverview);
        compositeOverview.setLayout((Layout)new RowLayout(256));
        this.lblLoadingStatus = new Label(compositeOverview, 0);
        this.toolkit.adapt((Control)this.lblLoadingStatus, true, true);
        this.lblLoadingStatus.setText("NOT LOADED");
        SashForm sashForm = new SashForm((Composite)this, 67584);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.toolkit.adapt((Composite)sashForm);
        this.toolkit.paintBordersFor((Composite)sashForm);
        Composite compositeLeft = this.toolkit.createComposite((Composite)sashForm, 0);
        this.toolkit.paintBordersFor(compositeLeft);
        compositeLeft.setLayout((Layout)new GridLayout(1, false));
        Section sctnPlans = this.toolkit.createSection(compositeLeft, 320);
        sctnPlans.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.toolkit.paintBordersFor((Composite)sctnPlans);
        sctnPlans.setText("Plans");
        this.plansViewer = new TableViewer((Composite)sctnPlans, 2816);
        this.plansViewer.setUseHashlookup(true);
        Table tablePlans = this.plansViewer.getTable();
        tablePlans.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tablePlans.setLinesVisible(true);
        sctnPlans.setClient((Control)tablePlans);
        this.plansViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.plansViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        Section sctnDownlinks = this.toolkit.createSection(compositeLeft, 320);
        sctnDownlinks.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        sctnDownlinks.setBounds(0, 0, 117, 23);
        this.toolkit.paintBordersFor((Composite)sctnDownlinks);
        sctnDownlinks.setText("Downlinks");
        this.downlinksViewer = new TreeViewer((Composite)sctnDownlinks, 2816);
        this.downlinksViewer.setUseHashlookup(true);
        Tree treeDownlinks = this.downlinksViewer.getTree();
        treeDownlinks.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        treeDownlinks.setLinesVisible(true);
        sctnDownlinks.setClient((Control)treeDownlinks);
        this.downlinksViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory){

            public boolean hasChildren(Object object) {
                return object instanceof ConstellationDownlinksList ? super.hasChildren(object) : false;
            }

            public Object[] getChildren(Object object) {
                return this.hasChildren(object) ? super.getChildren(object) : null;
            }
        });
        this.downlinksViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        Composite compositeRight = this.toolkit.createComposite((Composite)sashForm, 0);
        this.toolkit.paintBordersFor(compositeRight);
        compositeRight.setLayout((Layout)new GridLayout(1, false));
        Section sctnRequests = this.toolkit.createSection(compositeRight, 320);
        sctnRequests.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.toolkit.paintBordersFor((Composite)sctnRequests);
        sctnRequests.setText("Requests");
        this.requestsViewer = new TableViewer((Composite)sctnRequests, 2816);
        this.requestsViewer.setUseHashlookup(true);
        Table tableRequests = this.requestsViewer.getTable();
        tableRequests.setHeaderVisible(true);
        tableRequests.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tableRequests.setLinesVisible(true);
        sctnRequests.setClient((Control)tableRequests);
        TableViewerColumn tableViewerColumnUID = new TableViewerColumn(this.requestsViewer, 0);
        TableColumn tblclmnUID = tableViewerColumnUID.getColumn();
        tblclmnUID.setWidth(80);
        tblclmnUID.setText("UID");
        tblclmnUID.setToolTipText("Refers to the constellation Request Unique Identifier.");
        TableViewerColumn tableViewerSatellite = new TableViewerColumn(this.requestsViewer, 0);
        TableColumn tblclmnSatellite = tableViewerSatellite.getColumn();
        tblclmnSatellite.setWidth(150);
        tblclmnSatellite.setText("Satellite");
        tblclmnSatellite.setToolTipText("Specifies the satellite that will process the constellation request.");
        TableViewerColumn tableViewerPriority = new TableViewerColumn(this.requestsViewer, 0);
        TableColumn tblclmnPriority = tableViewerPriority.getColumn();
        tblclmnPriority.setWidth(150);
        tblclmnPriority.setText("Priority");
        tblclmnPriority.setToolTipText("Specifies the priority level the constellation request.");
        TableViewerColumn tableViewerColumnStatus = new TableViewerColumn(this.requestsViewer, 0);
        TableColumn tblclmnStatus = tableViewerColumnStatus.getColumn();
        tblclmnStatus.setWidth(100);
        tblclmnStatus.setText("Status");
        tblclmnStatus.setToolTipText("Actual execution status of the constellation Request.");
        TableViewerColumn tableViewerColumnLocation = new TableViewerColumn(this.requestsViewer, 0);
        TableColumn tblclmnLocation = tableViewerColumnLocation.getColumn();
        tblclmnLocation.setWidth(150);
        tblclmnLocation.setText("CMD Location");
        tblclmnLocation.setToolTipText("Requested location where to perform the request.");
        TableViewerColumn tableViewerColumnScheduleTime = new TableViewerColumn(this.requestsViewer, 0);
        TableColumn tblclmnScheduleTime = tableViewerColumnScheduleTime.getColumn();
        tblclmnScheduleTime.setWidth(150);
        tblclmnScheduleTime.setText("CMD Time");
        tblclmnScheduleTime.setToolTipText("Time at which the command associated to the constellation request will be executed.");
        TableViewerColumn tableViewerCompletionTime = new TableViewerColumn(this.requestsViewer, 0);
        TableColumn tblclmnCompletionTime = tableViewerCompletionTime.getColumn();
        tblclmnCompletionTime.setWidth(150);
        tblclmnCompletionTime.setText("ACT Time");
        tblclmnCompletionTime.setToolTipText("Time at which the command associated to the constellation request was effectively executed.");
        TableViewerColumn tableViewerColumnActualLocation = new TableViewerColumn(this.requestsViewer, 0);
        TableColumn tblclmnActualLocation = tableViewerColumnActualLocation.getColumn();
        tblclmnActualLocation.setWidth(150);
        tblclmnActualLocation.setText("Actual Location");
        tblclmnActualLocation.setToolTipText("Specifies the location where the command associated to the constellation request was executed.");
        TableViewerColumn tableViewerResult = new TableViewerColumn(this.requestsViewer, 0);
        TableColumn tblclmnResult = tableViewerResult.getColumn();
        tblclmnResult.setWidth(50);
        tblclmnResult.setText("Data");
        tblclmnResult.setToolTipText("Indicates if the constellation request has a result.");
        this.requestsViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.requestsViewer.setLabelProvider((IBaseLabelProvider)new RequestsLabelProvider(this.adapterFactory));
        Menu contextMenu = new Menu((Control)tableRequests);
        this.requestsViewer.getTable().setMenu(contextMenu);
        TableColumn[] tableColumnArray = this.requestsViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TableColumn tableColumn = tableColumnArray[n2];
            final MenuItem itemName = new MenuItem(contextMenu, 32);
            itemName.setText(tableColumn.getText());
            itemName.setSelection(tableColumn.getResizable());
            itemName.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (itemName.getSelection()) {
                        tableColumn.setWidth(150);
                        tableColumn.setResizable(true);
                    } else {
                        tableColumn.setWidth(0);
                        tableColumn.setResizable(false);
                    }
                }
            });
            ++n2;
        }
        sashForm.setWeights(new int[]{1, 2});
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ConstellationStateDashboardComposite.this.m_bindingContext != null) {
                    ConstellationStateDashboardComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public void setConstellationState(ConstellationState constellationState) {
        this.constellationState = constellationState;
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
            this.m_bindingContext = null;
        }
        if (this.constellationState != null) {
            this.m_bindingContext = this.initDataBindings();
        }
    }

    private DataBindingContext initDataBindings() {
        return this.initDataBindingsCustom();
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        if (this.constellationState != null) {
            this.plansViewer.setInput((Object)this.constellationState.getConstellationCommandPlansList());
            this.downlinksViewer.setInput((Object)this.constellationState.getDownlinksLists());
        }
        return bindingContext;
    }

    public void dispose() {
        super.dispose();
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
            this.m_bindingContext = null;
        }
    }

    public class ActivitiesViewerComparator
    extends ViewerComparator {
    }

    private class RequestsLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider {
        private static final int UID_COLUMN_ID = 0;
        private static final int SATELLITE_COLUMN_ID = 1;
        private static final int PRIORITY_COLUMN_ID = 2;

        public RequestsLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String str = "<undefined>";
            AbstractConstellationRequest request = (AbstractConstellationRequest)object;
            switch (columnIndex) {
                case 0: {
                    if (request.getUid() == null) break;
                    str = request.getUid().toString();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    str = request.getOrderPriority().getName();
                    break;
                }
            }
            return str;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

