/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.impl;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.apogy.addons.ros.ApogyAddonsROSFactory;
import org.eclipse.apogy.addons.ros.ROSNode;
import org.eclipse.apogy.addons.ros.ROSService;
import org.eclipse.apogy.addons.ros.ROSServiceState;
import org.eclipse.apogy.addons.ros.impl.ROSServiceManagerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.ros.internal.message.Message;
import org.ros.namespace.GraphName;
import org.ros.node.ConnectedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROSServiceManagerCustomImpl
extends ROSServiceManagerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ROSServiceManagerImpl.class);
    public static long WAIT_TIME_BETWEEN_TRIES_MS = 2000L;
    private final HashMap<String, ServiceLaunchRunnable> serviceLaunchRunnableList = new HashMap();
    private Adapter adapter;
    private Job serviceMonitoringJob = null;

    @Override
    public HashMap<String, ROSService<?, ?>> getServices() {
        if (this.services == null) {
            this.services = new HashMap();
        }
        return this.services;
    }

    @Override
    public void createService(String serviceName, String serviceType) {
        this.createService(serviceName, serviceType, true);
    }

    @Override
    public void createService(String serviceName, String serviceType, boolean disconnectOnTimeout) {
        ROSService service = ApogyAddonsROSFactory.eINSTANCE.createROSService();
        service.setServiceName(serviceName);
        service.setServiceType(serviceType);
        service.setDisconnectOnTimeout(disconnectOnTimeout);
        this.getServices().put(serviceName, service);
    }

    @Override
    public void createService(String serviceName, String serviceType, boolean disconnectOnTimeout, boolean enableAutoReconnect) {
        ROSService service = ApogyAddonsROSFactory.eINSTANCE.createROSService();
        service.setServiceName(serviceName);
        service.setServiceType(serviceType);
        service.setDisconnectOnTimeout(disconnectOnTimeout);
        service.setEnableAutoReconnect(enableAutoReconnect);
        this.getServices().put(serviceName, service);
    }

    @Override
    public <Request extends Message, Response extends Message> ROSService<Request, Response> getService(String serviceName) {
        if (this.getServices().containsKey(serviceName)) {
            ROSService<?, ?> service = this.getServices().get(serviceName);
            return service;
        }
        return null;
    }

    @Override
    public <Request extends Message, Response extends Message> Request createRequestMessage(String serviceName) {
        ROSService<Request, Response> service = this.getService(serviceName);
        if (service != null) {
            return service.newRequestMessage();
        }
        return null;
    }

    @Override
    public <Request extends Message, Response extends Message> Response callService(String serviceName, Request request) {
        return this.callService(serviceName, request, true);
    }

    @Override
    public <Request extends Message, Response extends Message> Response callService(String serviceName, Request request, int timeout) throws Exception {
        ROSService<Request, Response> service = this.getService(serviceName);
        if (service != null) {
            return service.call(request, false, timeout);
        }
        return null;
    }

    @Override
    public <Request extends Message, Response extends Message> Response callService(String serviceName) {
        return this.callService(serviceName, true);
    }

    @Override
    public <Request extends Message, Response extends Message> Response callService(String serviceName, Request request, boolean enableLogging) {
        ROSService<Request, Response> service = this.getService(serviceName);
        if (service != null && service.isLaunched()) {
            return service.call(request, enableLogging);
        }
        return null;
    }

    @Override
    public <Request extends Message, Response extends Message> Response callService(String serviceName, Request request, boolean enableLogging, int timeout) throws Exception {
        ROSService<Request, Response> service = this.getService(serviceName);
        if (service != null && service.isLaunched()) {
            return service.call(request, enableLogging, timeout);
        }
        throw new RuntimeException("Service <" + serviceName + "> is not running !");
    }

    @Override
    public <Request extends Message, Response extends Message> Response callService(String serviceName, boolean enableLogging) {
        ROSService<Request, Response> service = this.getService(serviceName);
        Request request = this.createRequestMessage(serviceName);
        if (service != null && service.isLaunched()) {
            return service.call(request, enableLogging);
        }
        throw new RuntimeException("Service <" + serviceName + "> is not running !");
    }

    @Override
    public void launch() {
        new Thread(){

            @Override
            public void run() {
                String listenerListMsg = "";
                for (ROSService<?, ?> service : ROSServiceManagerCustomImpl.this.getServices().values()) {
                    listenerListMsg = String.valueOf(listenerListMsg) + service.getServiceName() + "\n";
                }
                Logger.info("Starts launching the following services : \n" + listenerListMsg);
                for (ROSService<?, ?> service : ROSServiceManagerCustomImpl.this.getServices().values()) {
                    try {
                        Logger.info("Launching service <" + service.getServiceName() + ">.");
                        service.eAdapters().add((Object)ROSServiceManagerCustomImpl.this.getAdapter());
                        ServiceLaunchRunnable topicLaunchRunnable = new ServiceLaunchRunnable(ROSServiceManagerCustomImpl.this.getNode(), service);
                        ROSServiceManagerCustomImpl.this.serviceLaunchRunnableList.put(service.getServiceName(), topicLaunchRunnable);
                        Thread thread = new Thread(topicLaunchRunnable);
                        thread.start();
                    }
                    catch (Exception e) {
                        Logger.error("Could not launch service <" + service.getServiceName() + ">.", (Throwable)e);
                    }
                }
                ROSServiceManagerCustomImpl.this.setRunning(true);
                Logger.info("Services launch completed.");
            }
        }.start();
        this.getServiceStateMonitoring().cancel();
        this.getServiceStateMonitoring().schedule();
    }

    @Override
    public void stop() {
        for (ServiceLaunchRunnable serviceLaunchRunnable : this.serviceLaunchRunnableList.values()) {
            serviceLaunchRunnable.stop();
        }
        this.serviceLaunchRunnableList.clear();
        for (ROSService rOSService : this.getServices().values()) {
            rOSService.eAdapters().remove((Object)this.getAdapter());
            rOSService.stop();
            rOSService.setServiceState(ROSServiceState.STOPPED);
        }
        this.getServiceStateMonitoring().cancel();
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ROSService) {
                        ROSService service = (ROSService)msg.getNotifier();
                        int featureID = msg.getFeatureID(ROSService.class);
                        if (featureID == 7) {
                            ROSServiceState oldState = (ROSServiceState)((Object)msg.getOldValue());
                            ROSServiceState newState = (ROSServiceState)((Object)msg.getNewValue());
                            if (newState == ROSServiceState.FAILED && oldState == ROSServiceState.READY) {
                                Logger.warn("Service <" + service.getServiceName() + "> failed, attempting to re-connect.");
                                ServiceLaunchRunnable oldServiceLaunchRunnable = (ServiceLaunchRunnable)ROSServiceManagerCustomImpl.this.serviceLaunchRunnableList.get(service.getServiceName());
                                if (oldServiceLaunchRunnable != null) {
                                    oldServiceLaunchRunnable.stop();
                                }
                                ServiceLaunchRunnable newServiceLaunchRunnable = new ServiceLaunchRunnable(ROSServiceManagerCustomImpl.this.getNode(), service);
                                ROSServiceManagerCustomImpl.this.serviceLaunchRunnableList.put(service.getServiceName(), newServiceLaunchRunnable);
                                Thread thread = new Thread(newServiceLaunchRunnable);
                                thread.start();
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    protected Job getServiceStateMonitoring() {
        if (this.serviceMonitoringJob == null) {
            this.serviceMonitoringJob = new Job("ROSServiceManager Service Monitoring"){

                protected IStatus run(IProgressMonitor monitor) {
                    while (!monitor.isCanceled()) {
                        for (ROSService<?, ?> service : ROSServiceManagerCustomImpl.this.getServices().values()) {
                            try {
                                if (!service.isEnableAutoReconnect() || service.getServiceState() != ROSServiceState.READY) continue;
                                try {
                                    ConnectedNode node = ROSServiceManagerCustomImpl.this.getNode().getConnectedNode();
                                    GraphName resolvedServiceName = node.resolveName(service.getServiceName());
                                    URI uri = node.lookupServiceUri(resolvedServiceName);
                                    if (uri != null) continue;
                                    service.setServiceState(ROSServiceState.FAILED);
                                }
                                catch (Throwable t) {
                                    service.setServiceState(ROSServiceState.FAILED);
                                }
                            }
                            catch (Exception e) {
                                Logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.serviceMonitoringJob.setPriority(30);
        }
        return this.serviceMonitoringJob;
    }

    protected class ServiceLaunchRunnable
    implements Runnable {
        private boolean stopRequested = false;
        private ROSNode rosNode = null;
        private ROSService<?, ?> service = null;

        public ServiceLaunchRunnable(ROSNode rosNode, ROSService<?, ?> service) {
            this.rosNode = rosNode;
            this.service = service;
        }

        @Override
        public void run() {
            boolean success = false;
            int tries = 0;
            while (!this.stopRequested && !success) {
                try {
                    this.service.setServiceState(ROSServiceState.INITIALIZING);
                    this.service.launch(this.rosNode);
                    success = true;
                    Logger.info("Service <" + this.service.getServiceName() + "> is running.");
                }
                catch (Exception e) {
                    this.service.setServiceState(ROSServiceState.INITIALIZING);
                    success = false;
                    if (tries == 0) {
                        Logger.error("Failed to launch service <" + this.service.getServiceName() + ">, trying again.", (Throwable)e);
                    }
                    ++tries;
                    if (this.stopRequested) continue;
                    try {
                        Thread.sleep(WAIT_TIME_BETWEEN_TRIES_MS);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }

        public void stop() {
            this.stopRequested = true;
        }
    }
}

